/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.jmac;

import com.sun.enterprise.config.serverbeans.MessageSecurityConfig;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.security.auth.message.config.AuthConfigFactory;
import java.beans.PropertyChangeEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@RunLevel(value=10)
public class MessageSecurityConfigEventListenerImpl
implements ConfigListener {
    private static final Logger LOG = LogDomains.getLogger(MessageSecurityConfigEventListenerImpl.class, "jakarta.enterprise.system.core.security", false);
    @Inject
    @Named(value="default-instance-name")
    private SecurityService service;

    @Override
    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        ConfigSupport.sortAndDispatch(events, new Changed(){

            @Override
            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type2, Class<T> changedType, T changedInstance) {
                switch (type2) {
                    case ADD: {
                        LOG.log(Level.FINE, () -> "A new " + changedType.getName() + " was added: " + String.valueOf(changedInstance));
                        return MessageSecurityConfigEventListenerImpl.this.handle(changedInstance);
                    }
                    case CHANGE: {
                        LOG.log(Level.FINE, () -> "A " + changedType.getName() + " was changed: " + String.valueOf(changedInstance));
                        return MessageSecurityConfigEventListenerImpl.this.handle(changedInstance);
                    }
                    case REMOVE: {
                        LOG.log(Level.FINE, () -> "A " + changedType.getName() + " was removed: " + String.valueOf(changedInstance));
                        return MessageSecurityConfigEventListenerImpl.this.handle(changedInstance);
                    }
                }
                return null;
            }
        }, LOG);
        return null;
    }

    private <T extends ConfigBeanProxy> NotProcessed handle(T instance) {
        if (instance instanceof MessageSecurityConfig) {
            AuthConfigFactory factory = AuthConfigFactory.getFactory();
            if (factory != null) {
                factory.refresh();
            }
            return null;
        }
        return new NotProcessed("unimplemented: unknown instance: " + instance.getClass().getName());
    }
}

