/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.security.auth.realm.exceptions.BadRealmException;
import com.sun.enterprise.security.auth.realm.exceptions.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.security.cli.CLIUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="create-file-user")
@PerLookup
@I18n(value="create.file.user")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=AuthRealm.class, opType=RestEndpoint.OpType.POST, path="create-user", description="Create", params={@RestParam(name="authrealmname", value="$parent")})})
public class CreateFileUser
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateFileUser.class);
    @Param(name="groups", optional=true, separator=58)
    private List<String> groups = new ArrayList<String>(0);
    @Param(name="userpassword", password=true)
    private String userpassword;
    @Param(name="authrealmname", optional=true)
    private String authRealmName;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;
    @Param(name="username", primary=true)
    private String userName;
    @Inject
    @Named(value="default-instance-name")
    private Config config;
    @Inject
    private Domain domain;
    @Inject
    private RealmsManager realmsManager;
    @Inject
    private ServerEnvironment se;
    @Inject
    private AdminService adminService;
    private SecureAdmin secureAdmin = null;
    @AccessRequired.To(value={"update"})
    private AuthRealm fileAuthRealm;
    private SecurityService securityService;

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        this.config = CLIUtil.chooseConfig(this.domain, this.target, context.getActionReport());
        if (this.config == null) {
            return false;
        }
        this.securityService = this.config.getSecurityService();
        this.fileAuthRealm = CLIUtil.findRealm(this.securityService, this.authRealmName);
        if (this.fileAuthRealm == null) {
            ActionReport report = context.getActionReport();
            report.setMessage(localStrings.getLocalString("create.file.user.filerealmnotfound", "File realm {0} does not exist", this.authRealmName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        this.authRealmName = this.fileAuthRealm.getName();
        return true;
    }

    @Override
    public void execute(AdminCommandContext context) {
        final ActionReport report = context.getActionReport();
        String fileRealmClassName = this.fileAuthRealm.getClassname();
        if (fileRealmClassName != null && !fileRealmClassName.equals("com.sun.enterprise.security.auth.realm.file.FileRealm")) {
            report.setMessage(localStrings.getLocalString("create.file.user.realmnotsupported", "Configured file realm {0} is not supported.", fileRealmClassName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String keyFile = null;
        for (Property fileProp : this.fileAuthRealm.getProperty()) {
            if (!fileProp.getName().equals("file")) continue;
            keyFile = fileProp.getValue();
        }
        String kf = keyFile;
        if (keyFile == null) {
            report.setMessage(localStrings.getLocalString("create.file.user.keyfilenotfound", "There is no physical file associated with this file realm {0} ", this.authRealmName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        boolean exists = new File(kf).exists();
        if (!exists) {
            report.setMessage(localStrings.getLocalString("file.realm.keyfilenonexistent", "The specified physical file {0} associated with the file realm {1} does not exist.", kf, this.authRealmName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        final String password = this.userpassword;
        if (password == null) {
            report.setMessage(localStrings.getLocalString("create.file.user.keyfilenotreadable", "Password for user {0} has to be specified in --userpassword option or supplied through AS_ADMIN_USERPASSWORD property in the file specified in --passwordfile option", this.userName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        this.secureAdmin = this.domain.getSecureAdmin();
        if (SecureAdmin.isEnabled(this.secureAdmin) && this.authRealmName.equals(this.adminService.getAuthRealmName()) && password.isEmpty()) {
            report.setMessage(localStrings.getLocalString("null_empty_password", "The admin user password is null or empty"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<SecurityService>(){

                @Override
                public Object run(SecurityService param) throws PropertyVetoException, TransactionFailure {
                    try {
                        FileRealm fr;
                        block4: {
                            CreateFileUser.this.realmsManager.createRealms(CreateFileUser.this.config);
                            CreateFileUser.refreshRealm(CreateFileUser.this.config.getName(), CreateFileUser.this.authRealmName);
                            fr = (FileRealm)CreateFileUser.this.realmsManager.getFromLoadedRealms(CreateFileUser.this.config.getName(), CreateFileUser.this.authRealmName);
                            CreateFileUser.handleAdminGroup(CreateFileUser.this.authRealmName, CreateFileUser.this.groups);
                            String[] groups1 = CreateFileUser.this.groups.toArray(new String[CreateFileUser.this.groups.size()]);
                            try {
                                fr.addUser(CreateFileUser.this.userName, password.toCharArray(), groups1);
                            }
                            catch (BadRealmException br) {
                                if (CreateFileUser.this.se == null || !CreateFileUser.this.se.isDas()) break block4;
                                throw new BadRealmException(br);
                            }
                        }
                        fr.persist();
                        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                    }
                    catch (Exception e) {
                        String localalizedErrorMsg = e.getLocalizedMessage() == null ? "" : e.getLocalizedMessage();
                        report.setMessage(localStrings.getLocalString("create.file.user.useraddfailed", "Adding User {0} to the file realm {1} failed", CreateFileUser.this.userName, CreateFileUser.this.authRealmName) + "  " + localalizedErrorMsg);
                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        report.setFailureCause(e);
                    }
                    return null;
                }
            }, this.securityService);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("create.file.user.useraddfailed", "Adding User {0} to the file realm {1} failed", this.userName, this.authRealmName) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
    }

    public static void refreshRealm(String configName, String realmName) {
        if (realmName != null && realmName.length() > 0) {
            try {
                Realm realm = Realm.getInstance(configName, realmName);
                if (realm != null) {
                    realm.refresh(configName);
                }
            }
            catch (NoSuchRealmException noSuchRealmException) {
            }
            catch (BadRealmException badRealmException) {
                // empty catch block
            }
        }
    }

    static void handleAdminGroup(String lr, List<String> lg) {
        String fr = "admin-realm";
        String fg = "asadmin";
        if (fr.equals(lr) && lg != null) {
            lg.clear();
            lg.add(fg);
        }
    }
}

