/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login;

import com.sun.enterprise.common.iiop.security.AnonCredential;
import com.sun.enterprise.common.iiop.security.GSSUPName;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.security.auth.login.AssertedCredentials;
import com.sun.enterprise.security.auth.login.DigestCredentials;
import com.sun.enterprise.security.auth.login.common.LoginException;
import com.sun.enterprise.security.auth.login.common.PasswordCredential;
import com.sun.enterprise.security.auth.login.common.ServerLoginCallbackHandler;
import com.sun.enterprise.security.auth.login.common.X509CertificateCredential;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.certificate.CertificateRealm;
import com.sun.enterprise.security.auth.realm.exceptions.InvalidOperationException;
import com.sun.enterprise.security.auth.realm.exceptions.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.exceptions.NoSuchUserException;
import com.sun.enterprise.security.common.AppservAccessController;
import com.sun.enterprise.security.common.ClientSecurityContext;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.x500.X500Principal;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.UserNameAndPassword;

public class LoginContextDriver {
    private static final Logger LOG = SecurityLoggerInfo.getLogger();
    private static final ServerLoginCallbackHandler dummyCallback = new ServerLoginCallbackHandler();
    public static final String CERT_REALMNAME = "certificate";
    private static volatile AuditManager AUDIT_MANAGER;

    private LoginContextDriver() {
    }

    private static AuditManager getAuditManager() {
        if (AUDIT_MANAGER != null) {
            return AUDIT_MANAGER;
        }
        return LoginContextDriver._getAuditManager();
    }

    private static synchronized AuditManager _getAuditManager() {
        if (AUDIT_MANAGER == null) {
            SecurityServicesUtil secServUtil = Globals.get(SecurityServicesUtil.class);
            AUDIT_MANAGER = secServUtil.getAuditManager();
        }
        return AUDIT_MANAGER;
    }

    public static void login(String username, char[] password, String realmName) {
        if (realmName == null || !Realm.isValidRealm(realmName)) {
            realmName = Realm.getDefaultRealm();
        }
        final Subject fs = new Subject();
        final PasswordCredential pc = new PasswordCredential(username, password, realmName);
        AppservAccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                fs.getPrivateCredentials().add(pc);
                return fs;
            }
        });
        LoginContextDriver.login(fs, PasswordCredential.class);
    }

    public static void login(AssertedCredentials asrtCred) throws javax.security.auth.login.LoginException {
        Subject subject = new Subject();
        subject.getPrivateCredentials().add(asrtCred);
        String jaasCtx = null;
        try {
            jaasCtx = Realm.getInstance(asrtCred.getRealmName()).getJAASContext();
        }
        catch (Exception ex) {
            if (ex instanceof LoginException) {
                throw (LoginException)ex;
            }
            throw new LoginException("Failed obtaining the JAAS Context", ex);
        }
        try {
            LoginContext lg = new LoginContext(jaasCtx, subject, dummyCallback);
            lg.login();
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, "NCLS-SECURITY-05046", asrtCred.getUserName());
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "doPasswordLogin fails", e);
            }
            if (AUDIT_MANAGER.isAuditOn()) {
                AUDIT_MANAGER.authentication(asrtCred.getUserName(), asrtCred.getRealmName(), false);
            }
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            throw new LoginException("Login failed: " + e.getMessage(), e);
        }
        LoginContextDriver.setSecurityContext(asrtCred.getUserName(), subject, asrtCred.getRealmName());
    }

    public static void login(Subject subject, Class cls) throws LoginException {
        LOG.log(Level.FINEST, "Processing login with credentials of type: {0}", cls);
        if (cls.equals(PasswordCredential.class)) {
            LoginContextDriver.doPasswordLogin(subject);
        } else if (cls.equals(X509CertificateCredential.class)) {
            LoginContextDriver.doCertificateLogin(subject);
        } else if (cls.equals(AnonCredential.class)) {
            LoginContextDriver.doAnonLogin();
        } else if (cls.equals(GSSUPName.class)) {
            LoginContextDriver.doGSSUPLogin(subject);
        } else if (cls.equals(X500Principal.class)) {
            LoginContextDriver.doX500Login(subject, null);
        } else {
            LOG.log(Level.INFO, "NCLS-SECURITY-05019", cls.toString());
            throw new LoginException("Unknown credential type " + String.valueOf(cls) + ", cannot login.");
        }
    }

    public static void loginPrincipal(String username, String realmName) throws LoginException {
        if (realmName == null || realmName.isEmpty()) {
            realmName = Realm.getDefaultRealm();
        }
        final Subject s = new Subject();
        final UserNameAndPassword p = new UserNameAndPassword(username);
        final GSSUPName name = new GSSUPName(username, realmName);
        AppservAccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                s.getPrincipals().add(p);
                s.getPublicCredentials().add(name);
                return null;
            }
        });
        try {
            Realm realm = Realm.getInstance(realmName);
            Enumeration<String> en = realm.getGroupNames(username);
            Set<Principal> principalSet = s.getPrincipals();
            while (en.hasMoreElements()) {
                principalSet.add(new Group(en.nextElement()));
            }
        }
        catch (InvalidOperationException ex) {
            LOG.log(Level.WARNING, "NCLS-SECURITY-01150", new Object[]{username, realmName, ex.toString()});
        }
        catch (NoSuchUserException ex) {
            LOG.log(Level.WARNING, "NCLS-SECURITY-01151", new Object[]{username, realmName, ex.toString()});
        }
        catch (NoSuchRealmException ex) {
            throw new LoginException(ex.toString(), ex);
        }
        LoginContextDriver.setSecurityContext(username, s, realmName);
    }

    public static void logout() throws LoginException {
        LoginContextDriver.unsetSecurityContext();
    }

    private static void doPasswordLogin(Subject subject) throws LoginException {
        Subject s = subject;
        Object obj = LoginContextDriver.getPrivateCredentials(s, PasswordCredential.class);
        assert (obj != null);
        PasswordCredential p = (PasswordCredential)obj;
        String user = p.getUser();
        char[] pwd = p.getPassword();
        String realm = p.getRealm();
        String jaasCtx = null;
        try {
            jaasCtx = Realm.getInstance(realm).getJAASContext();
        }
        catch (Exception ex) {
            if (ex instanceof LoginException) {
                throw (LoginException)ex;
            }
            throw new LoginException("Failed obtaining the JAAS Context", ex);
        }
        assert (user != null);
        assert (pwd != null);
        assert (realm != null);
        assert (jaasCtx != null);
        LOG.log(Level.FINE, "Logging in user {0} into realm {1} using JAAS module {2}", new Object[]{user, realm, jaasCtx});
        try {
            LoginContext lg = new LoginContext(jaasCtx, s, dummyCallback);
            lg.login();
        }
        catch (Exception e) {
            LOG.log(Level.FINEST, "doPasswordLogin fails", e);
            if (LoginContextDriver.getAuditManager() != null && LoginContextDriver.getAuditManager().isAuditOn()) {
                LoginContextDriver.getAuditManager().authentication(user, realm, false);
            }
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            throw new LoginException("Login failed: " + e.getMessage(), e);
        }
        if (LoginContextDriver.getAuditManager() != null && LoginContextDriver.getAuditManager().isAuditOn()) {
            LoginContextDriver.getAuditManager().authentication(user, realm, true);
        }
        LOG.log(Level.FINE, "Password login succeeded for {0}", user);
        LoginContextDriver.setSecurityContext(user, s, realm);
        LOG.log(Level.FINE, "Set security context as user {0}", user);
    }

    public static void jmacLogin(Subject subject, Principal callerPrincipal, String realmName) throws LoginException {
        if (CERT_REALMNAME.equals(realmName)) {
            if (callerPrincipal instanceof X500Principal) {
                LoginContextDriver.jmacLogin(subject, (X500Principal)callerPrincipal);
            }
        } else if (!callerPrincipal.equals(SecurityContext.getDefaultCallerPrincipal())) {
            LoginContextDriver.jmacLogin(subject, callerPrincipal.getName(), realmName);
        }
    }

    public static Subject jmacLogin(Subject subject, String username, char[] password, String realmName) throws LoginException {
        if (realmName == null || !Realm.isValidRealm(realmName)) {
            realmName = Realm.getDefaultRealm();
        }
        if (subject == null) {
            subject = new Subject();
        }
        final Subject fs = subject;
        final PasswordCredential pc = new PasswordCredential(username, password, realmName);
        AppservAccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                fs.getPrivateCredentials().add(pc);
                return fs;
            }
        });
        String jaasCtx = null;
        try {
            jaasCtx = Realm.getInstance(realmName).getJAASContext();
        }
        catch (Exception ex) {
            if (ex instanceof LoginException) {
                throw (LoginException)ex;
            }
            throw new LoginException("Failed obtaining the JAAS Context", ex);
        }
        LOG.log(Level.FINE, "JMAC login user {0} into realm {1} using JAAS module {2}", new Object[]{username, realmName, jaasCtx});
        try {
            LoginContext lg = new LoginContext(jaasCtx, fs, dummyCallback);
            lg.login();
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "NCLS-SECURITY-05046", username);
            if (LoginContextDriver.getAuditManager().isAuditOn()) {
                LoginContextDriver.getAuditManager().authentication(username, realmName, false);
            }
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            throw new LoginException("Login failed: " + e.getMessage(), e);
        }
        if (LoginContextDriver.getAuditManager().isAuditOn()) {
            LoginContextDriver.getAuditManager().authentication(username, realmName, true);
        }
        LOG.log(Level.FINE, "jmac Password login succeeded for {0}", username);
        return subject;
    }

    public static Subject jmacLogin(Subject subject, final X500Principal x500Principal) throws LoginException {
        if (subject == null) {
            subject = new Subject();
        }
        final Subject fs = subject;
        String userName = "";
        try {
            userName = x500Principal.getName();
            AppservAccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    fs.getPublicCredentials().add(x500Principal);
                    return fs;
                }
            });
            Realm realm = Realm.getInstance(CERT_REALMNAME);
            CertificateRealm certRealm = (CertificateRealm)realm;
            String jaasCtx = certRealm.getJAASContext();
            if (jaasCtx != null) {
                LoginContext lg = new LoginContext(jaasCtx, fs, dummyCallback);
                lg.login();
            }
            certRealm.authenticate(fs, x500Principal);
        }
        catch (Exception ex) {
            LOG.log(Level.INFO, "NCLS-SECURITY-05046", userName);
            if (LoginContextDriver.getAuditManager().isAuditOn()) {
                LoginContextDriver.getAuditManager().authentication(userName, CERT_REALMNAME, false);
            }
            if (ex instanceof LoginException) {
                throw (LoginException)ex;
            }
            throw new LoginException("Authentication failed.", ex);
        }
        LOG.log(Level.FINE, "JMAC cert login succeeded for {0}", userName);
        if (LoginContextDriver.getAuditManager().isAuditOn()) {
            LoginContextDriver.getAuditManager().authentication(userName, CERT_REALMNAME, true);
        }
        return subject;
    }

    public static Subject jmacLogin(Subject subject, String identityAssertion, String realm) throws LoginException {
        block5: {
            if (subject == null) {
                subject = new Subject();
            }
            final Subject fs = subject;
            String userName = identityAssertion;
            try {
                Realm realmInst;
                Enumeration<String> groups;
                if (realm == null || "".equals(realm)) {
                    realm = Realm.getDefaultRealm();
                }
                if ((groups = (realmInst = Realm.getInstance(realm)).getGroupNames(userName)) != null && groups.hasMoreElements()) {
                    AppservAccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            while (groups.hasMoreElements()) {
                                String grp = (String)groups.nextElement();
                                fs.getPrincipals().add(new Group(grp));
                            }
                            return fs;
                        }
                    });
                }
            }
            catch (Exception ex) {
                if (!LOG.isLoggable(Level.FINE)) break block5;
                LOG.log(Level.FINE, "Exception when trying to populate groups for CallerPrincipal " + identityAssertion, ex);
            }
        }
        return subject;
    }

    private static void doCertificateLogin(Subject s) throws LoginException {
        LOG.log(Level.FINE, "Processing X509 certificate login.");
        String realm = CERT_REALMNAME;
        String user = null;
        try {
            Object obj = LoginContextDriver.getPublicCredentials(s, X509CertificateCredential.class);
            X509CertificateCredential xp = (X509CertificateCredential)obj;
            user = xp.getAlias();
            LOG.log(Level.FINE, "Set security context as user {0}", user);
            LoginContextDriver.setSecurityContext(user, s, realm);
            if (LoginContextDriver.getAuditManager().isAuditOn()) {
                LoginContextDriver.getAuditManager().authentication(user, realm, true);
            }
        }
        catch (LoginException le) {
            if (LoginContextDriver.getAuditManager().isAuditOn()) {
                LoginContextDriver.getAuditManager().authentication(user, realm, false);
            }
            throw le;
        }
    }

    private static void doAnonLogin() throws LoginException {
        SecurityContext.setUnauthenticatedContext();
        LOG.log(Level.FINE, "Set anonymous security context.");
    }

    private static void doGSSUPLogin(Subject s) throws LoginException {
        LOG.fine("Processing GSSUP login.");
        String user = null;
        String realm = Realm.getDefaultRealm();
        try {
            Object obj = LoginContextDriver.getPublicCredentials(s, GSSUPName.class);
            user = ((GSSUPName)obj).getUser();
            LoginContextDriver.setSecurityContext(user, s, realm);
            if (LoginContextDriver.getAuditManager().isAuditOn()) {
                LoginContextDriver.getAuditManager().authentication(user, realm, true);
            }
            LOG.log(Level.FINE, "GSSUP login succeeded for {0}", user);
        }
        catch (LoginException le) {
            if (LoginContextDriver.getAuditManager().isAuditOn()) {
                LoginContextDriver.getAuditManager().authentication(user, realm, false);
            }
            throw le;
        }
    }

    public static void doX500Login(Subject s, String appModuleID) throws LoginException {
        LOG.log(Level.FINE, "Processing X.500 name login for appModuleID={0}.", appModuleID);
        String user = null;
        String realm_name = null;
        try {
            X500Principal x500Principal = (X500Principal)LoginContextDriver.getPublicCredentials(s, X500Principal.class);
            user = x500Principal.getName();
            Realm realm = Realm.getInstance(CERT_REALMNAME);
            if (realm instanceof CertificateRealm) {
                CertificateRealm certRealm = (CertificateRealm)realm;
                String jaasCtx = certRealm.getJAASContext();
                if (jaasCtx != null) {
                    LoginContext lg = new LoginContext(jaasCtx, s, new ServerLoginCallbackHandler(user, null, appModuleID));
                    lg.login();
                }
                certRealm.authenticate(s, x500Principal);
                realm_name = CERT_REALMNAME;
                if (LoginContextDriver.getAuditManager().isAuditOn()) {
                    LoginContextDriver.getAuditManager().authentication(user, realm_name, true);
                }
            } else {
                LOG.warning("NCLS-SECURITY-01050");
                realm_name = realm.getName();
                LoginContextDriver.setSecurityContext(user, s, realm_name);
            }
            LOG.log(Level.FINE, "X.500 name login succeeded for: {0}", user);
        }
        catch (LoginException le) {
            if (LoginContextDriver.getAuditManager().isAuditOn()) {
                LoginContextDriver.getAuditManager().authentication(user, realm_name, false);
            }
            throw le;
        }
        catch (Exception ex) {
            throw new LoginException("Login failed", ex);
        }
    }

    private static Object getPublicCredentials(Subject s, Class<?> cls) throws LoginException {
        Set<?> credset = s.getPublicCredentials(cls);
        final Iterator<?> iter = credset.iterator();
        if (!iter.hasNext()) {
            throw new LoginException("Expected public credential of type: " + String.valueOf(cls) + " but none found.");
        }
        Object obj = null;
        try {
            obj = AppservAccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return iter.next();
                }
            });
        }
        catch (Exception e) {
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            throw new LoginException("Failed to retrieve public credential: " + e.getMessage(), e);
        }
        return obj;
    }

    private static Object getPrivateCredentials(Subject subject, Class<?> cls) throws LoginException {
        final Subject s = subject;
        final Class<?> cl = cls;
        Set credset = (Set)AppservAccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return s.getPrivateCredentials(cl);
            }
        });
        final Iterator iter = credset.iterator();
        if (!iter.hasNext()) {
            throw new LoginException("Expected private credential of type: " + String.valueOf(cls) + " but none found.");
        }
        Object obj = null;
        try {
            obj = AppservAccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return iter.next();
                }
            });
        }
        catch (Exception e) {
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            throw new LoginException("Failed to retrieve private credential: " + e.getMessage(), e);
        }
        return obj;
    }

    private static void setSecurityContext(String userName, Subject subject, String realm) {
        SecurityContext securityContext = new SecurityContext(userName, subject, realm);
        SecurityContext.setCurrent(securityContext);
    }

    private static void unsetSecurityContext() {
        SecurityContext.setCurrent(null);
    }

    public static Subject doClientLogin(int type2, CallbackHandler jaasHandler) throws LoginException {
        final CallbackHandler handler = jaasHandler;
        final Subject subject = new Subject();
        if (type2 == 1) {
            AppservAccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        LoginContext lg = new LoginContext("default", subject, handler);
                        lg.login();
                    }
                    catch (javax.security.auth.login.LoginException e) {
                        throw new LoginException(e.getMessage(), e);
                    }
                    return null;
                }
            });
            LoginContextDriver.postClientAuth(subject, PasswordCredential.class);
            return subject;
        }
        if (type2 == 2) {
            AppservAccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        LoginContext lg = new LoginContext(LoginContextDriver.CERT_REALMNAME, subject, handler);
                        lg.login();
                    }
                    catch (javax.security.auth.login.LoginException e) {
                        throw new LoginException(e.getMessage(), e);
                    }
                    return null;
                }
            });
            LoginContextDriver.postClientAuth(subject, X509CertificateCredential.class);
            return subject;
        }
        if (type2 == 3) {
            AppservAccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        LoginContext lgup = new LoginContext("default", subject, handler);
                        LoginContext lgc = new LoginContext(LoginContextDriver.CERT_REALMNAME, subject, handler);
                        lgup.login();
                        LoginContextDriver.postClientAuth(subject, PasswordCredential.class);
                        lgc.login();
                        LoginContextDriver.postClientAuth(subject, X509CertificateCredential.class);
                    }
                    catch (javax.security.auth.login.LoginException e) {
                        throw new LoginException(e.getMessage(), e);
                    }
                    return null;
                }
            });
            return subject;
        }
        AppservAccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    LoginContext lg = new LoginContext("default", subject, handler);
                    lg.login();
                    LoginContextDriver.postClientAuth(subject, PasswordCredential.class);
                }
                catch (javax.security.auth.login.LoginException e) {
                    throw new LoginException(e.getMessage(), e);
                }
                return null;
            }
        });
        return subject;
    }

    public static void doClientLogout() throws LoginException {
        LoginContextDriver.unsetClientSecurityContext();
    }

    public static void login(DigestCredentials digestCred) {
        Subject subject = new Subject();
        subject.getPrivateCredentials().add(digestCred);
        String jaasCtx = null;
        try {
            jaasCtx = Realm.getInstance(digestCred.getRealmName()).getJAASContext();
        }
        catch (Exception ex) {
            if (ex instanceof LoginException) {
                throw (LoginException)ex;
            }
            throw new LoginException("Failed obtaining the JAAS context.", ex);
        }
        try {
            LoginContext lg = new LoginContext(jaasCtx, subject, dummyCallback);
            lg.login();
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "NCLS-SECURITY-05046", digestCred.getUserName());
            LOG.log(Level.FINEST, "doPasswordLogin failed", e);
            if (LoginContextDriver.getAuditManager().isAuditOn()) {
                LoginContextDriver.getAuditManager().authentication(digestCred.getUserName(), digestCred.getRealmName(), false);
            }
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            throw new LoginException("Login failed: " + e.getMessage(), e);
        }
        LoginContextDriver.setSecurityContext(digestCred.getUserName(), subject, digestCred.getRealmName());
    }

    private static void postClientAuth(Subject subject, Class<?> clazz) {
        PrivilegedAction<Set> action = () -> {
            LOG.log(Level.FINEST, "LCD post login subject: {0}", subject);
            return subject.getPrivateCredentials(clazz);
        };
        Set credset = AppservAccessController.doPrivileged(action);
        Iterator iter = credset.iterator();
        while (iter.hasNext()) {
            Object p;
            Object obj;
            try {
                PrivilegedAction<Object> iteratorNextAction = () -> iter.next();
                obj = AppservAccessController.doPrivileged(iteratorNextAction);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "NCLS-SECURITY-05043", e);
                continue;
            }
            if (obj instanceof PasswordCredential) {
                p = (PasswordCredential)obj;
                String user = ((PasswordCredential)p).getUser();
                LOG.log(Level.FINEST, "In LCD user-pass login: {0}, realm: {1}", new Object[]{user, ((PasswordCredential)p).getRealm()});
                LoginContextDriver.setClientSecurityContext(user, subject);
                return;
            }
            if (!(obj instanceof X509CertificateCredential)) continue;
            p = (X509CertificateCredential)obj;
            String user = ((X509CertificateCredential)p).getAlias();
            LOG.log(Level.FINEST, "In LCD cert-login: {0}, realm: {1}", new Object[]{user, ((X509CertificateCredential)p).getRealm()});
            LoginContextDriver.setClientSecurityContext(user, subject);
            return;
        }
    }

    private static void setClientSecurityContext(String username, Subject subject) {
        ClientSecurityContext securityContext = new ClientSecurityContext(username, subject);
        ClientSecurityContext.setCurrent(securityContext);
    }

    private static void unsetClientSecurityContext() {
        ClientSecurityContext.setCurrent(null);
    }
}

