/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.monitor;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectionPoolMonitoringExtension;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.resource.listener.PoolLifeCycle;
import com.sun.enterprise.resource.pool.PoolLifeCycleListenerRegistry;
import com.sun.enterprise.resource.pool.PoolLifeCycleRegistry;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.enterprise.resource.pool.ResourcePool;
import com.sun.enterprise.resource.pool.monitor.ConnectionPoolAppProbeProvider;
import com.sun.enterprise.resource.pool.monitor.ConnectionPoolEmitterImpl;
import com.sun.enterprise.resource.pool.monitor.ConnectionPoolProbeProvider;
import com.sun.enterprise.resource.pool.monitor.ConnectionPoolProbeProviderUtil;
import com.sun.enterprise.resource.pool.monitor.ConnectorConnPoolStatsProvider;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.connectors.config.ConnectorConnectionPool;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class ConnectionPoolStatsProviderBootstrap
implements PostConstruct,
PoolLifeCycle {
    protected static final Logger logger = LogDomains.getLogger(ConnectionPoolStatsProviderBootstrap.class, "jakarta.enterprise.resource.resourceadapter");
    @Inject
    private PoolManager poolManager;
    @Inject
    private Provider<Domain> domainProvider;
    @Inject
    private Provider<ConnectionPoolProbeProviderUtil> connectionPoolProbeProviderUtilProvider;
    @Inject
    private ServiceLocator habitat;
    private final List<ConnectorConnPoolStatsProvider> ccStatsProviders = new ArrayList<ConnectorConnPoolStatsProvider>();
    private final Map<PoolInfo, ConnectionPoolEmitterImpl> poolEmitters = new HashMap<PoolInfo, ConnectionPoolEmitterImpl>();
    private final Map<PoolInfo, PoolLifeCycleListenerRegistry> poolRegistries = new HashMap<PoolInfo, PoolLifeCycleListenerRegistry>();
    private final ConnectorRuntime runtime = ConnectorRuntime.getRuntime();

    public void addToPoolEmitters(PoolInfo poolInfo, ConnectionPoolEmitterImpl emitter) {
        this.poolEmitters.put(poolInfo, emitter);
    }

    public void registerProvider() {
        this.registerPoolLifeCycleListener();
    }

    @Override
    public void postConstruct() {
        logger.finest("[Monitor]In the ConnectionPoolStatsProviderBootstrap");
    }

    public PoolLifeCycleListenerRegistry registerPool(PoolInfo poolInfo, ConnectionPoolProbeProvider poolProvider) {
        PoolLifeCycleListenerRegistry poolRegistry;
        if (this.poolRegistries.get(poolInfo) == null) {
            poolRegistry = new PoolLifeCycleListenerRegistry(poolInfo);
            this.poolRegistries.put(poolInfo, poolRegistry);
        } else {
            poolRegistry = this.poolRegistries.get(poolInfo);
        }
        ConnectionPoolEmitterImpl emitter = new ConnectionPoolEmitterImpl(poolInfo, poolProvider);
        poolRegistry.registerPoolLifeCycleListener(emitter);
        this.addToPoolEmitters(poolInfo, emitter);
        return poolRegistry;
    }

    public ConnectionPoolAppProbeProvider registerPool(PoolInfo poolInfo, String appName) {
        ConnectionPoolAppProbeProvider probeAppProvider = null;
        List<ConnectionPoolMonitoringExtension> extensions = this.habitat.getAllServices(ConnectionPoolMonitoringExtension.class, new Annotation[0]);
        for (ConnectionPoolMonitoringExtension extension : extensions) {
            probeAppProvider = extension.registerConnectionPool(poolInfo, appName);
        }
        return probeAppProvider;
    }

    public Resources getResources() {
        return this.domainProvider.get().getResources();
    }

    public ConnectionPoolProbeProviderUtil getProbeProviderUtil() {
        return this.connectionPoolProbeProviderUtilProvider.get();
    }

    private void registerCcPool(PoolInfo poolInfo) {
        this.getProbeProviderUtil().createJcaProbeProvider();
        ConnectorConnPoolStatsProvider ccPoolStatsProvider = new ConnectorConnPoolStatsProvider(poolInfo, logger);
        StatsProviderManager.register("connector-connection-pool", PluginPoint.SERVER, ConnectorsUtil.getPoolMonitoringSubTreeRoot(poolInfo, true), ccPoolStatsProvider);
        PoolLifeCycleListenerRegistry registry = this.registerPool(poolInfo, this.getProbeProviderUtil().getJcaProbeProvider());
        ccPoolStatsProvider.setPoolRegistry(registry);
        this.ccStatsProviders.add(ccPoolStatsProvider);
        if (ConnectorsUtil.isApplicationScopedResource(poolInfo)) {
            return;
        }
        ResourcesUtil resourcesUtil = ResourcesUtil.createInstance();
        com.sun.enterprise.config.serverbeans.ResourcePool pool = resourcesUtil.getPoolConfig(poolInfo);
        Resources resources = resourcesUtil.getResources(poolInfo);
        String raName = resourcesUtil.getRarNameOfResource(pool, resources);
        ConnectorConnPoolStatsProvider connectorServicePoolStatsProvider = new ConnectorConnPoolStatsProvider(poolInfo, logger);
        String dottedNamesHierarchy = null;
        String monitoringModuleName = null;
        if (ConnectorsUtil.isJMSRA(raName)) {
            monitoringModuleName = "jms-service";
            dottedNamesHierarchy = "jms-service/connection-factories/" + ConnectorsUtil.escapeResourceNameForMonitoring(poolInfo.getName());
        } else {
            monitoringModuleName = "connector-service";
            dottedNamesHierarchy = "connector-service/" + raName + "/" + ConnectorsUtil.escapeResourceNameForMonitoring(poolInfo.getName());
        }
        StatsProviderManager.register(monitoringModuleName, PluginPoint.SERVER, dottedNamesHierarchy, connectorServicePoolStatsProvider);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Registered pool-monitoring stats [ " + dottedNamesHierarchy + " ]  for [ " + raName + " ] with monitoring-stats-registry.");
        }
        connectorServicePoolStatsProvider.setPoolRegistry(registry);
        this.ccStatsProviders.add(connectorServicePoolStatsProvider);
    }

    private void registerPoolLifeCycleListener() {
        if (this.runtime.isServer()) {
            PoolLifeCycleRegistry poolLifeCycleRegistry = PoolLifeCycleRegistry.getRegistry();
            poolLifeCycleRegistry.registerPoolLifeCycle(this);
        }
    }

    private void unregisterPool(PoolInfo poolInfo) {
        if (this.ccStatsProviders != null) {
            Iterator<ConnectorConnPoolStatsProvider> i = this.ccStatsProviders.iterator();
            while (i.hasNext()) {
                ConnectorConnPoolStatsProvider ccPoolStatsProvider = i.next();
                if (!poolInfo.equals(ccPoolStatsProvider.getPoolInfo())) continue;
                PoolLifeCycleListenerRegistry poolRegistry = ccPoolStatsProvider.getPoolRegistry();
                poolRegistry.unRegisterPoolLifeCycleListener(poolInfo);
                StatsProviderManager.unregister(ccPoolStatsProvider);
                i.remove();
            }
        }
        this.postUnregisterPool(poolInfo);
    }

    public void unRegisterPool() {
        List<ConnectionPoolMonitoringExtension> extensions = this.habitat.getAllServices(ConnectionPoolMonitoringExtension.class, new Annotation[0]);
        for (ConnectionPoolMonitoringExtension extension : extensions) {
            extension.unRegisterConnectionPool();
        }
    }

    public void postUnregisterPool(PoolInfo poolInfo) {
        this.unregisterPoolAppProviders(poolInfo);
        this.poolRegistries.remove(poolInfo);
    }

    public void unregisterPoolAppProviders(PoolInfo poolInfo) {
        ConnectionPoolEmitterImpl emitter = this.poolEmitters.get(poolInfo);
        if (emitter != null) {
            emitter.unregisterAppStatsProviders();
        }
    }

    public boolean getEnabledValue(String enabled) {
        return !"OFF".equals(enabled);
    }

    @Override
    public void poolCreated(PoolInfo poolInfo) {
        logger.log(Level.FINEST, "Pool created: {0}", poolInfo);
        if (this.runtime.isServer()) {
            ResourcePool resource;
            com.sun.enterprise.config.serverbeans.ResourcePool pool = this.runtime.getConnectionPoolConfig(poolInfo);
            if (pool instanceof ConnectorConnectionPool && (resource = this.poolManager.getPool(poolInfo)) != null) {
                this.registerCcPool(poolInfo);
            }
            List<ConnectionPoolMonitoringExtension> extensions = this.habitat.getAllServices(ConnectionPoolMonitoringExtension.class, new Annotation[0]);
            for (ConnectionPoolMonitoringExtension extension : extensions) {
                extension.registerPool(poolInfo);
            }
        }
    }

    @Override
    public void poolDestroyed(PoolInfo poolInfo) {
        logger.log(Level.FINEST, "Pool destroyed: {0}", poolInfo);
        if (this.runtime.isServer()) {
            List<ConnectionPoolMonitoringExtension> extensions = this.habitat.getAllServices(ConnectionPoolMonitoringExtension.class, new Annotation[0]);
            for (ConnectionPoolMonitoringExtension extension : extensions) {
                extension.unregisterPool(poolInfo);
            }
            this.unregisterPool(poolInfo);
        }
    }
}

