/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ConnectionPoolObjectsUtils;
import com.sun.enterprise.connectors.util.ConnectorDDTransformUtils;
import com.sun.enterprise.connectors.util.SecurityMapUtils;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.resource.deployer.AbstractConnectorResourceDeployer;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.connectors.config.SecurityMap;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.util.ResourceUtil;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service
@ResourceDeployerInfo(value=org.glassfish.connectors.config.ConnectorConnectionPool.class)
@Singleton
public class ConnectorConnectionPoolDeployer
extends AbstractConnectorResourceDeployer<org.glassfish.connectors.config.ConnectorConnectionPool> {
    @Inject
    private ConnectorRuntime runtime;
    private static final Logger LOG = LogDomains.getLogger(ConnectorConnectionPoolDeployer.class, "jakarta.enterprise.resource.resourceadapter");
    private static final StringManager MESSAGES = StringManager.getManager(ConnectorConnectionPoolDeployer.class);
    private static final Locale locale = Locale.getDefault();

    @Override
    public void deployResource(org.glassfish.connectors.config.ConnectorConnectionPool resource, String applicationName, String moduleName) throws Exception {
        if (ConnectionPoolObjectsUtils.isPoolSystemPool(resource)) {
            this.redeployResource(resource);
            return;
        }
        SimpleJndiName jndiName = SimpleJndiName.of(resource.getName());
        PoolInfo poolInfo = new PoolInfo(jndiName, applicationName, moduleName);
        ConnectorConnectionPool ccp = this.getConnectorConnectionPool(resource, poolInfo);
        String rarName = resource.getResourceAdapterName();
        String connDefName = resource.getConnectionDefinitionName();
        List<Property> props = resource.getProperty();
        List<SecurityMap> securityMaps = resource.getSecurityMap();
        this.populateConnectorConnectionPool(ccp, connDefName, rarName, props, securityMaps);
        String defName = resource.getConnectionDefinitionName();
        this.runtime.createConnectorConnectionPool(ccp, defName, resource.getResourceAdapterName(), resource.getProperty(), resource.getSecurityMap());
        LOG.log(Level.CONFIG, "Added connectorConnectionPool in resource adapter {0}", resource.getResourceAdapterName());
    }

    @Override
    public void deployResource(org.glassfish.connectors.config.ConnectorConnectionPool resource) throws Exception {
        PoolInfo poolInfo = ResourceUtil.getPoolInfo(resource);
        this.deployResource(resource, poolInfo.getApplicationName(), poolInfo.getModuleName());
    }

    @Override
    public void undeployResource(org.glassfish.connectors.config.ConnectorConnectionPool domainCcp, String applicationName, String moduleName) throws Exception {
        SimpleJndiName jndiName = SimpleJndiName.of(domainCcp.getName());
        PoolInfo poolInfo = new PoolInfo(jndiName, applicationName, moduleName);
        this.actualUndeployResource(domainCcp, poolInfo);
    }

    @Override
    public synchronized void undeployResource(org.glassfish.connectors.config.ConnectorConnectionPool resource) throws Exception {
        PoolInfo poolInfo = ResourceUtil.getPoolInfo(resource);
        this.actualUndeployResource(resource, poolInfo);
    }

    private void actualUndeployResource(org.glassfish.connectors.config.ConnectorConnectionPool domainCcp, PoolInfo poolInfo) throws ConnectorRuntimeException {
        this.runtime.deleteConnectorConnectionPool(poolInfo);
        LOG.log(Level.FINE, "Deleted ConnectorConnectionPool in backend: {0}", domainCcp);
    }

    @Override
    public synchronized void redeployResource(org.glassfish.connectors.config.ConnectorConnectionPool resource) throws Exception {
        List<SecurityMap> securityMaps = resource.getSecurityMap();
        PoolInfo poolInfo = ResourceUtil.getPoolInfo(resource);
        if (!this.runtime.isConnectorConnectionPoolDeployed(poolInfo)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("The connector connection pool " + String.valueOf(poolInfo) + " is either not referred or not yet created in this server instance and pool and hence redeployment is ignored");
            }
            return;
        }
        String rarName = resource.getResourceAdapterName();
        String connDefName = resource.getConnectionDefinitionName();
        List<Property> props = resource.getProperty();
        ConnectorConnectionPool ccp = this.getConnectorConnectionPool(resource, poolInfo);
        this.populateConnectorConnectionPool(ccp, connDefName, rarName, props, securityMaps);
        boolean poolRecreateRequired = false;
        try {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Calling reconfigure pool");
            }
            poolRecreateRequired = this.runtime.reconfigureConnectorConnectionPool(ccp, new HashSet());
        }
        catch (ConnectorRuntimeException cre) {
            Object[] params = new Object[]{poolInfo, cre};
            LOG.log(Level.WARNING, "error.reconfiguring.pool", params);
        }
        if (poolRecreateRequired) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Pool recreation required");
            }
            this.runtime.recreateConnectorConnectionPool(ccp);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Pool recreation done");
            }
        }
    }

    @Override
    public boolean handles(Object resource) {
        return resource instanceof org.glassfish.connectors.config.ConnectorConnectionPool;
    }

    @Override
    public synchronized void disableResource(org.glassfish.connectors.config.ConnectorConnectionPool resource) throws Exception {
    }

    @Override
    public synchronized void enableResource(org.glassfish.connectors.config.ConnectorConnectionPool resource) throws Exception {
    }

    /*
     * Enabled aggressive block sorting
     */
    private ConnectorConnectionPool getConnectorConnectionPool(org.glassfish.connectors.config.ConnectorConnectionPool domainCcp, PoolInfo poolInfo) throws Exception {
        ConnectorConnectionPool ccp = new ConnectorConnectionPool(poolInfo);
        ccp.setSteadyPoolSize(domainCcp.getSteadyPoolSize());
        ccp.setMaxPoolSize(domainCcp.getMaxPoolSize());
        ccp.setMaxWaitTimeInMillis(domainCcp.getMaxWaitTimeInMillis());
        ccp.setPoolResizeQuantity(domainCcp.getPoolResizeQuantity());
        ccp.setIdleTimeoutInSeconds(domainCcp.getIdleTimeoutInSeconds());
        ccp.setFailAllConnections(Boolean.parseBoolean(domainCcp.getFailAllConnections()));
        ccp.setAuthCredentialsDefinedInPool(this.isAuthCredentialsDefinedInPool(domainCcp));
        ccp.setConnectionValidationRequired(Boolean.parseBoolean(domainCcp.getIsConnectionValidationRequired()));
        String txSupport = domainCcp.getTransactionSupport();
        int txSupportIntVal = this.parseTransactionSupportString(txSupport);
        if (txSupportIntVal == -1) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Got transaction-support attr null from domain.xml");
            }
            txSupportIntVal = ConnectionPoolObjectsUtils.getTransactionSupportFromRaXml(domainCcp.getResourceAdapterName());
        } else if (!ConnectionPoolObjectsUtils.isTxSupportConfigurationSane(txSupportIntVal, domainCcp.getResourceAdapterName())) {
            String i18nMsg = MESSAGES.getString("ccp_deployer.incorrect_tx_support");
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            LOG.log(Level.SEVERE, "rardeployment.incorrect_tx_support", ccp.getName());
            throw cre;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("setting txSupportVal to " + txSupportIntVal + " in pool " + domainCcp.getName());
        }
        ccp.setTransactionSupport(txSupportIntVal);
        ccp.setNonComponent(false);
        ccp.setNonTransactional(false);
        ccp.setConnectionLeakTracingTimeout(domainCcp.getConnectionLeakTimeoutInSeconds());
        ccp.setConnectionReclaim(Boolean.parseBoolean(domainCcp.getConnectionLeakReclaim()));
        ccp.setMatchConnections(Boolean.parseBoolean(domainCcp.getMatchConnections()));
        ccp.setAssociateWithThread(Boolean.parseBoolean(domainCcp.getAssociateWithThread()));
        ccp.setPooling(Boolean.parseBoolean(domainCcp.getPooling()));
        ccp.setPingDuringPoolCreation(Boolean.parseBoolean(domainCcp.getPing()));
        boolean lazyConnectionEnlistment = Boolean.parseBoolean(domainCcp.getLazyConnectionEnlistment());
        boolean lazyConnectionAssociation = Boolean.parseBoolean(domainCcp.getLazyConnectionAssociation());
        if (lazyConnectionAssociation) {
            if (!lazyConnectionEnlistment) {
                LOG.log(Level.SEVERE, "conn_pool_obj_utils.lazy_enlist-lazy_assoc-invalid-combination", domainCcp.getName());
                String i18nMsg = MESSAGES.getString("cpou.lazy_enlist-lazy_assoc-invalid-combination", domainCcp.getName());
                throw new RuntimeException(i18nMsg);
            }
            ccp.setLazyConnectionAssoc(true);
            ccp.setLazyConnectionEnlist(true);
        } else {
            ccp.setLazyConnectionAssoc(lazyConnectionAssociation);
            ccp.setLazyConnectionEnlist(lazyConnectionEnlistment);
        }
        boolean pooling = Boolean.parseBoolean(domainCcp.getPooling());
        if (!pooling) {
            if (Boolean.parseBoolean(domainCcp.getAssociateWithThread())) {
                LOG.log(Level.SEVERE, "conn_pool_obj_utils.pooling_disabled_assocwiththread_invalid_combination", domainCcp.getName());
                String i18nMsg = MESSAGES.getString("cpou.pooling_disabled_assocwiththread_invalid_combination", domainCcp.getName());
                throw new RuntimeException(i18nMsg);
            }
            if (Boolean.parseBoolean(domainCcp.getIsConnectionValidationRequired())) {
                LOG.log(Level.WARNING, "conn_pool_obj_utils.pooling_disabled_conn_validation_invalid_combination", domainCcp.getName());
            }
            if (Integer.parseInt(domainCcp.getValidateAtmostOncePeriodInSeconds()) > 0) {
                LOG.log(Level.WARNING, "conn_pool_obj_utils.pooling_disabled_validate_atmost_once_invalid_combination", domainCcp.getName());
            }
            if (Boolean.parseBoolean(domainCcp.getMatchConnections())) {
                LOG.log(Level.WARNING, "conn_pool_obj_utils.pooling_disabled_match_connections_invalid_combination", domainCcp.getName());
            }
            if (Integer.parseInt(domainCcp.getMaxConnectionUsageCount()) > 0) {
                LOG.log(Level.WARNING, "conn_pool_obj_utils.pooling_disabled_max_conn_usage_invalid_combination", domainCcp.getName());
            }
            if (Integer.parseInt(domainCcp.getIdleTimeoutInSeconds()) > 0) {
                LOG.log(Level.WARNING, "conn_pool_obj_utils.pooling_disabled_idle_timeout_invalid_combination", domainCcp.getName());
            }
        }
        ccp.setPooling(pooling);
        ccp.setMaxConnectionUsage(domainCcp.getMaxConnectionUsageCount());
        ccp.setValidateAtmostOncePeriod(domainCcp.getValidateAtmostOncePeriodInSeconds());
        ccp.setConCreationRetryAttempts(domainCcp.getConnectionCreationRetryAttempts());
        ccp.setConCreationRetryInterval(domainCcp.getConnectionCreationRetryIntervalInSeconds());
        this.convertElementPropertyToPoolProperty(ccp, domainCcp);
        return ccp;
    }

    private void populateConnectorConnectionPool(ConnectorConnectionPool ccp, String connectionDefinitionName, String rarName, List<Property> props, List<SecurityMap> securityMaps) throws ConnectorRuntimeException {
        ConnectorDescriptor connectorDescriptor = this.runtime.getConnectorDescriptor(rarName);
        if (connectorDescriptor == null) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to get connection pool object");
            LOG.log(Level.SEVERE, "rardeployment.connector_descriptor_notfound_registry", rarName);
            LOG.log(Level.SEVERE, "", cre);
            throw cre;
        }
        Set<ConnectionDefDescriptor> connectionDefs = connectorDescriptor.getOutboundResourceAdapter().getConnectionDefs();
        ConnectionDefDescriptor cdd2 = null;
        for (ConnectionDefDescriptor cdd2 : connectionDefs) {
            if (connectionDefinitionName.equals(cdd2.getConnectionFactoryIntf())) break;
        }
        ConnectorDescriptorInfo cdi = new ConnectorDescriptorInfo();
        cdi.setRarName(rarName);
        cdi.setResourceAdapterClassName(connectorDescriptor.getResourceAdapterClass());
        cdi.setConnectionDefinitionName(cdd2.getConnectionFactoryIntf());
        cdi.setManagedConnectionFactoryClass(cdd2.getManagedConnectionFactoryImpl());
        cdi.setConnectionFactoryClass(cdd2.getConnectionFactoryImpl());
        cdi.setConnectionFactoryInterface(cdd2.getConnectionFactoryIntf());
        cdi.setConnectionClass(cdd2.getConnectionImpl());
        cdi.setConnectionInterface(cdd2.getConnectionIntf());
        Properties properties = new Properties();
        if (rarName.trim().equals("jmsra")) {
            properties.put("AddressList", "localhost");
        }
        Set<ConnectorConfigProperty> mergedProps = ConnectorDDTransformUtils.mergeProps(props, cdd2.getConfigProperties(), properties);
        cdi.setMCFConfigProperties(mergedProps);
        cdi.setResourceAdapterConfigProperties(connectorDescriptor.getConfigProperties());
        ccp.setConnectorDescriptorInfo(cdi);
        ccp.setSecurityMaps(SecurityMapUtils.getConnectorSecurityMaps(securityMaps));
    }

    private int parseTransactionSupportString(String txSupport) {
        return ConnectionPoolObjectsUtils.parseTransactionSupportString(txSupport);
    }

    public void convertElementPropertyToPoolProperty(ConnectorConnectionPool ccp, org.glassfish.connectors.config.ConnectorConnectionPool domainCcp) {
        List<Property> elemProps = domainCcp.getProperty();
        if (elemProps == null) {
            return;
        }
        for (Property ep : elemProps) {
            if (ep == null) continue;
            if ("MATCHCONNECTIONS".equals(ep.getName().toUpperCase(locale))) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(" ConnectorConnectionPoolDeployer::  Setting matchConnections");
                }
                ccp.setMatchConnections(this.toBoolean(ep.getValue(), true));
                continue;
            }
            if ("LAZYCONNECTIONASSOCIATION".equals(ep.getName().toUpperCase(locale))) {
                ConnectionPoolObjectsUtils.setLazyEnlistAndLazyAssocProperties(ep.getValue(), domainCcp.getProperty(), ccp);
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("LAZYCONNECTIONASSOCIATION");
                continue;
            }
            if ("LAZYCONNECTIONENLISTMENT".equals(ep.getName().toUpperCase(locale))) {
                ccp.setLazyConnectionEnlist(this.toBoolean(ep.getValue(), false));
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("LAZYCONNECTIONENLISTMENT");
                continue;
            }
            if ("ASSOCIATEWITHTHREAD".equals(ep.getName().toUpperCase(locale))) {
                ccp.setAssociateWithThread(this.toBoolean(ep.getValue(), false));
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("ASSOCIATEWITHTHREAD");
                continue;
            }
            if ("POOLDATASTRUCTURE".equals(ep.getName().toUpperCase(locale))) {
                ccp.setPoolDataStructureType(ep.getValue());
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("POOLDATASTRUCTURE");
                continue;
            }
            if ("POOLWAITQUEUE".equals(ep.getName().toUpperCase(locale))) {
                ccp.setPoolWaitQueue(ep.getValue());
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("POOLWAITQUEUE");
                continue;
            }
            if ("DATASTRUCTUREPARAMETERS".equals(ep.getName().toUpperCase(locale))) {
                ccp.setDataStructureParameters(ep.getValue());
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("DATASTRUCTUREPARAMETERS");
                continue;
            }
            if (!"PREFER-VALIDATE-OVER-RECREATE".equals(ep.getName().toUpperCase(locale))) continue;
            String value = ep.getValue();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(" ConnectorConnectionPoolDeployer::  Setting PREFER-VALIDATE-OVER-RECREATE to " + value);
            }
            ccp.setPreferValidateOverRecreate(this.toBoolean(value, false));
        }
    }

    private boolean toBoolean(Object prop, boolean defaultVal) {
        if (prop == null) {
            return defaultVal;
        }
        return Boolean.parseBoolean((String)prop);
    }

    private boolean isAuthCredentialsDefinedInPool(org.glassfish.connectors.config.ConnectorConnectionPool domainCcp) {
        List<Property> elemProps = domainCcp.getProperty();
        if (elemProps == null) {
            return false;
        }
        for (Property ep : elemProps) {
            if (!ep.getName().equalsIgnoreCase("UserName") && !ep.getName().equalsIgnoreCase("User") && !ep.getName().equalsIgnoreCase("Password")) continue;
            return true;
        }
        return false;
    }
}

