/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.deployer.AbstractConnectorResourceDeployer;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.connectors.config.AdminObjectResource;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service
@Singleton
@ResourceDeployerInfo(value=AdminObjectResource.class)
public class AdminObjectResourceDeployer
extends AbstractConnectorResourceDeployer<AdminObjectResource> {
    private static final Logger LOG = LogDomains.getLogger(AdminObjectResourceDeployer.class, "jakarta.enterprise.resource.resourceadapter");
    @Inject
    private ConnectorRuntime runtime;

    @Override
    public synchronized void deployResource(AdminObjectResource resource, String applicationName, String moduleName) throws Exception {
        SimpleJndiName jndiName = SimpleJndiName.of(resource.getJndiName());
        ResourceInfo resourceInfo = new ResourceInfo(jndiName, applicationName, moduleName);
        this.createAdminObjectResource(resource, resourceInfo);
    }

    @Override
    public synchronized void deployResource(AdminObjectResource resource) throws Exception {
        ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo(resource);
        this.createAdminObjectResource(resource, resourceInfo);
    }

    private void createAdminObjectResource(AdminObjectResource aor, ResourceInfo resourceInfo) throws ConnectorRuntimeException {
        LOG.log(Level.FINE, "Calling backend to add adminObject: {0}", resourceInfo);
        this.runtime.addAdminObject(null, aor.getResAdapter(), resourceInfo, aor.getResType(), aor.getClassName(), this.transformProps(aor.getProperty()));
        LOG.log(Level.FINE, "Added adminObject in backend: {0}", resourceInfo);
    }

    @Override
    public void undeployResource(AdminObjectResource resource, String applicationName, String moduleName) throws Exception {
        SimpleJndiName jndiName = SimpleJndiName.of(resource.getJndiName());
        ResourceInfo resourceInfo = new ResourceInfo(jndiName, applicationName, moduleName);
        this.deleteAdminObjectResource(resource, resourceInfo);
    }

    @Override
    public synchronized void undeployResource(AdminObjectResource resource) throws Exception {
        AdminObjectResource aor = resource;
        ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo(aor);
        this.deleteAdminObjectResource(aor, resourceInfo);
    }

    private void deleteAdminObjectResource(AdminObjectResource adminObject, ResourceInfo resourceInfo) throws ConnectorRuntimeException {
        LOG.log(Level.FINE, "Calling backend to delete adminObject: {0}", resourceInfo);
        this.runtime.deleteAdminObject(resourceInfo);
        LOG.log(Level.FINE, "Deleted adminObject in backend: {0}", resourceInfo);
    }

    @Override
    public boolean handles(Object resource) {
        return resource instanceof AdminObjectResource;
    }

    @Override
    public synchronized void disableResource(AdminObjectResource resource) throws Exception {
        this.undeployResource(resource);
    }

    @Override
    public synchronized void enableResource(AdminObjectResource resource) throws Exception {
        this.deployResource(resource);
    }

    private Properties transformProps(List<Property> domainProps) {
        Properties props = new Properties();
        for (Property domainProp : domainProps) {
            props.setProperty(domainProp.getName(), domainProp.getValue());
        }
        return props;
    }
}

