/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.impl;

import com.sun.enterprise.naming.impl.GlassfishNamingManagerImpl;
import com.sun.enterprise.naming.impl.NamedNamingObjectManager;
import com.sun.enterprise.naming.impl.SerialContext;
import java.lang.annotation.Annotation;
import java.util.Hashtable;
import java.util.Objects;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.naming.ComponentNamingUtil;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;

public final class JavaURLContext
implements Context,
Cloneable {
    private static final System.Logger LOG = System.getLogger(JavaURLContext.class.getName());
    private static GlassfishNamingManagerImpl namingManager;
    private final SimpleJndiName myName;
    private final Hashtable<Object, Object> myEnv;
    private final SerialContext serialContext;

    static void setNamingManager(GlassfishNamingManagerImpl mgr) {
        namingManager = mgr;
    }

    public JavaURLContext(SimpleJndiName name) {
        this.myName = Objects.requireNonNull(name, "name");
        this.myEnv = JavaURLContext.getMyEnv(null);
        this.serialContext = null;
    }

    public JavaURLContext(SimpleJndiName name, Hashtable<Object, Object> environment) {
        this.myName = Objects.requireNonNull(name, "name");
        this.myEnv = JavaURLContext.getMyEnv(environment);
        this.serialContext = null;
    }

    public JavaURLContext(Hashtable<Object, Object> environment, SerialContext serialContext) {
        this.myName = new SimpleJndiName("");
        this.myEnv = JavaURLContext.getMyEnv(environment);
        this.serialContext = serialContext;
    }

    public JavaURLContext(JavaURLContext ctx) {
        this.myName = ctx.myName;
        this.myEnv = ctx.myEnv;
        this.serialContext = null;
    }

    public JavaURLContext(JavaURLContext ctx, SerialContext serialContext) {
        this.myName = ctx.myName;
        this.myEnv = ctx.myEnv;
        this.serialContext = serialContext;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        Object obj;
        LOG.log(System.Logger.Level.TRACE, "lookup(name={0}); this={1}", name, this);
        if (name.isEmpty()) {
            return new JavaURLContext(this.myName, this.myEnv);
        }
        NameNotFoundException e = new NameNotFoundException("No object bound for " + name);
        SimpleJndiName fullName = this.toFullName(name);
        LOG.log(System.Logger.Level.DEBUG, "Computed fullname={0} for name={1}", fullName, name);
        if (fullName == null) {
            throw e;
        }
        if (!JavaURLContext.isAnyJavaEnvJndiName(fullName) && (obj = JavaURLContext.lookupOrCollectException(SimpleJndiName.of(name), e, NamedNamingObjectManager::tryNamedProxies)) != null) {
            return obj;
        }
        obj = JavaURLContext.lookupOrCollectException(fullName, e, n -> namingManager.lookup((SimpleJndiName)n, this.serialContext));
        if (obj != null) {
            return obj;
        }
        ServiceLocator services = Globals.getDefaultHabitat();
        ProcessEnvironment processEnv = services.getService(ProcessEnvironment.class, new Annotation[0]);
        if (fullName.isJavaApp() && processEnv.getProcessType() == ProcessEnvironment.ProcessType.ACC) {
            Context context = namingManager.getInitialContext();
            String appName = (String)context.lookup("java:app/AppName");
            if (!fullName.hasPrefix("java:app/env/") || !"java:app/env".equals(fullName.toString())) {
                String globalName = "java:global/" + appName + "/" + String.valueOf(fullName.removePrefix());
                Object obj2 = JavaURLContext.lookupOrCollectException(globalName, e, context::lookup);
                if (obj2 != null) {
                    return obj2;
                }
            }
            ComponentNamingUtil util = services.getService(ComponentNamingUtil.class, new Annotation[0]);
            SimpleJndiName internalGlobalJavaAppName = util.composeInternalGlobalJavaAppName(appName, fullName);
            Object obj3 = JavaURLContext.lookupOrCollectException(internalGlobalJavaAppName.toString(), e, context::lookup);
            if (obj3 != null) {
                return obj3;
            }
        }
        throw e;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        throw new NamingException("The namespace '" + String.valueOf(this.myName) + "' cannot be modified. Called for " + name);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        throw new NamingException("The namespace '" + String.valueOf(this.myName) + "' cannot be modified. Called for " + String.valueOf(name));
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        throw new NamingException("The namespace '" + String.valueOf(this.myName) + "' cannot be modified. Called for " + name);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        throw new NamingException("The namespace '" + String.valueOf(this.myName) + "' cannot be modified. Called for " + String.valueOf(name));
    }

    @Override
    public void unbind(String name) throws NamingException {
        throw new NamingException("The namespace '" + String.valueOf(this.myName) + "' cannot be modified. Called for " + name);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        throw new NamingException("The namespace '" + String.valueOf(this.myName) + "' cannot be modified. Called for " + String.valueOf(name));
    }

    @Override
    public void rename(String oldname, String newname) throws NamingException {
        throw new NamingException("The namespace '" + String.valueOf(this.myName) + "' cannot be modified. Called for " + oldname + " and " + newname);
    }

    @Override
    public void rename(Name oldname, Name newname) throws NamingException {
        throw new NamingException("The namespace '" + String.valueOf(this.myName) + "' cannot be modified. Called for " + String.valueOf(oldname) + " and " + String.valueOf(newname));
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw new NamingException("The namespace '" + String.valueOf(this.myName) + "' cannot be modified. Called for " + name);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new NamingException("The namespace '" + String.valueOf(this.myName) + "' cannot be modified. Called for " + String.valueOf(name));
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw new NamingException("The namespace '" + String.valueOf(this.myName) + "' cannot be modified. Called for " + name);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new NamingException("The namespace '" + String.valueOf(this.myName) + "' cannot be modified. Called for " + String.valueOf(name));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        if (name.isEmpty()) {
            if (namingManager == null) {
                throw new NamingException();
            }
            return namingManager.list(this.myName);
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).list("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        if (name.isEmpty()) {
            if (namingManager == null) {
                throw new NamingException();
            }
            return namingManager.listBindings(this.myName);
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).listBindings("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        if (namingManager == null) {
            throw new NamingException("Naming manager wasn't set!");
        }
        return namingManager.getNameParser();
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.myEnv.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.myEnv.remove(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.myEnv;
    }

    @Override
    public void close() throws NamingException {
        this.myEnv.clear();
    }

    public SimpleJndiName getName() {
        return this.myName;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.myName.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.myName) + "]";
    }

    private SimpleJndiName toFullName(String name) {
        if (!SimpleJndiName.isValidJndiName(name)) {
            return null;
        }
        if (this.myName.isEmpty()) {
            return new SimpleJndiName(name);
        }
        if (this.myName.toString().equals("java:")) {
            return new SimpleJndiName(String.valueOf(this.myName) + name);
        }
        return new SimpleJndiName(String.valueOf(this.myName) + "/" + name);
    }

    private static boolean isAnyJavaEnvJndiName(SimpleJndiName jndiName) {
        if (jndiName == null || jndiName.isEmpty()) {
            return false;
        }
        if (jndiName.hasPrefix("java:comp/env/") || jndiName.hasPrefix("java:module/env/") || jndiName.hasPrefix("java:app/env/")) {
            return true;
        }
        return jndiName.toString().equals("java:comp/env") || jndiName.toString().equals("java:module/env") || jndiName.toString().equals("java:app/env");
    }

    private static Hashtable<Object, Object> getMyEnv(Hashtable<Object, Object> environment) {
        return environment == null ? new Hashtable() : (Hashtable)environment.clone();
    }

    private static <N> Object lookupOrCollectException(N jndiName, NamingException collector, NamingFunction<N> lookup) {
        try {
            return lookup.applyName(jndiName);
        }
        catch (NamingException e) {
            collector.addSuppressed(e);
            return null;
        }
    }

    @FunctionalInterface
    private static interface NamingFunction<N> {
        public Object applyName(N var1) throws NamingException;
    }
}

