/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.embedded;

import com.sun.enterprise.glassfish.bootstrap.GlassFishImpl;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.glassfish.embeddable.CommandResult;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.hk2.api.ServiceLocator;

class AutoDisposableGlassFish
extends GlassFishImpl {
    private static final System.Logger LOG = System.getLogger(AutoDisposableGlassFish.class.getName());
    private static final String GENERAL_CONFIG_PROP_PREFIX = "embedded-glassfish-config.";
    private final File instanceRoot;
    private final boolean autoDelete;
    private final Consumer<GlassFish> onDisposeAction;

    AutoDisposableGlassFish(ModuleStartup gfKernel, ServiceLocator serviceLocator, GlassFishProperties gfProps, Consumer<GlassFish> onDispose) throws GlassFishException {
        super(gfKernel, serviceLocator);
        this.instanceRoot = new File(gfProps.getInstanceRoot());
        this.autoDelete = Boolean.parseBoolean(gfProps.getProperty("org.glassfish.embeddable.autoDelete"));
        this.onDisposeAction = onDispose;
        CommandRunner commandRunner = null;
        HashSet<String> knownPropertyPrefixes = new HashSet<String>();
        Iterator<String> iterator = gfProps.getPropertyNames().iterator();
        while (iterator.hasNext()) {
            CommandResult result;
            String propertyPrefix;
            String key;
            String propertyName = key = iterator.next();
            if (key.startsWith(GENERAL_CONFIG_PROP_PREFIX)) {
                propertyName = key.substring(GENERAL_CONFIG_PROP_PREFIX.length());
            }
            String propertyValue = gfProps.getProperty(key);
            if (commandRunner == null) {
                commandRunner = serviceLocator.getService(CommandRunner.class, new Annotation[0]);
            }
            if (!knownPropertyPrefixes.contains(propertyPrefix = propertyName.split("\\.")[0])) {
                CommandResult resultList = commandRunner.run("list", propertyPrefix);
                if (resultList.getExitStatus() != CommandResult.ExitStatus.SUCCESS || !resultList.getOutput().contains(propertyPrefix)) continue;
                knownPropertyPrefixes.add(propertyPrefix);
            }
            if ((result = commandRunner.run("set", propertyName + "=" + propertyValue)).getExitStatus() == CommandResult.ExitStatus.SUCCESS) continue;
            throw new GlassFishException(result.getOutput(), result.getFailureCause());
        }
    }

    @Override
    public void dispose() throws GlassFishException {
        try {
            super.dispose();
        }
        finally {
            if (this.autoDelete && this.instanceRoot != null && this.instanceRoot.exists()) {
                AutoDisposableGlassFish.deleteRecursive(this.instanceRoot);
            }
            this.onDisposeAction.accept(this);
        }
    }

    private static boolean deleteRecursive(File dir) {
        try (Stream<Path> paths = Files.walk(dir.toPath(), new FileVisitOption[0]);){
            paths.sorted(Comparator.reverseOrder()).forEach(AutoDisposableGlassFish::delete);
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.ERROR, "Could not delete: " + String.valueOf(dir), (Throwable)e);
        }
        return Files.exists(dir.toPath(), new LinkOption[0]);
    }

    private static void delete(Path path) {
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            LOG.log(System.Logger.Level.ERROR, "Could not delete: " + String.valueOf(path), (Throwable)e);
        }
    }
}

