/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.cp;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.glassfish.common.util.GlassfishUrlClassLoader;

public final class ClassPathBuilder {
    private final List<File> files = new ArrayList<File>();

    public void addJar(File jar) throws IOException {
        if (!jar.exists()) {
            throw new IOException("No such file: " + String.valueOf(jar));
        }
        this.files.add(jar);
    }

    public void addJarFolder(File folder, String ... excludes) throws IOException {
        if (!folder.isDirectory()) {
            throw new IOException("Not a directory " + String.valueOf(folder));
        }
        FileFilter filter = pathname -> {
            for (String name : excludes) {
                if (!pathname.getName().equals(name)) continue;
                return false;
            }
            return pathname.getPath().endsWith(".jar");
        };
        File[] children = folder.listFiles(filter);
        if (children == null) {
            return;
        }
        for (File child : children) {
            this.addJar(child);
        }
    }

    public void addGlob(File folder, String ... masks) throws IOException {
        StringBuilder regexp = new StringBuilder();
        for (String mask : masks) {
            if (regexp.length() > 0) {
                regexp.append('|');
            }
            regexp.append("(\\Q");
            regexp.append(mask.replace("?", "\\E.\\Q").replace("*", "\\E.*\\Q"));
            regexp.append("\\E)");
        }
        Pattern p = Pattern.compile(regexp.toString());
        File[] children = folder.listFiles();
        if (children == null) {
            return;
        }
        for (File child : children) {
            if (!p.matcher(child.getName()).matches()) continue;
            this.addJar(child);
        }
    }

    public ClassLoader build(ClassLoader parent) {
        PrivilegedAction<GlassfishUrlClassLoader> action = () -> {
            URL[] urls = (URL[])this.files.stream().map(ClassPathBuilder::toURL).toArray(URL[]::new);
            return new GlassfishUrlClassLoader(urls, parent);
        };
        return AccessController.doPrivileged(action);
    }

    private static URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("File cannot be converted to URL: " + file.getAbsolutePath(), e);
        }
    }
}

