/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.module.bootstrap.ModuleStartup;
import java.lang.annotation.Annotation;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.embeddable.Deployer;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.extras.ExtrasUtilities;

public class GlassFishImpl
implements GlassFish {
    private ModuleStartup gfKernel;
    private ServiceLocator serviceLocator;
    private volatile GlassFish.Status status;

    public GlassFishImpl(ModuleStartup gfKernel, ServiceLocator serviceLocator) throws GlassFishException {
        this.gfKernel = gfKernel;
        this.serviceLocator = serviceLocator;
        this.status = GlassFish.Status.INIT;
        ExtrasUtilities.enableTopicDistribution(serviceLocator);
    }

    @Override
    public synchronized void start() throws GlassFishException {
        if (this.status == GlassFish.Status.STARTED || this.status == GlassFish.Status.STARTING || this.status == GlassFish.Status.DISPOSED) {
            throw new IllegalStateException("Already in " + String.valueOf((Object)this.status) + " state.");
        }
        this.status = GlassFish.Status.STARTING;
        this.gfKernel.start();
        this.status = GlassFish.Status.STARTED;
    }

    @Override
    public synchronized void stop() throws GlassFishException {
        if (this.status == GlassFish.Status.STOPPED || this.status == GlassFish.Status.STOPPING || this.status == GlassFish.Status.DISPOSED) {
            throw new IllegalStateException("Already in " + String.valueOf((Object)this.status) + " state.");
        }
        this.status = GlassFish.Status.STOPPING;
        this.gfKernel.stop();
        this.status = GlassFish.Status.STOPPED;
    }

    @Override
    public synchronized void dispose() throws GlassFishException {
        if (this.status == GlassFish.Status.DISPOSED) {
            throw new IllegalStateException("Already disposed.");
        }
        if (this.status != GlassFish.Status.STOPPED) {
            try {
                this.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.gfKernel = null;
        this.serviceLocator = null;
        this.status = GlassFish.Status.DISPOSED;
    }

    @Override
    public GlassFish.Status getStatus() {
        return this.status;
    }

    @Override
    public <T> T getService(Class<T> serviceType) throws GlassFishException {
        return this.getService(serviceType, null);
    }

    @Override
    public synchronized <T> T getService(Class<T> serviceType, String serviceName) throws GlassFishException {
        if (this.status != GlassFish.Status.STARTED) {
            throw new IllegalArgumentException("Server is not started yet. It is in " + String.valueOf((Object)this.status) + "state");
        }
        return serviceName == null ? this.serviceLocator.getService(serviceType, new Annotation[0]) : this.serviceLocator.getService(serviceType, serviceName, new Annotation[0]);
    }

    @Override
    public Deployer getDeployer() throws GlassFishException {
        return this.getService(Deployer.class);
    }

    @Override
    public CommandRunner getCommandRunner() throws GlassFishException {
        return this.getService(CommandRunner.class);
    }
}

