/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;

public class WebServiceRuntimeNode
extends DeploymentDescriptorNode<WebService> {
    private static final Logger LOG = DOLUtils.getDefaultLogger();
    private WebService descriptor;

    @Override
    public WebService getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if ("webservice-description-name".equals(element.getQName())) {
            BundleDescriptor parent = (BundleDescriptor)this.getParentNode().getDescriptor();
            WebServicesDescriptor webServices = parent.getWebServices();
            this.descriptor = webServices.getWebServiceByName(value);
        } else if ("wsdl-publish-location".equals(element.getQName())) {
            if (this.descriptor == null) {
                LOG.warning("Warning : WebService descriptor is null for final wsdl url=" + value);
                return;
            }
            try {
                URL url = new URL(value);
                this.descriptor.setClientPublishUrl(url);
            }
            catch (MalformedURLException mue) {
                LOG.log(Level.WARNING, "Warning : Invalid final wsdl url=" + value, mue);
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, WebService webService) {
        Node webServiceNode = super.writeDescriptor(parent, nodeName, webService);
        WebServiceRuntimeNode.appendTextChild(webServiceNode, "webservice-description-name", webService.getName());
        if (webService.hasClientPublishUrl()) {
            URL url = webService.getClientPublishUrl();
            WebServiceRuntimeNode.appendTextChild(webServiceNode, "wsdl-publish-location", url.toExternalForm());
        }
        return webServiceNode;
    }

    public void writeWebServiceRuntimeInfo(Node parent, BundleDescriptor bundle2) {
        WebServicesDescriptor webServices = bundle2.getWebServices();
        if (webServices != null) {
            for (WebService element : webServices.getWebServices()) {
                if (!element.hasClientPublishUrl()) continue;
                this.writeDescriptor(parent, "webservice-description", element);
            }
        }
    }
}

