/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.connector;

import com.sun.enterprise.deployment.MessageListener;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.connector.ActivationSpecNode;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MessageListenerNode
extends DeploymentDescriptorNode<MessageListener> {
    private MessageListener msgListener;

    public static Node writeMessageListeners(Node parent, Set<MessageListener> msgListeners) {
        if (msgListeners.isEmpty()) {
            throw new RuntimeException("There must be at least one messagelistener for this inbound resource adapter");
        }
        for (MessageListener listener : msgListeners) {
            Element msgListenerNode = MessageListenerNode.appendChild(parent, "messagelistener");
            MessageListenerNode.appendTextChild((Node)msgListenerNode, "messagelistener-type", listener.getMessageListenerType());
            ActivationSpecNode.writeMessageListener(msgListenerNode, listener);
        }
        return parent;
    }

    public MessageListenerNode() {
        this.registerElementHandler(new XMLElement("activationspec"), ActivationSpecNode.class);
    }

    @Override
    public MessageListener getDescriptor() {
        if (this.msgListener == null) {
            this.msgListener = (MessageListener)DescriptorFactory.getDescriptor(this.getXMLPath());
        }
        return this.msgListener;
    }

    @Override
    protected Map<String, String> getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("messagelistener-type", "setMessageListenerType");
        return table;
    }
}

