/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.ContextualResourceDefinition;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.glassfish.deployment.common.JavaEEResourceType;

abstract class ConcurrencyDefinitionConvertor<D extends ContextualResourceDefinition, T extends ResourceDescriptor> {
    private final Class<T> descriptorClass;
    private final JavaEEResourceType descriptorType;

    ConcurrencyDefinitionConvertor(Class<T> descriptorClass, JavaEEResourceType descriptorType) {
        this.descriptorClass = descriptorClass;
        this.descriptorType = descriptorType;
    }

    abstract T createDescriptor(D var1);

    abstract D getData(T var1);

    abstract void merge(D var1, D var2);

    final void updateDescriptors(D data, ResourceContainerContext[] contexts) {
        for (ResourceContainerContext context : contexts) {
            Set<ResourceDescriptor> descriptors = context.getResourceDescriptors(this.descriptorType);
            List<D> existing = this.getExisting(data, descriptors);
            if (existing.isEmpty()) {
                descriptors.add((ResourceDescriptor)this.createDescriptor(data));
                continue;
            }
            for (ContextualResourceDefinition existingData : existing) {
                this.merge(data, existingData);
            }
        }
    }

    private List<D> getExisting(D data, Set<ResourceDescriptor> descriptors) {
        return descriptors.stream().filter(d -> this.isSameDefinition(data, (ResourceDescriptor)d)).map(d -> this.getData(d)).collect(Collectors.toList());
    }

    private boolean isSameDefinition(D data, ResourceDescriptor descriptor) {
        return this.descriptorClass.isInstance(descriptor) && Objects.equals(ResourceDescriptor.getJavaComponentJndiName(descriptor.getJndiName().toString()), ResourceDescriptor.getJavaComponentJndiName(data.getName()));
    }
}

