/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.context;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.EjbInterceptorContext;
import com.sun.enterprise.deployment.annotation.context.EjbsContext;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContextImpl;
import com.sun.enterprise.deployment.types.HandlerChainContainer;
import com.sun.enterprise.deployment.types.ServiceReferenceContainer;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.context.AnnotationContext;

public class EjbBundleContext
extends ResourceContainerContextImpl {
    public EjbBundleContext(EjbBundleDescriptor descriptor) {
        super(descriptor);
    }

    public <T extends EjbBundleDescriptor> T getDescriptor() {
        return (T)((EjbBundleDescriptor)this.descriptor);
    }

    public AnnotatedElementHandler createContextForEjb() {
        Class ejbClass = (Class)this.getProcessingContext().getProcessor().getLastAnnotatedElement(ElementType.TYPE);
        EjbDescriptor[] ejbDescs = null;
        String ejbClassName = null;
        if (ejbClass != null) {
            ejbClassName = ejbClass.getName();
            ejbDescs = ((EjbBundleDescriptor)this.getDescriptor()).getEjbByClassName(ejbClassName);
        }
        AnnotationContext aeHandler = null;
        if (ejbDescs != null && ejbDescs.length > 1) {
            aeHandler = new EjbsContext(ejbDescs, ejbClass);
        } else if (ejbDescs != null && ejbDescs.length == 1) {
            aeHandler = new EjbContext(ejbDescs[0], ejbClass);
        }
        if (aeHandler != null) {
            this.getProcessingContext().pushHandler(aeHandler);
        }
        return aeHandler;
    }

    @Override
    public HandlerChainContainer[] getHandlerChainContainers(boolean serviceSideHandlerChain, Class<?> declaringClass) {
        if (serviceSideHandlerChain) {
            EjbDescriptor[] ejbs = declaringClass.isInterface() ? ((EjbBundleDescriptor)this.getDescriptor()).getEjbBySEIName(declaringClass.getName()) : ((EjbBundleDescriptor)this.getDescriptor()).getEjbByClassName(declaringClass.getName());
            ArrayList<WebServiceEndpoint> result = new ArrayList<WebServiceEndpoint>();
            for (EjbDescriptor ejb : ejbs) {
                result.addAll(((BundleDescriptor)this.getDescriptor()).getWebServices().getEndpointsImplementedBy(ejb));
            }
            return result.toArray(new HandlerChainContainer[result.size()]);
        }
        ArrayList<ServiceReferenceDescriptor> result = new ArrayList<ServiceReferenceDescriptor>();
        result.addAll(((EjbBundleDescriptor)this.getDescriptor()).getEjbServiceReferenceDescriptors());
        return result.toArray(new HandlerChainContainer[result.size()]);
    }

    @Override
    public ServiceReferenceContainer[] getServiceRefContainers() {
        return (ServiceReferenceContainer[])((EjbBundleDescriptor)this.getDescriptor()).getEjbs().toArray(ServiceReferenceContainer[]::new);
    }

    public AnnotatedElementHandler createContextForEjbInterceptor() {
        Class interceptorClass = (Class)this.getProcessingContext().getProcessor().getLastAnnotatedElement(ElementType.TYPE);
        EjbInterceptor ejbInterceptor = ((EjbBundleDescriptor)this.getDescriptor()).getInterceptorByClassName(interceptorClass.getName());
        if (ejbInterceptor == null) {
            return null;
        }
        EjbInterceptorContext aeHandler = new EjbInterceptorContext(ejbInterceptor);
        this.getProcessingContext().pushHandler(aeHandler);
        return aeHandler;
    }
}

