/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.CommonResourceBundleDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.ErrorPageDescriptor;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.InjectionInfo;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.JspConfigDefinitionDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.LocaleEncodingMappingDescriptor;
import com.sun.enterprise.deployment.LocaleEncodingMappingListDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.types.EjbReferenceContainer;
import com.sun.enterprise.deployment.types.MessageDestinationReferenceContainer;
import com.sun.enterprise.deployment.types.ResourceEnvReferenceContainer;
import com.sun.enterprise.deployment.types.ResourceReferenceContainer;
import com.sun.enterprise.deployment.types.ServiceReferenceContainer;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.web.AppListenerDescriptor;
import com.sun.enterprise.deployment.web.ContextParameter;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.deployment.web.MimeMapping;
import com.sun.enterprise.deployment.web.ResourceReference;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.ServletFilter;
import com.sun.enterprise.deployment.web.ServletFilterMapping;
import com.sun.enterprise.deployment.web.SessionConfig;
import com.sun.enterprise.deployment.web.WebResourceCollection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.event.EventTypes;
import org.glassfish.deployment.common.Descriptor;

public abstract class WebBundleDescriptor
extends CommonResourceBundleDescriptor
implements WritableJndiNameEnvironment,
ResourceReferenceContainer,
ResourceEnvReferenceContainer,
EjbReferenceContainer,
MessageDestinationReferenceContainer,
ServiceReferenceContainer {
    private static final long serialVersionUID = 5599255661969873669L;
    private static final String DEPLOYMENT_DESCRIPTOR_DIR = "WEB-INF";
    public static final EventTypes<WebBundleDescriptor> AFTER_SERVLET_CONTEXT_INITIALIZED_EVENT = EventTypes.create("After_Servlet_Context_Initialized", WebBundleDescriptor.class);
    private String contextRoot;
    private boolean denyUncoveredHttpMethods;
    private boolean distributable;
    private LocaleEncodingMappingListDescriptor localeEncodingMappingListDesc;
    private LoginConfiguration loginConfiguration;
    private String requestCharacterEncoding;
    private String responseCharacterEncoding;
    private SessionConfig sessionConfig;
    private boolean showArchivedRealPathEnabled = true;
    private JspConfigDefinitionDescriptor jspConfigDescriptor;
    private final Map<String, String> extensionProperty = new HashMap<String, String>(4);
    private final List<AppListenerDescriptor> appListenerDescriptors = new ArrayList<AppListenerDescriptor>();
    private final Set<ContextParameter> contextParameters = new OrderedSet<ContextParameter>();
    private final Set<EjbReferenceDescriptor> ejbReferences = new OrderedSet<EjbReferenceDescriptor>();
    private final Set<EntityManagerFactoryReferenceDescriptor> entityManagerFactoryReferences = new HashSet<EntityManagerFactoryReferenceDescriptor>();
    private final Set<EntityManagerReferenceDescriptor> entityManagerReferences = new HashSet<EntityManagerReferenceDescriptor>();
    private final Set<EnvironmentProperty> environmentEntries = new OrderedSet<EnvironmentProperty>();
    private final Set<ErrorPageDescriptor> errorPageDescriptors = new HashSet<ErrorPageDescriptor>();
    private final Map<String, String> jarName2WebFragNameMap = new HashMap<String, String>();
    private final Set<MessageDestinationReferenceDescriptor> messageDestReferences = new OrderedSet<MessageDestinationReferenceDescriptor>();
    private final Set<MimeMapping> mimeMappings = new OrderedSet<MimeMapping>();
    private final List<String> orderedLibs = new ArrayList<String>();
    private final Set<LifecycleCallbackDescriptor> postConstructDescs = new HashSet<LifecycleCallbackDescriptor>();
    private final Set<LifecycleCallbackDescriptor> preDestroyDescs = new HashSet<LifecycleCallbackDescriptor>();
    private final Set<ResourceEnvReferenceDescriptor> resourceEnvRefReferences = new OrderedSet<ResourceEnvReferenceDescriptor>();
    private final Set<ResourceReferenceDescriptor> resourceReferences = new OrderedSet<ResourceReferenceDescriptor>();
    private final Set<SecurityConstraint> securityConstraints = new HashSet<SecurityConstraint>();
    private final Set<ServiceReferenceDescriptor> serviceReferences = new OrderedSet<ServiceReferenceDescriptor>();
    private final List<ServletFilter> servletFilters = new ArrayList<ServletFilter>();
    private final List<ServletFilterMapping> servletFilterMappings = new ArrayList<ServletFilterMapping>();
    private final Set<WebComponentDescriptor> webComponentDescriptors = new OrderedSet<WebComponentDescriptor>();
    private final Set<String> welcomeFiles = new OrderedSet<String>();
    private Map<String, String> urlPattern2ServletName;

    public abstract void addJndiNameEnvironment(JndiNameEnvironment var1);

    protected abstract void addCommonWebBundleDescriptor(WebBundleDescriptor var1, boolean var2);

    public void addWebBundleDescriptor(WebBundleDescriptor webBundleDescriptor) {
        this.welcomeFiles.addAll(webBundleDescriptor.getWelcomeFiles());
        this.addCommonWebBundleDescriptor(webBundleDescriptor, true);
    }

    public void addDefaultWebBundleDescriptor(WebBundleDescriptor descriptor) {
        if (this.getWelcomeFiles().isEmpty()) {
            this.welcomeFiles.addAll(descriptor.getWelcomeFiles());
        }
        if (this.requestCharacterEncoding == null) {
            this.requestCharacterEncoding = descriptor.getRequestCharacterEncoding();
        }
        if (this.responseCharacterEncoding == null) {
            this.responseCharacterEncoding = descriptor.getResponseCharacterEncoding();
        }
        this.addCommonWebBundleDescriptor(descriptor, false);
    }

    @Override
    public String getDeploymentDescriptorDir() {
        return DEPLOYMENT_DESCRIPTOR_DIR;
    }

    @Override
    public final ArchiveType getModuleType() {
        return DOLUtils.warType();
    }

    @Override
    public boolean isEmpty() {
        return this.webComponentDescriptors == null || this.webComponentDescriptors.isEmpty();
    }

    public String getContextRoot() {
        if (this.getModuleDescriptor() != null && this.getModuleDescriptor().getContextRoot() != null) {
            return this.getModuleDescriptor().getContextRoot();
        }
        if (this.contextRoot == null) {
            this.contextRoot = "";
        }
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        if (this.getModuleDescriptor() != null) {
            this.getModuleDescriptor().setContextRoot(contextRoot);
        }
        this.contextRoot = contextRoot;
    }

    public boolean isDenyUncoveredHttpMethods() {
        return this.denyUncoveredHttpMethods;
    }

    public void setDenyUncoveredHttpMethods(boolean denyUncoveredHttpMethods) {
        this.denyUncoveredHttpMethods = denyUncoveredHttpMethods;
    }

    public boolean isDistributable() {
        return this.distributable;
    }

    public void setDistributable(boolean distributable) {
        this.distributable = distributable;
    }

    public LocaleEncodingMappingListDescriptor getLocaleEncodingMappingListDescriptor() {
        return this.localeEncodingMappingListDesc;
    }

    public void setLocaleEncodingMappingListDescriptor(LocaleEncodingMappingListDescriptor lemListDesc) {
        this.localeEncodingMappingListDesc = lemListDesc;
    }

    public void addLocaleEncodingMappingDescriptor(LocaleEncodingMappingDescriptor lemDesc) {
        if (this.localeEncodingMappingListDesc == null) {
            this.localeEncodingMappingListDesc = new LocaleEncodingMappingListDescriptor();
        }
        this.localeEncodingMappingListDesc.addLocaleEncodingMapping(lemDesc);
    }

    public LoginConfiguration getLoginConfiguration() {
        return this.loginConfiguration;
    }

    public void setLoginConfiguration(LoginConfiguration loginConfiguration) {
        this.loginConfiguration = loginConfiguration;
    }

    public String getRequestCharacterEncoding() {
        return this.requestCharacterEncoding;
    }

    public void setRequestCharacterEncoding(String requestCharacterEncoding) {
        this.requestCharacterEncoding = requestCharacterEncoding;
    }

    public String getResponseCharacterEncoding() {
        return this.responseCharacterEncoding;
    }

    public void setResponseCharacterEncoding(String responseCharacterEncoding) {
        this.responseCharacterEncoding = responseCharacterEncoding;
    }

    public SessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public void setSessionConfig(SessionConfig sessionConfig) {
        this.sessionConfig = sessionConfig;
    }

    public boolean isShowArchivedRealPathEnabled() {
        return this.showArchivedRealPathEnabled;
    }

    public void setShowArchivedRealPathEnabled(boolean enabled) {
        this.showArchivedRealPathEnabled = enabled;
    }

    public void addJspDescriptor(JspConfigDefinitionDescriptor descriptor) {
        this.jspConfigDescriptor.add(descriptor);
    }

    public Set<WebComponentDescriptor> getJspDescriptors() {
        HashSet<WebComponentDescriptor> jspDescriptors = new HashSet<WebComponentDescriptor>();
        for (WebComponentDescriptor webComponent : this.getWebComponentDescriptors()) {
            if (webComponent.isServlet()) continue;
            jspDescriptors.add(webComponent);
        }
        return jspDescriptors;
    }

    public JspConfigDefinitionDescriptor getJspConfigDescriptor() {
        return this.jspConfigDescriptor;
    }

    public void setJspConfigDescriptor(JspConfigDefinitionDescriptor descriptor) {
        this.jspConfigDescriptor = descriptor;
    }

    public void setExtensionProperty(String key, String value) {
        this.extensionProperty.put(key, value);
    }

    public boolean hasExtensionProperty(String key) {
        return this.extensionProperty != null && this.extensionProperty.containsKey(key);
    }

    public List<AppListenerDescriptor> getAppListenersCopy() {
        return List.copyOf(this.getAppListeners());
    }

    public List<AppListenerDescriptor> getAppListeners() {
        return this.appListenerDescriptors;
    }

    public void setAppListeners(Collection<? extends AppListenerDescriptor> listeners) {
        this.appListenerDescriptors.clear();
        this.addAppListeners(listeners);
    }

    protected void addAppListeners(Collection<? extends AppListenerDescriptor> listeners) {
        this.appListenerDescriptors.addAll(listeners);
    }

    public void addAppListenerDescriptor(AppListenerDescriptor descriptor) {
        if (!this.appListenerDescriptors.contains(descriptor)) {
            this.appListenerDescriptors.add(descriptor);
        }
    }

    public void addAppListenerDescriptorToFirst(AppListenerDescriptor descriptor) {
        if (!this.appListenerDescriptors.contains(descriptor)) {
            this.appListenerDescriptors.add(0, descriptor);
        }
    }

    public Set<ContextParameter> getContextParameters() {
        return this.contextParameters;
    }

    protected void addContextParameters(Collection<ContextParameter> parameters) {
        this.contextParameters.addAll(parameters);
    }

    public void addContextParameter(ContextParameter contextParameter) {
        this.contextParameters.add(contextParameter);
    }

    public void removeContextParameter(ContextParameter contextParameter) {
        this.contextParameters.remove(contextParameter);
    }

    @Override
    public Set<EjbReferenceDescriptor> getEjbReferenceDescriptors() {
        return this.ejbReferences;
    }

    @Override
    public EjbReferenceDescriptor getEjbReference(String name) {
        EjbReferenceDescriptor er = this.findEjbReference(name);
        if (er != null) {
            return er;
        }
        throw new IllegalArgumentException(MessageFormat.format("This web app [{0}] has no ejb reference by the name of [{1}] ", this.getName(), name));
    }

    protected EjbReferenceDescriptor findEjbReference(String name) {
        for (EjbReferenceDescriptor er : this.ejbReferences) {
            if (!er.getName().equals(name)) continue;
            return er;
        }
        return null;
    }

    @Override
    public void addEjbReferenceDescriptor(EjbReferenceDescriptor ejbReference) {
        if (this.ejbReferences.add(ejbReference)) {
            ejbReference.setReferringBundleDescriptor(this);
        }
    }

    @Override
    public void removeEjbReferenceDescriptor(EjbReferenceDescriptor ejbReferenceDescriptor) {
        if (this.ejbReferences.remove(ejbReferenceDescriptor)) {
            ejbReferenceDescriptor.setReferringBundleDescriptor(null);
        }
    }

    @Override
    public Set<EntityManagerFactoryReferenceDescriptor> getEntityManagerFactoryReferenceDescriptors() {
        return this.entityManagerFactoryReferences;
    }

    @Override
    public EntityManagerFactoryReferenceDescriptor getEntityManagerFactoryReferenceByName(String name) {
        EntityManagerFactoryReferenceDescriptor emfr = this.findEntityManagerFactoryReferenceByName(name);
        if (emfr != null) {
            return emfr;
        }
        throw new IllegalArgumentException(MessageFormat.format("This web app [{0}] has no entity manager factory reference by the name of [{1}]", this.getName(), name));
    }

    protected EntityManagerFactoryReferenceDescriptor findEntityManagerFactoryReferenceByName(String name) {
        for (EntityManagerFactoryReferenceDescriptor next : this.entityManagerFactoryReferences) {
            if (!next.getName().equals(name)) continue;
            return next;
        }
        return null;
    }

    @Override
    public void addEntityManagerFactoryReferenceDescriptor(EntityManagerFactoryReferenceDescriptor reference) {
        reference.setReferringBundleDescriptor(this);
        this.entityManagerFactoryReferences.add(reference);
    }

    @Override
    public Set<EntityManagerReferenceDescriptor> getEntityManagerReferenceDescriptors() {
        return this.entityManagerReferences;
    }

    @Override
    public EntityManagerReferenceDescriptor getEntityManagerReferenceByName(String name) {
        EntityManagerReferenceDescriptor emr = this.findEntityManagerReferenceByName(name);
        if (emr != null) {
            return emr;
        }
        throw new IllegalArgumentException(MessageFormat.format("This web app [{0}] has no entity manager reference by the name of [{1}]", this.getName(), name));
    }

    protected EntityManagerReferenceDescriptor findEntityManagerReferenceByName(String name) {
        for (EntityManagerReferenceDescriptor next : this.entityManagerReferences) {
            if (!next.getName().equals(name)) continue;
            return next;
        }
        return null;
    }

    @Override
    public void addEntityManagerReferenceDescriptor(EntityManagerReferenceDescriptor reference) {
        reference.setReferringBundleDescriptor(this);
        this.entityManagerReferences.add(reference);
    }

    @Override
    public Set<EnvironmentProperty> getEnvironmentProperties() {
        return this.getEnvironmentEntries();
    }

    public Set<EnvironmentProperty> getEnvironmentEntries() {
        return this.environmentEntries;
    }

    @Override
    public EnvironmentProperty getEnvironmentPropertyByName(String name) {
        EnvironmentProperty entry = this.findEnvironmentEntryByName(name);
        if (entry != null) {
            return entry;
        }
        throw new IllegalArgumentException(MessageFormat.format("This web app [{0}] has no environment property by the name of [{1}]", this.getName(), name));
    }

    protected EnvironmentProperty findEnvironmentEntryByName(String name) {
        for (EnvironmentProperty ev : this.environmentEntries) {
            if (!ev.getName().equals(name)) continue;
            return ev;
        }
        return null;
    }

    @Override
    public void addEnvironmentProperty(EnvironmentProperty environmentProperty) {
        this.addEnvironmentEntry(environmentProperty);
    }

    public void addEnvironmentEntry(EnvironmentProperty environmentEntry) {
        this.environmentEntries.add(environmentEntry);
    }

    @Override
    public void removeEnvironmentProperty(EnvironmentProperty environmentProperty) {
        this.removeEnvironmentEntry(environmentProperty);
    }

    public void removeEnvironmentEntry(EnvironmentProperty environmentEntry) {
        this.environmentEntries.remove(environmentEntry);
    }

    public Set<ErrorPageDescriptor> getErrorPageDescriptors() {
        return this.errorPageDescriptors;
    }

    public void addErrorPageDescriptor(ErrorPageDescriptor errorPageDescriptor) {
        String errorSignifier = errorPageDescriptor.getErrorSignifierAsString();
        ErrorPageDescriptor errPageDesc = this.getErrorPageDescriptorBySignifier(errorSignifier);
        if (errPageDesc == null) {
            this.errorPageDescriptors.add(errorPageDescriptor);
        }
    }

    private ErrorPageDescriptor getErrorPageDescriptorBySignifier(String signifier) {
        for (ErrorPageDescriptor errorPage : this.errorPageDescriptors) {
            if (!errorPage.getErrorSignifierAsString().equals(signifier)) continue;
            return errorPage;
        }
        return null;
    }

    public void removeErrorPageDescriptor(ErrorPageDescriptor errorPageDescriptor) {
        this.errorPageDescriptors.remove(errorPageDescriptor);
    }

    public Map<String, String> getJarNameToWebFragmentNameMap() {
        return Collections.unmodifiableMap(this.jarName2WebFragNameMap);
    }

    public void putJarNameWebFragmentNamePair(String jarName, String webFragmentName) {
        this.jarName2WebFragNameMap.put(jarName, webFragmentName);
    }

    @Override
    public Set<MessageDestinationReferenceDescriptor> getMessageDestinationReferenceDescriptors() {
        return this.messageDestReferences;
    }

    @Override
    public MessageDestinationReferenceDescriptor getMessageDestinationReferenceByName(String name) {
        MessageDestinationReferenceDescriptor mdr = this.findMessageDestinationReferenceByName(name);
        if (mdr != null) {
            return mdr;
        }
        throw new IllegalArgumentException(MessageFormat.format("This web app [{0}] has no message destination reference by the name of [{1}]", this.getName(), name));
    }

    protected MessageDestinationReferenceDescriptor findMessageDestinationReferenceByName(String name) {
        for (MessageDestinationReferenceDescriptor mdr : this.messageDestReferences) {
            if (!mdr.getName().equals(name)) continue;
            return mdr;
        }
        return null;
    }

    @Override
    public void addMessageDestinationReferenceDescriptor(MessageDestinationReferenceDescriptor messageDestRef) {
        messageDestRef.setReferringBundleDescriptor(this);
        this.messageDestReferences.add(messageDestRef);
    }

    @Override
    public void removeMessageDestinationReferenceDescriptor(MessageDestinationReferenceDescriptor msgDestRef) {
        this.messageDestReferences.remove(msgDestRef);
    }

    public Set<MimeMapping> getMimeMappings() {
        return this.mimeMappings;
    }

    public String addMimeMapping(MimeMapping mimeMapping) {
        MimeMapping resultMimeMapping = null;
        for (MimeMapping mm : this.mimeMappings) {
            if (!mm.getExtension().equals(mimeMapping.getExtension())) continue;
            resultMimeMapping = mm;
            break;
        }
        if (resultMimeMapping == null) {
            resultMimeMapping = mimeMapping;
            this.mimeMappings.add(mimeMapping);
        }
        return resultMimeMapping.getMimeType();
    }

    public void removeMimeMapping(MimeMapping mimeMapping) {
        this.mimeMappings.remove(mimeMapping);
    }

    public List<String> getOrderedLibs() {
        return this.orderedLibs;
    }

    public void addOrderedLib(String libName) {
        this.orderedLibs.add(libName);
    }

    @Override
    public Set<LifecycleCallbackDescriptor> getPostConstructDescriptors() {
        return this.postConstructDescs;
    }

    @Override
    public LifecycleCallbackDescriptor getPostConstructDescriptorByClass(String className) {
        return this.getPostConstructDescriptorByClass(className, this);
    }

    @Override
    public void addPostConstructDescriptor(LifecycleCallbackDescriptor postConstructDesc) {
        String className = postConstructDesc.getLifecycleCallbackClass();
        boolean found = false;
        for (LifecycleCallbackDescriptor next : this.postConstructDescs) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.postConstructDescs.add(postConstructDesc);
        }
    }

    @Override
    public Set<LifecycleCallbackDescriptor> getPreDestroyDescriptors() {
        return this.preDestroyDescs;
    }

    @Override
    public LifecycleCallbackDescriptor getPreDestroyDescriptorByClass(String className) {
        return this.getPreDestroyDescriptorByClass(className, this);
    }

    @Override
    public void addPreDestroyDescriptor(LifecycleCallbackDescriptor preDestroyDesc) {
        String className = preDestroyDesc.getLifecycleCallbackClass();
        boolean found = false;
        for (LifecycleCallbackDescriptor next : this.preDestroyDescs) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.preDestroyDescs.add(preDestroyDesc);
        }
    }

    @Override
    public Set<ResourceEnvReferenceDescriptor> getResourceEnvReferenceDescriptors() {
        return this.resourceEnvRefReferences;
    }

    @Override
    public ResourceEnvReferenceDescriptor getResourceEnvReferenceByName(String name) {
        ResourceEnvReferenceDescriptor jrd = this.findResourceEnvReferenceByName(name);
        if (jrd != null) {
            return jrd;
        }
        throw new IllegalArgumentException(MessageFormat.format("This web app [{0}] has no resource environment reference by the name of [{1}]", this.getName(), name));
    }

    protected ResourceEnvReferenceDescriptor findResourceEnvReferenceByName(String name) {
        for (ResourceEnvReferenceDescriptor jdr : this.resourceEnvRefReferences) {
            if (!jdr.getName().equals(name)) continue;
            return jdr;
        }
        return null;
    }

    @Override
    public void addResourceEnvReferenceDescriptor(ResourceEnvReferenceDescriptor resourceEnvRefReference) {
        this.resourceEnvRefReferences.add(resourceEnvRefReference);
    }

    @Override
    public void removeResourceEnvReferenceDescriptor(ResourceEnvReferenceDescriptor resourceEnvRefReference) {
        this.resourceEnvRefReferences.remove(resourceEnvRefReference);
    }

    @Override
    public Set<ResourceReferenceDescriptor> getResourceReferenceDescriptors() {
        return this.resourceReferences;
    }

    @Override
    public ResourceReferenceDescriptor getResourceReferenceByName(String name) {
        ResourceReferenceDescriptor rrd = this.findResourceReferenceByName(name);
        if (rrd != null) {
            return rrd;
        }
        throw new IllegalArgumentException(MessageFormat.format("This web app [{0}] has no resource reference by the name of [{1}]", this.getName(), name));
    }

    protected ResourceReferenceDescriptor findResourceReferenceByName(String name) {
        for (ResourceReference resourceReference : this.resourceReferences) {
            if (!resourceReference.getName().equals(name)) continue;
            return (ResourceReferenceDescriptor)resourceReference;
        }
        return null;
    }

    @Override
    public void addResourceReferenceDescriptor(ResourceReferenceDescriptor resourceReference) {
        this.resourceReferences.add(resourceReference);
    }

    @Override
    public void removeResourceReferenceDescriptor(ResourceReferenceDescriptor resourceReference) {
        this.resourceReferences.remove(resourceReference);
    }

    public Set<SecurityConstraint> getSecurityConstraints() {
        return this.securityConstraints;
    }

    public Collection<SecurityConstraint> getSecurityConstraintsForUrlPattern(String urlPattern) {
        if (urlPattern == null) {
            return Collections.emptySet();
        }
        HashSet<SecurityConstraint> constraints = new HashSet<SecurityConstraint>();
        for (SecurityConstraint constraint : this.securityConstraints) {
            boolean include = false;
            for (WebResourceCollection wsCollection : constraint.getWebResourceCollections()) {
                for (String wsCollectionUrlPattern : wsCollection.getUrlPatterns()) {
                    if (!urlPattern.equals(wsCollectionUrlPattern)) continue;
                    include = true;
                    break;
                }
                if (!include) continue;
                break;
            }
            if (!include) continue;
            constraints.add(constraint);
        }
        return constraints;
    }

    public void addSecurityConstraint(SecurityConstraint securityConstraint) {
        this.securityConstraints.add(securityConstraint);
    }

    public void removeSecurityConstraint(SecurityConstraint securityConstraint) {
        this.securityConstraints.remove(securityConstraint);
    }

    @Override
    public boolean hasWebServiceClients() {
        return !this.serviceReferences.isEmpty();
    }

    public boolean hasServiceReferenceDescriptors() {
        return !this.serviceReferences.isEmpty();
    }

    @Override
    public Set<ServiceReferenceDescriptor> getServiceReferenceDescriptors() {
        return this.serviceReferences;
    }

    @Override
    public ServiceReferenceDescriptor getServiceReferenceByName(String name) {
        ServiceReferenceDescriptor sr = this.findServiceReferenceByName(name);
        if (sr != null) {
            return sr;
        }
        throw new IllegalArgumentException(MessageFormat.format("This web app [{0}] has no service reference by the name of [{1}]", this.getName(), name));
    }

    protected ServiceReferenceDescriptor findServiceReferenceByName(String name) {
        for (ServiceReferenceDescriptor srd : this.serviceReferences) {
            if (!srd.getName().equals(name)) continue;
            return srd;
        }
        return null;
    }

    @Override
    public void addServiceReferenceDescriptor(ServiceReferenceDescriptor serviceRef) {
        serviceRef.setBundleDescriptor(this);
        this.serviceReferences.add(serviceRef);
    }

    @Override
    public void removeServiceReferenceDescriptor(ServiceReferenceDescriptor serviceRef) {
        serviceRef.setBundleDescriptor(null);
        this.serviceReferences.remove(serviceRef);
    }

    public List<ServletFilter> getServletFiltersCopy() {
        return List.copyOf(this.getServletFilters());
    }

    public List<ServletFilter> getServletFilters() {
        return this.servletFilters;
    }

    public void addServletFilter(ServletFilter filter) {
        String name = filter.getName();
        boolean found = false;
        for (ServletFilter servletFilter : this.servletFilters) {
            if (!name.equals(servletFilter.getName())) continue;
            found = true;
            break;
        }
        if (!found) {
            this.servletFilters.add(filter);
        }
    }

    public List<ServletFilterMapping> getServletFilterMappings() {
        return this.servletFilterMappings;
    }

    public void addServletFilterMapping(ServletFilterMapping filter) {
        if (!this.servletFilterMappings.contains(filter)) {
            this.servletFilterMappings.add(filter);
        }
    }

    public Set<WebComponentDescriptor> getWebComponentDescriptors() {
        return this.webComponentDescriptors;
    }

    public WebComponentDescriptor getWebComponentByCanonicalName(String canonicalName) {
        for (WebComponentDescriptor descriptor : this.webComponentDescriptors) {
            if (!descriptor.getCanonicalName().equals(canonicalName)) continue;
            return descriptor;
        }
        return null;
    }

    public WebComponentDescriptor[] getWebComponentByImplName(String webComponentImplementation) {
        ArrayList<WebComponentDescriptor> webCompList = new ArrayList<WebComponentDescriptor>();
        for (WebComponentDescriptor webComp : this.webComponentDescriptors) {
            if (!webComp.getWebComponentImplementation().equals(webComponentImplementation)) continue;
            webCompList.add(webComp);
        }
        return webCompList.toArray(new WebComponentDescriptor[webCompList.size()]);
    }

    public void addWebComponentDescriptor(WebComponentDescriptor webComponentDescriptor) {
        this.webComponentDescriptors.add(webComponentDescriptor);
    }

    public void resetUrlPatternToServletNameMap() {
        this.urlPattern2ServletName = null;
    }

    public Map<String, String> getUrlPatternToServletNameMap(boolean initializeIfNull) {
        if (this.urlPattern2ServletName == null && initializeIfNull) {
            this.urlPattern2ServletName = new HashMap<String, String>();
            for (WebComponentDescriptor wc : this.webComponentDescriptors) {
                String name = wc.getCanonicalName();
                for (String up : wc.getUrlPatternsSet()) {
                    String oldName = this.urlPattern2ServletName.put(up, name);
                    if (oldName == null || oldName.equals(name)) continue;
                    throw new IllegalStateException(MessageFormat.format("Servlet [{0}] and Servlet [{1}] have the same url pattern: [{2}]", oldName, name, up));
                }
            }
        }
        return this.urlPattern2ServletName;
    }

    public Set<String> getWelcomeFiles() {
        return this.welcomeFiles;
    }

    public void addWelcomeFile(String fileUri) {
        this.welcomeFiles.add(fileUri);
    }

    public SunWebApp getSunDescriptor() {
        return null;
    }

    public void setSunDescriptor(SunWebApp webApp) {
        throw new UnsupportedOperationException("setSunDescriptor");
    }

    @Override
    public List<InjectionCapable> getInjectableResourcesByClass(String className) {
        return this.getInjectableResourcesByClass(className, this);
    }

    @Override
    public List<InjectionCapable> getInjectableResourcesByClass(String className, JndiNameEnvironment jndiNameEnv) {
        LinkedList<InjectionCapable> injectables = new LinkedList<InjectionCapable>();
        for (InjectionCapable next : this.getInjectableResources(jndiNameEnv)) {
            if (!next.isInjectable()) continue;
            for (InjectionTarget target : next.getInjectionTargets()) {
                if (!target.getClassName().equals(className)) continue;
                injectables.add(next);
            }
        }
        if (((WebBundleDescriptor)jndiNameEnv).hasWebServices()) {
            for (InjectionCapable next : this.getInjectableResources(this)) {
                if (!next.isInjectable()) continue;
                for (InjectionTarget target : next.getInjectionTargets()) {
                    for (WebServiceEndpoint endpoint : this.getWebServices().getEndpoints()) {
                        String servletImplClass = endpoint.getServletImplClass();
                        if (!target.getClassName().equals(servletImplClass)) continue;
                        injectables.add(next);
                    }
                }
            }
        }
        return injectables;
    }

    @Override
    public InjectionInfo getInjectionInfoByClass(Class<?> clazz) {
        return this.getInjectionInfoByClass(clazz, this);
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
        String wname;
        toStringBuffer.append('\n').append(this.getClass().getSimpleName()).append('\n');
        super.print(toStringBuffer);
        toStringBuffer.append("\n context root ").append(this.getContextRoot());
        if (this.getSessionConfig() != null) {
            toStringBuffer.append(this.getSessionConfig());
        }
        if ((wname = this.getName()) != null && !wname.isEmpty()) {
            toStringBuffer.append("\n name ").append(wname);
        }
        toStringBuffer.append("\n mimeMappings ").append(this.getMimeMappings());
        toStringBuffer.append("\n welcomeFiles ").append(this.getWelcomeFiles());
        toStringBuffer.append("\n errorPageDescriptors ").append(this.errorPageDescriptors);
        toStringBuffer.append("\n appListenerDescriptors ").append(this.getAppListenersCopy());
        toStringBuffer.append("\n contextParameters ").append(this.getContextParameters());
        toStringBuffer.append("\n ejbReferences ");
        WebBundleDescriptor.printDescriptorSet(this.getEjbReferenceDescriptors(), toStringBuffer);
        toStringBuffer.append("\n resourceEnvRefReferences ");
        WebBundleDescriptor.printDescriptorSet(this.getResourceEnvReferenceDescriptors(), toStringBuffer);
        toStringBuffer.append("\n messageDestReferences ");
        WebBundleDescriptor.printDescriptorSet(this.getMessageDestinationReferenceDescriptors(), toStringBuffer);
        toStringBuffer.append("\n resourceReferences ");
        WebBundleDescriptor.printDescriptorSet(this.getResourceReferenceDescriptors(), toStringBuffer);
        toStringBuffer.append("\n serviceReferences ");
        WebBundleDescriptor.printDescriptorSet(this.getServiceReferenceDescriptors(), toStringBuffer);
        toStringBuffer.append("\n distributable ").append(this.isDistributable());
        toStringBuffer.append("\n denyUncoveredHttpMethods ").append(this.isDenyUncoveredHttpMethods());
        toStringBuffer.append("\n securityRoles ").append(this.getRoles());
        toStringBuffer.append("\n securityConstraints ").append(this.getSecurityConstraints());
        toStringBuffer.append("\n contextRoot ").append(this.getContextRoot());
        toStringBuffer.append("\n loginConfiguration ").append(this.getLoginConfiguration());
        toStringBuffer.append("\n webComponentDescriptors ");
        WebBundleDescriptor.printDescriptorSet(this.getWebComponentDescriptors(), toStringBuffer);
        toStringBuffer.append("\n environmentEntries ");
        WebBundleDescriptor.printDescriptorSet(this.getEnvironmentEntries(), toStringBuffer);
    }

    private static void printDescriptorSet(Set<?> descSet, StringBuffer sbuf) {
        if (descSet == null) {
            return;
        }
        for (Object obj : descSet) {
            if (obj instanceof Descriptor) {
                ((Descriptor)obj).print(sbuf);
                continue;
            }
            sbuf.append(obj);
        }
    }
}

