/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deploy.shared;

import com.sun.enterprise.deploy.shared.AbstractReadableArchive;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.deploy.shared.Util;
import com.sun.enterprise.util.io.FileUtils;
import jakarta.inject.Inject;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.net.URI;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.Archive;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.api.deployment.archive.WritableArchiveEntry;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.jvnet.hk2.annotations.Service;

@Service(name="file")
@PerLookup
public class FileArchive
extends AbstractReadableArchive
implements WritableArchive {
    private static final Logger deplLogger = DeploymentContextImpl.deplLogger;
    @LogMessageInfo(message="Attempt to list files in {0} failed, perhaps because that is not a valid directory or because file permissions do not allow GlassFish to access it", level="WARNING")
    private static final String FILE_LIST_FAILURE = "NCLS-DEPLOYMENT-00022";
    @LogMessageInfo(message="Ignoring {0} because the containing archive {1} recorded it as a pre-existing stale file", level="WARNING")
    private static final String STALE_FILES_SKIPPED = "NCLS-DEPLOYMENT-00023";
    private static final Level DEBUG_LEVEL = Level.FINE;
    @Inject
    private ArchiveFactory archiveFactory;
    private File archive;
    private URI uri;
    private StaleFileManager staleFileManager;
    private boolean isOpenedOrCreated;

    public FileArchive() {
    }

    public FileArchive(URI uri) throws IOException {
        this.open(uri);
    }

    @Override
    public void open(URI uri) throws IOException {
        if (!uri.getScheme().equals("file")) {
            throw new IOException("Wrong scheme for FileArchive : " + uri.getScheme());
        }
        this.uri = uri;
        this.archive = new File(uri);
        if (!this.archive.exists()) {
            throw new FileNotFoundException(uri.getSchemeSpecificPart());
        }
        this.isOpenedOrCreated = true;
        this.staleFileManager = StaleFileManager.Util.getInstance(this.archive);
    }

    public void open(String uri) throws IOException {
        this.open(URI.create(uri));
    }

    @Override
    public long getArchiveSize() throws NullPointerException, SecurityException {
        if (this.uri == null) {
            return -1L;
        }
        return new File(this.uri).length();
    }

    @Override
    public void create(URI uri) throws IOException {
        this.uri = uri;
        this.archive = new File(uri);
        this.staleFileManager = StaleFileManager.Util.getInstance(this.archive);
        if (!this.archive.exists() && !this.archive.mkdirs()) {
            throw new IOException("Unable to create directory for " + this.archive.getAbsolutePath());
        }
        this.isOpenedOrCreated = true;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean delete() {
        try {
            boolean result = this.deleteDir(this.archive);
            StaleFileManager.Util.markDeletedArchive(this);
            return result;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean isDirectory(String name) {
        File candidate = new File(this.archive, name);
        return this.isEntryValid(candidate) && candidate.isDirectory();
    }

    @Override
    public Enumeration<String> entries() {
        return this.entries("");
    }

    @Override
    public Collection<String> getDirectories() throws IOException {
        ArrayList<String> results = new ArrayList<String>();
        if (this.archive != null) {
            for (File file : this.archive.listFiles()) {
                if (!file.isDirectory() || !this.isEntryValid(file)) continue;
                results.add(file.getName());
            }
        }
        return results;
    }

    @Override
    public Enumeration<String> entries(String prefix) {
        prefix = prefix.replace('/', File.separatorChar);
        File file = new File(this.archive, prefix);
        List<String> namesList = this.getListOfFiles(file, deplLogger);
        return Collections.enumeration(namesList);
    }

    @Override
    public boolean exists() {
        if (this.archive == null) {
            return false;
        }
        return this.archive.exists();
    }

    @Override
    public ReadableArchive getSubArchive(String name) throws IOException {
        File subEntry = new File(this.getFileSubArchivePath(name));
        if (!subEntry.exists()) {
            return null;
        }
        if (!this.isEntryValid(subEntry)) {
            deplLogger.log(DEBUG_LEVEL, "FileArchive.getSubArchive for {0} found that it is not a valid entry; it is stale", subEntry.getAbsolutePath());
            return null;
        }
        deplLogger.log(DEBUG_LEVEL, "FileArchive.getSubArchive for {0} found that it is valid", subEntry.getAbsolutePath());
        ReadableArchive result = this.archiveFactory.openArchive(subEntry);
        if (result instanceof AbstractReadableArchive) {
            ((AbstractReadableArchive)result).setParentArchive(this);
        }
        return result;
    }

    @Override
    public WritableArchive createSubArchive(String name) throws IOException {
        String subEntryName = this.getFileSubArchivePath(name);
        File subEntry = new File(subEntryName);
        if (!subEntry.exists()) {
            if (!subEntry.exists() && !subEntry.mkdirs()) {
                throw new IOException("Unable to create directory for " + subEntry.getAbsolutePath());
            }
            deplLogger.log(DEBUG_LEVEL, "FileArchive.createSubArchive created dirs for {0}", subEntry.getAbsolutePath());
        } else {
            deplLogger.log(DEBUG_LEVEL, "FileArchive.createSubArchive found existing dir for {0}", subEntry.getAbsolutePath());
            this.staleFileManager().recordValidEntry(subEntry);
        }
        WritableArchive result = this.archiveFactory.createArchive(subEntry);
        if (result instanceof AbstractReadableArchive) {
            ((AbstractReadableArchive)((Object)result)).setParentArchive(this);
        }
        return result;
    }

    @Override
    public boolean exists(String name) throws IOException {
        File input = new File(this.archive, name = name.replace('/', File.separatorChar));
        return input.exists() && this.isEntryValid(input);
    }

    @Override
    public InputStream getEntry(String name) throws IOException {
        File input = this.getEntryFile(name);
        if (!input.exists() || input.isDirectory() || !this.isEntryValid(input)) {
            return null;
        }
        FileInputStream fis = new FileInputStream(input);
        try {
            BufferedInputStream bis = new BufferedInputStream(fis);
            return bis;
        }
        catch (Throwable tx) {
            try {
                fis.close();
            }
            catch (Throwable thr) {
                throw new IOException("Error closing FileInputStream after error opening BufferedInputStream for entry " + name, thr);
            }
            throw new IOException("Error opening BufferedInputStream for entry " + name, tx);
        }
    }

    @Override
    public long getEntrySize(String name) {
        File input = new File(this.archive, name = name.replace('/', File.separatorChar));
        if (!input.exists() || !this.isEntryValid(input)) {
            return 0L;
        }
        return input.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Manifest getManifest() throws IOException {
        try (InputStream is = null;){
            is = this.getEntry("META-INF/MANIFEST.MF");
            if (is != null) {
                Manifest m;
                Manifest manifest = m = new Manifest(is);
                return manifest;
            }
        }
        return null;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public boolean renameTo(String name) {
        return FileUtils.renameFile(this.archive, new File(name));
    }

    @Override
    public WritableArchiveEntry putNextEntry(String name) throws IOException {
        String dirs;
        File dirsFile;
        File newFile = new File(this.archive, name = name.replace('/', File.separatorChar));
        if (newFile.exists() && !this.deleteEntry(name, false) && this.uri != null) {
            deplLogger.log(Level.FINE, "Could not delete file {0} in FileArchive {1} during putNextEntry; continuing", new Object[]{name, this.uri.toASCIIString()});
        }
        if (name.lastIndexOf(File.separatorChar) != -1 && !(dirsFile = new File(this.archive, dirs = name.substring(0, name.lastIndexOf(File.separatorChar)))).exists() && !dirsFile.mkdirs()) {
            throw new IOException("Unable to create directory for " + dirsFile.getAbsolutePath());
        }
        this.staleFileManager().recordValidEntry(newFile);
        FileOutputStream outputStream = new FileOutputStream(newFile);
        return new WritableArchiveEntry(() -> outputStream, outputStream::close);
    }

    @Override
    public String getName() {
        return Util.getURIName(this.getURI());
    }

    public boolean supportsElementsOverwriting() {
        return true;
    }

    public boolean deleteEntry(String name) {
        return this.deleteEntry(name, true);
    }

    private String getFileSubArchivePath(String name) throws IOException {
        File subDir;
        File file = new File(name = name.replace('/', File.separatorChar));
        if (file.isAbsolute()) {
            subDir = file;
        } else {
            subDir = new File(this.archive, FileUtils.makeFriendlyFilenameExtension(name));
            if (!subDir.exists() && !(subDir = new File(this.archive, name)).exists()) {
                subDir = new File(this.archive, FileUtils.makeFriendlyFilenameExtension(name));
            }
        }
        return subDir.getPath();
    }

    private File getEntryFile(String name) {
        name = name.replace('/', File.separatorChar);
        return new File(this.archive, name);
    }

    private boolean isEntryValid(File entry) {
        return this.isEntryValid(entry, true, deplLogger);
    }

    private boolean isEntryValid(File entry, boolean isLogging) {
        return this.isEntryValid(entry, isLogging, deplLogger);
    }

    private boolean isEntryValid(File entry, boolean isLogging, Logger logger2) {
        return this.staleFileManager().isEntryValid(entry, isLogging, logger2);
    }

    private StaleFileManager myStaleFileManager() {
        if (!this.isOpenedOrCreated) {
            throw new IllegalStateException();
        }
        return this.staleFileManager;
    }

    private StaleFileManager staleFileManager() {
        ReadableArchive parent = this.getParentArchive();
        if (parent == null) {
            return this.myStaleFileManager();
        }
        if (parent instanceof FileArchive) {
            return ((FileArchive)parent).staleFileManager();
        }
        return null;
    }

    private boolean isEntryValid(String entryName, Logger logger2) {
        return this.isEntryValid(this.getEntryFile(entryName), true, logger2);
    }

    private boolean deleteDir(File directory) throws IOException {
        if (!directory.isDirectory()) {
            throw new FileNotFoundException(directory.getPath());
        }
        boolean allDeletesSucceeded = true;
        if (!Files.isSymbolicLink(directory.toPath())) {
            File[] entries;
            for (File entry : entries = directory.listFiles()) {
                if (entry.isDirectory()) {
                    allDeletesSucceeded &= this.deleteDir(entry);
                    continue;
                }
                if (entry.equals(StaleFileManager.Util.markerFile(this.archive))) continue;
                boolean fileDeleteOK = FileUtils.deleteFileWithWaitLoop(entry);
                if (fileDeleteOK) {
                    this.myStaleFileManager().recordDeletedEntry(entry);
                }
                allDeletesSucceeded &= fileDeleteOK;
            }
        }
        return allDeletesSucceeded && FileUtils.deleteFileWithWaitLoop(directory);
    }

    List<String> getListOfFiles(final File directory, final Logger logger2) {
        if (this.archive == null || directory == null || !directory.isDirectory()) {
            return Collections.emptyList();
        }
        final ArrayList<String> files = new ArrayList<String>();
        try {
            Files.walkFileTree(directory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (!directory.toPath().equals(dir)) {
                        String fileName = FileArchive.this.getFileOrDirectoryName(dir);
                        if (FileArchive.this.isEntryValid(fileName, logger2)) {
                            files.add(fileName);
                        } else {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path aList, BasicFileAttributes attrs) {
                    String fileName = FileArchive.this.getFileOrDirectoryName(aList);
                    if (!fileName.equals("META-INF/MANIFEST.MF") && FileArchive.this.isEntryValid(fileName, logger2)) {
                        files.add(fileName);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            deplLogger.log(Level.WARNING, FILE_LIST_FAILURE, directory.getAbsolutePath());
        }
        return files;
    }

    private String getFileOrDirectoryName(Path path) {
        String fileName = path.toAbsolutePath().toString().substring(this.archive.getAbsolutePath().length() + 1);
        return fileName.replace(File.separatorChar, '/');
    }

    private boolean deleteEntry(String name, boolean isLogging) {
        File input = new File(this.archive, name = name.replace('/', File.separatorChar));
        if (!input.exists() || !this.isEntryValid(input, isLogging)) {
            return false;
        }
        boolean result = input.delete();
        this.myStaleFileManager().recordDeletedEntry(input);
        return result;
    }

    public static interface StaleFileManager {
        public boolean isEntryValid(File var1, boolean var2);

        public boolean isEntryValid(File var1, boolean var2, Logger var3);

        public boolean isEntryMarkerFile(File var1);

        public void recordValidEntry(File var1);

        public void recordDeletedEntry(File var1);

        public void flush();

        public static class Util {
            private static final String MARKER_FILE_PATH = ".glassfishStaleFiles";

            private static File markerFile(File archive) {
                return new File(archive, MARKER_FILE_PATH);
            }

            public static void markDeletedArchive(Archive archive) {
                if (!(archive instanceof FileArchive)) {
                    return;
                }
                File archiveFile = new File(archive.getURI());
                Util.markDeletedArchive(archiveFile);
            }

            public static void markDeletedArchive(File archiveFile) {
                if (!archiveFile.exists()) {
                    return;
                }
                Iterator<File> staleFileIt = Util.findFiles(archiveFile);
                if (!staleFileIt.hasNext()) {
                    return;
                }
                Path archiveURI = archiveFile.toPath();
                try (PrintStream ps = new PrintStream(Util.markerFile(archiveFile));){
                    while (staleFileIt.hasNext()) {
                        Path relativeURI = archiveURI.relativize(staleFileIt.next().toPath());
                        ps.println(relativeURI);
                        deplLogger.log(DEBUG_LEVEL, "FileArchive.StaleFileManager recording left-over file {0}", relativeURI);
                    }
                }
                catch (FileNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
            }

            private static Iterator<File> findFiles(final File dir) {
                return new Iterator<File>(){
                    private final List<File> fileList;
                    private final ListIterator<File> fileListIt;
                    {
                        this.fileList = new ArrayList<File>(Arrays.asList(dir.listFiles(new MarkerExcluderFileFilter())));
                        this.fileListIt = this.fileList.listIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.fileListIt.hasNext();
                    }

                    @Override
                    public File next() {
                        File result = this.fileListIt.next();
                        if (result.isDirectory()) {
                            for (File f : result.listFiles(new MarkerExcluderFileFilter())) {
                                this.fileListIt.add(f);
                                this.fileListIt.previous();
                            }
                        }
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public static StaleFileManager getInstance(File archive) throws IOException {
                if (archive.exists()) {
                    return new StaleFileManagerImpl(archive);
                }
                return new StaleFileManagerImplNoop();
            }

            private static final class MarkerExcluderFileFilter
            implements FileFilter {
                private MarkerExcluderFileFilter() {
                }

                @Override
                public boolean accept(File pathname) {
                    return !pathname.getName().equals(Util.MARKER_FILE_PATH);
                }
            }
        }
    }

    private static class StaleFileManagerImpl
    implements StaleFileManager {
        private static final String LINE_SEP = System.lineSeparator();
        private final File archiveFile;
        private final Path archivePath;
        private final Collection<String> staleEntryNames;
        private final File markerFile;

        private StaleFileManagerImpl(File archive) throws FileNotFoundException, IOException {
            this.archiveFile = archive;
            this.archivePath = archive.toPath();
            this.markerFile = StaleFileManager.Util.markerFile(archive);
            this.staleEntryNames = StaleFileManagerImpl.readStaleEntryNames(this.markerFile);
        }

        private static Collection<String> readStaleEntryNames(File markerFile) throws FileNotFoundException, IOException {
            ArrayList<String> result = new ArrayList<String>();
            if (!markerFile.exists()) {
                return result;
            }
            try (LineNumberReader reader = new LineNumberReader(new FileReader(markerFile));){
                String line;
                StringBuffer entriesToSkip;
                boolean isShowEntriesToBeSkipped = deplLogger.isLoggable(DEBUG_LEVEL);
                StringBuffer stringBuffer = entriesToSkip = isShowEntriesToBeSkipped ? new StringBuffer() : null;
                while ((line = reader.readLine()) != null) {
                    result.add(line);
                    if (!isShowEntriesToBeSkipped) continue;
                    entriesToSkip.append(line).append(LINE_SEP);
                }
                if (isShowEntriesToBeSkipped) {
                    deplLogger.log(DEBUG_LEVEL, "FileArchive.StaleFileManager will skip following file(s): {0}{1}", new Object[]{LINE_SEP, entriesToSkip.toString()});
                }
                ArrayList<String> arrayList = result;
                return arrayList;
            }
        }

        @Override
        public boolean isEntryValid(File f, boolean isLogging) {
            return this.isEntryValid(f, isLogging, deplLogger);
        }

        @Override
        public boolean isEntryValid(File f, boolean isLogging, Logger logger2) {
            boolean result;
            boolean bl = result = !this.isEntryMarkerFile(f) && !this.staleEntryNames.contains(this.archivePath.relativize(f.toPath()).toString());
            if (!result && !this.isEntryMarkerFile(f) && isLogging) {
                deplLogger.log(Level.WARNING, FileArchive.STALE_FILES_SKIPPED, new Object[]{this.archivePath.relativize(f.toPath()).toString(), this.archiveFile.getAbsolutePath()});
            }
            return result;
        }

        @Override
        public boolean isEntryMarkerFile(File f) {
            return this.markerFile.equals(f);
        }

        @Override
        public void recordValidEntry(File f) {
            if (this.updateStaleEntry(f, "FileArchive.StaleFileManager marking formerly stale entry {0} as active")) {
                do {
                    f = f.getParentFile();
                    this.updateStaleEntry(f, "FileArchive.StaleFileManager marking formerly stale ancestor {0} as active");
                } while (!f.equals(this.archiveFile));
                this.flush();
            }
        }

        @Override
        public void recordDeletedEntry(File f) {
            if (this.updateStaleEntry(f, "FileArchive.StaleFileManager recording deletion of entry {0}")) {
                do {
                    if (this.isStaleEntryInDir(f.getParentFile())) {
                        return;
                    }
                    this.updateStaleEntry(f, "FileArchive.StaleFileManager recording that formerly stale directory {0} is no longer stale");
                } while (!(f = f.getParentFile()).equals(this.archiveFile));
                this.flush();
            }
        }

        private boolean isStaleEntryInDir(File dir) {
            String dirPath = this.archivePath.relativize(dir.toPath()).toString();
            for (String staleEntryName : this.staleEntryNames) {
                if (!staleEntryName.startsWith(dirPath) || staleEntryName.equals(dirPath)) continue;
                deplLogger.log(DEBUG_LEVEL, "FileArchive.StaleFileManager.isStaleEntryInDir found remaining stale entry {0} in {1}", new Object[]{staleEntryName, dir.getAbsolutePath()});
                return true;
            }
            return false;
        }

        private boolean updateStaleEntry(File f, String msg) {
            if (this.staleEntryNames.isEmpty()) {
                deplLogger.log(DEBUG_LEVEL, "FileArchive.StaleFileManager.updateStaleEntry finds staleEntryNames is empty; skipping");
                return false;
            }
            String entryName = this.archivePath.relativize(f.toPath()).toString();
            boolean wasStale = this.staleEntryNames.remove(entryName);
            if (wasStale) {
                deplLogger.log(DEBUG_LEVEL, msg, entryName);
            } else {
                deplLogger.log(DEBUG_LEVEL, "updateStaleEntry did not find {0} in the stale entries {1}", new Object[]{entryName, this.staleEntryNames.toString()});
            }
            return wasStale;
        }

        @Override
        public void flush() {
            if (this.staleEntryNames.isEmpty()) {
                deplLogger.log(DEBUG_LEVEL, "FileArchive.StaleFileManager.flush deleting marker file; no more stale entries");
                File marker = StaleFileManager.Util.markerFile(this.archiveFile);
                if (!marker.exists() || marker.delete()) {
                    return;
                }
                deplLogger.log(Level.FINE, "FileArchive.StatleFileManager.flush could not delete marker file {0}; continuing by writing out an empty marker file", marker.getAbsolutePath());
            }
            try (PrintStream ps = new PrintStream(StaleFileManager.Util.markerFile(this.archiveFile));){
                for (String staleEntryName : this.staleEntryNames) {
                    ps.println(staleEntryName);
                }
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            deplLogger.log(DEBUG_LEVEL, "FileArchive.StaleFileManager.flush rewrote on-disk file {0} containing {1}", new Object[]{this.markerFile.getAbsolutePath(), this.staleEntryNames.toString()});
        }
    }

    private static class StaleFileManagerImplNoop
    implements StaleFileManager {
        private StaleFileManagerImplNoop() {
        }

        @Override
        public boolean isEntryValid(File f, boolean isLogging) {
            return true;
        }

        @Override
        public boolean isEntryValid(File f, boolean isLogging, Logger logger2) {
            return true;
        }

        @Override
        public boolean isEntryMarkerFile(File f) {
            return false;
        }

        @Override
        public void recordValidEntry(File f) {
        }

        @Override
        public void recordDeletedEntry(File f) {
        }

        @Override
        public void flush() {
        }
    }
}

