/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl;

import com.sun.enterprise.container.common.impl.EntityManagerFactoryWrapper;
import com.sun.enterprise.container.common.impl.PhysicalEntityManagerWrapper;
import com.sun.enterprise.container.common.impl.QueryWrapper;
import com.sun.enterprise.container.common.impl.StoreProcedureQueryWrapper;
import com.sun.enterprise.container.common.impl.TypedQueryWrapper;
import com.sun.enterprise.container.common.spi.JavaEEContainer;
import com.sun.enterprise.container.common.spi.util.CallFlowAgent;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.container.common.spi.util.EntityManagerMethod;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.logging.LogDomains;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.PersistenceContextType;
import jakarta.persistence.Query;
import jakarta.persistence.StoredProcedureQuery;
import jakarta.persistence.SynchronizationType;
import jakarta.persistence.TransactionRequiredException;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.transaction.TransactionManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.ComponentInvocationHandler;
import org.glassfish.api.invocation.InvocationException;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Service;

public class EntityManagerWrapper
implements EntityManager,
Serializable {
    private static final Logger LOG = LogDomains.getLogger(EntityManagerWrapper.class, "jakarta.enterprise.system.util", false);
    private String unitName;
    private PersistenceContextType contextType;
    private Map emProperties;
    private SynchronizationType synchronizationType;
    private transient EntityManagerFactory entityManagerFactory;
    private transient TransactionManager txManager;
    private transient InvocationManager invMgr;
    private transient EntityManager extendedEntityManager;
    private transient ComponentEnvManager compEnvMgr;
    private transient CallFlowAgent callFlowAgent;
    private static final Class INVOCATION_PAYLOAD_KEY = EntityManagerWrapper.class;

    public EntityManagerWrapper(TransactionManager txManager, InvocationManager invMgr, ComponentEnvManager compEnvMgr, CallFlowAgent callFlowAgent) {
        this.txManager = txManager;
        this.invMgr = invMgr;
        this.compEnvMgr = compEnvMgr;
        this.callFlowAgent = callFlowAgent;
    }

    public void initializeEMWrapper(String unitName, PersistenceContextType contextType, SynchronizationType synchronizationType, Map emProperties) {
        this.unitName = unitName;
        this.contextType = contextType;
        this.synchronizationType = synchronizationType;
        this.emProperties = emProperties;
        if (contextType == PersistenceContextType.EXTENDED) {
            this._getDelegate();
        }
    }

    private void init() {
        this.entityManagerFactory = EntityManagerFactoryWrapper.lookupEntityManagerFactory(this.invMgr, this.compEnvMgr, this.unitName);
        if (this.entityManagerFactory == null) {
            throw new IllegalStateException("Unable to retrieve EntityManagerFactory for unitName " + this.unitName);
        }
    }

    private void doTransactionScopedTxCheck() {
        if (this.contextType != PersistenceContextType.TRANSACTION) {
            return;
        }
        this.doTxRequiredCheck();
    }

    private void doTxRequiredCheck() {
        if (this.entityManagerFactory == null) {
            this.init();
        }
        if (this.getCurrentTransaction() == null) {
            throw new TransactionRequiredException();
        }
    }

    private EntityManager _getDelegate() {
        EntityManager delegate;
        if (this.entityManagerFactory == null) {
            this.init();
        }
        if (this.contextType == PersistenceContextType.TRANSACTION) {
            JavaEETransaction tx = this.getCurrentTransaction();
            if (tx != null) {
                PhysicalEntityManagerWrapper propagatedPersistenceContext = EntityManagerWrapper.getExtendedEntityManager(tx, this.entityManagerFactory);
                if (propagatedPersistenceContext == null) {
                    propagatedPersistenceContext = EntityManagerWrapper.getTxEntityManager(tx, this.entityManagerFactory);
                    if (propagatedPersistenceContext == null) {
                        EntityManager em = this.entityManagerFactory.createEntityManager(this.synchronizationType, this.emProperties);
                        propagatedPersistenceContext = new PhysicalEntityManagerWrapper(em, this.synchronizationType);
                        tx.addTxEntityManagerMapping(this.entityManagerFactory, propagatedPersistenceContext);
                    } else if (this.synchronizationType == SynchronizationType.SYNCHRONIZED && propagatedPersistenceContext.getSynchronizationType() == SynchronizationType.UNSYNCHRONIZED) {
                        throw new IllegalStateException("Detected an UNSYNCHRONIZED  persistence context being propagated to SYNCHRONIZED persistence context.");
                    }
                }
                delegate = propagatedPersistenceContext.getEM();
            } else {
                delegate = this.getNonTxEMFromCurrentInvocation();
            }
        } else {
            Object cc;
            Object ci;
            if (this.extendedEntityManager == null && (ci = this.invMgr.getCurrentInvocation()) != null && (cc = ((ComponentInvocation)ci).getContainer()) instanceof JavaEEContainer) {
                this.extendedEntityManager = ((JavaEEContainer)cc).lookupExtendedEntityManager(this.entityManagerFactory);
            }
            delegate = this.extendedEntityManager;
        }
        LOG.log(Level.FINE, "In EntityManagerWrapper::_getDelegate(). Logical entity manager={0}. Physical entity manager={1}", new Object[]{this, delegate});
        return delegate;
    }

    private JavaEETransaction getCurrentTransaction() {
        try {
            return (JavaEETransaction)this.txManager.getTransaction();
        }
        catch (Exception e) {
            throw new IllegalStateException("exception retrieving tx", e);
        }
    }

    private EntityManager getNonTxEMFromCurrentInvocation() {
        EntityManager nonTxEM;
        Object currentInvocation = this.invMgr.getCurrentInvocation();
        Map<EntityManagerFactory, EntityManager> nonTxEMs = EntityManagerWrapper.getNonTxEMsFromCurrentInvocation(currentInvocation);
        if (nonTxEMs == null) {
            nonTxEMs = new HashMap<EntityManagerFactory, EntityManager>();
            ((ComponentInvocation)currentInvocation).setRegistryFor(INVOCATION_PAYLOAD_KEY, nonTxEMs);
        }
        if ((nonTxEM = nonTxEMs.get(this.entityManagerFactory)) == null) {
            nonTxEM = this.entityManagerFactory.createEntityManager(this.synchronizationType, this.emProperties);
            nonTxEMs.put(this.entityManagerFactory, nonTxEM);
        }
        return nonTxEM;
    }

    private static Map<EntityManagerFactory, EntityManager> getNonTxEMsFromCurrentInvocation(ComponentInvocation currentInvocation) {
        return (Map)currentInvocation.getRegistryFor(INVOCATION_PAYLOAD_KEY);
    }

    @Override
    public void persist(Object entity) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.PERSIST);
            }
            this._getDelegate().persist(entity);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    @Override
    public <T> T merge(T entity) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.MERGE);
            }
            T t = this._getDelegate().merge(entity);
            return t;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    @Override
    public void remove(Object entity) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.REMOVE);
            }
            this._getDelegate().remove(entity);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T find(Class<T> entityClass, Object primaryKey) {
        T returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.FIND);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.find(entityClass, primaryKey);
            this.clearDetachedPersistenceContext(delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        T returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.FIND);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.find(entityClass, primaryKey, properties);
            this.clearDetachedPersistenceContext(delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        T returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.FIND_CLASS_OBJECT_LOCKMODETYPE);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.find(entityClass, primaryKey, lockMode);
            this.clearDetachedPersistenceContext(delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        T returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.FIND_CLASS_OBJECT_LOCKMODETYPE_PROPERTIES);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.find(entityClass, primaryKey, lockMode, properties);
            this.clearDetachedPersistenceContext(delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        T returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_REFERENCE);
            }
            returnValue = this._getDelegate().getReference(entityClass, primaryKey);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    @Override
    public void flush() {
        this.doTxRequiredCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.FLUSH);
            }
            this._getDelegate().flush();
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query createQuery(String ejbqlString) {
        Query returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_QUERY);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createQuery(ejbqlString);
            returnValue = this.wrapQueryIfDetached(returnValue, delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> TypedQuery<T> createQuery(String ejbqlString, Class<T> resultClass) {
        TypedQuery<T> returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_QUERY_STRING_CLASS);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createQuery(ejbqlString, resultClass);
            returnValue = this.wrapQueryIfDetached(returnValue, delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        TypedQuery<T> returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_QUERY_CRITERIA_QUERY);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createQuery(criteriaQuery);
            returnValue = this.wrapQueryIfDetached(returnValue, delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query createNamedQuery(String name) {
        Query returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NAMED_QUERY);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNamedQuery(name);
            returnValue = this.wrapQueryIfDetached(returnValue, delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        TypedQuery<T> returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NAMED_QUERY);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNamedQuery(name, resultClass);
            returnValue = this.wrapQueryIfDetached(returnValue, delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query createNativeQuery(String sqlString) {
        Query returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NATIVE_QUERY_STRING);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNativeQuery(sqlString);
            returnValue = this.wrapQueryIfDetached(returnValue, delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query createNativeQuery(String sqlString, Class resultClass) {
        Query returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NATIVE_QUERY_STRING_CLASS);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNativeQuery(sqlString, resultClass);
            returnValue = this.wrapQueryIfDetached(returnValue, delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        Query returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NATIVE_QUERY_STRING_STRING);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNativeQuery(sqlString, resultSetMapping);
            returnValue = this.wrapQueryIfDetached(returnValue, delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    @Override
    public void refresh(Object entity) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.REFRESH);
            }
            this._getDelegate().refresh(entity);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    @Override
    public void refresh(Object entity, Map<String, Object> properties) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.REFRESH_OBJECT_PROPERTIES);
            }
            this._getDelegate().refresh(entity, properties);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    @Override
    public void refresh(Object entity, LockModeType lockMode) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.REFRESH_OBJECT_LOCKMODETYPE);
            }
            this._getDelegate().refresh(entity, lockMode);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.REFRESH_OBJECT_LOCKMODETYPE_MAP);
            }
            this._getDelegate().refresh(entity, lockMode, properties);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object entity) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CONTAINS);
            }
            EntityManager delegate = this._getDelegate();
            boolean bl = delegate.contains(entity);
            return bl;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    @Override
    public LockModeType getLockMode(Object o) {
        this.doTxRequiredCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_LOCK_MODE);
            }
            LockModeType lockModeType = this._getDelegate().getLockMode(o);
            return lockModeType;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    @Override
    public void setProperty(String propertyName, Object value) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.SET_PROPERTY);
            }
            this._getDelegate().setProperty(propertyName, value);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    @Override
    public Map<String, Object> getProperties() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_PROPERTIES);
            }
            Map<String, Object> map = this._getDelegate().getProperties();
            return map;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    @Override
    public void close() {
        if (this.callFlowAgent.isEnabled()) {
            this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CLOSE);
            this.callFlowAgent.entityManagerMethodEnd();
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isOpen() {
        if (this.callFlowAgent.isEnabled()) {
            this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.IS_OPEN);
            this.callFlowAgent.entityManagerMethodEnd();
        }
        return true;
    }

    @Override
    public EntityTransaction getTransaction() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_TRANSACTION);
            }
            EntityTransaction entityTransaction = this._getDelegate().getTransaction();
            return entityTransaction;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    @Override
    public EntityManagerFactory getEntityManagerFactory() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_ENTITY_MANAGER_FACTORY);
            }
            if (this.entityManagerFactory == null) {
                this.init();
            }
            EntityManagerFactory entityManagerFactory = this.entityManagerFactory;
            return entityManagerFactory;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    @Override
    public CriteriaBuilder getCriteriaBuilder() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_CRITERIA_BUILDER);
            }
            CriteriaBuilder criteriaBuilder = this._getDelegate().getCriteriaBuilder();
            return criteriaBuilder;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    @Override
    public Metamodel getMetamodel() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_METAMODEL);
            }
            Metamodel metamodel = this._getDelegate().getMetamodel();
            return metamodel;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    @Override
    public void lock(Object entity, LockModeType lockMode) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.LOCK);
            }
            this._getDelegate().lock(entity, lockMode);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.LOCK_LOCKMODETYPE_MAP);
            }
            this._getDelegate().lock(entity, lockMode, properties);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    @Override
    public void clear() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CLEAR);
            }
            this._getDelegate().clear();
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    @Override
    public void detach(Object o) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.DETATCH);
            }
            this._getDelegate().detach(o);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    @Override
    public Object getDelegate() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_DELEGATE);
            }
            EntityManager entityManager = this._getDelegate();
            return entityManager;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    @Override
    public FlushModeType getFlushMode() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_FLUSH_MODE);
            }
            FlushModeType flushModeType = this._getDelegate().getFlushMode();
            return flushModeType;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    @Override
    public void setFlushMode(FlushModeType flushMode) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.SET_FLUSH_MODE);
            }
            this._getDelegate().setFlushMode(flushMode);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    @Override
    public void joinTransaction() {
        this.doTxRequiredCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.JOIN_TRANSACTION);
            }
            this._getDelegate().joinTransaction();
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    @Override
    public <T> T unwrap(Class<T> tClass) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.UNWRAP);
            }
            T t = this._getDelegate().unwrap(tClass);
            return t;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoredProcedureQuery createNamedStoredProcedureQuery(String name) {
        StoredProcedureQuery returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NAMED_STORED_PROCEDURE_QUERY);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNamedStoredProcedureQuery(name);
            returnValue = this.wrapQueryIfDetached(returnValue, delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoredProcedureQuery createStoredProcedureQuery(String procedureName) {
        StoredProcedureQuery returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_STORED_PROCEDURE_QUERY);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createStoredProcedureQuery(procedureName);
            returnValue = this.wrapQueryIfDetached(returnValue, delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        StoredProcedureQuery returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_STORED_PROCEDURE_QUERY_STRING_CLASS);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createStoredProcedureQuery(procedureName, resultClasses);
            returnValue = this.wrapQueryIfDetached(returnValue, delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        StoredProcedureQuery returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_STORED_PROCEDURE_QUERY_STRING_STRING);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createStoredProcedureQuery(procedureName, resultSetMappings);
            returnValue = this.wrapQueryIfDetached(returnValue, delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    @Override
    public Query createQuery(CriteriaUpdate updateQuery) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_QUERY_CRITERIA_UPDATE);
            }
            Query query = this._getDelegate().createQuery(updateQuery);
            return query;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    @Override
    public Query createQuery(CriteriaDelete deleteQuery) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_QUERY_CRITERIA_DELETE);
            }
            Query query = this._getDelegate().createQuery(deleteQuery);
            return query;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    @Override
    public boolean isJoinedToTransaction() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.IS_JOINED_TO_TRANSACTION);
            }
            boolean bl = this._getDelegate().isJoinedToTransaction();
            return bl;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    @Override
    public <T> EntityGraph<T> createEntityGraph(Class<T> rootType) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_ENTITY_GRAPH_CLASS);
            }
            EntityGraph<T> entityGraph = this._getDelegate().createEntityGraph(rootType);
            return entityGraph;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    @Override
    public EntityGraph<?> createEntityGraph(String graphName) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_ENTITY_GRAPH_STRING);
            }
            EntityGraph<?> entityGraph = this._getDelegate().createEntityGraph(graphName);
            return entityGraph;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    @Override
    public EntityGraph<?> getEntityGraph(String graphName) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_ENTITY_GRAPH);
            }
            EntityGraph<?> entityGraph = this._getDelegate().getEntityGraph(graphName);
            return entityGraph;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    @Override
    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_ENTITY_GRAPHS);
            }
            List<EntityGraph<? super T>> list = this._getDelegate().getEntityGraphs(entityClass);
            return list;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        ServiceLocator defaultServiceLocator = Globals.getDefaultHabitat();
        this.txManager = defaultServiceLocator.getService(TransactionManager.class, new Annotation[0]);
        this.invMgr = defaultServiceLocator.getService(InvocationManager.class, new Annotation[0]);
        this.compEnvMgr = defaultServiceLocator.getService(ComponentEnvManager.class, new Annotation[0]);
        this.callFlowAgent = defaultServiceLocator.getService(CallFlowAgent.class, new Annotation[0]);
    }

    private boolean isDetached() {
        return this.getCurrentTransaction() == null && this.contextType != PersistenceContextType.EXTENDED;
    }

    private StoredProcedureQuery wrapQueryIfDetached(StoredProcedureQuery query, EntityManager delegate) {
        return this.isDetached() ? StoreProcedureQueryWrapper.createQueryWrapper(query, delegate) : query;
    }

    private <T> TypedQuery<T> wrapQueryIfDetached(TypedQuery<T> query, EntityManager delegate) {
        return this.isDetached() ? TypedQueryWrapper.createQueryWrapper(query, delegate) : query;
    }

    private Query wrapQueryIfDetached(Query query, EntityManager delegate) {
        return this.isDetached() ? QueryWrapper.createQueryWrapper(query, delegate) : query;
    }

    private void clearDetachedPersistenceContext(EntityManager em) {
        if (this.isDetached()) {
            em.clear();
        }
    }

    public static PhysicalEntityManagerWrapper getExtendedEntityManager(JavaEETransaction transaction, EntityManagerFactory factory) {
        return (PhysicalEntityManagerWrapper)transaction.getExtendedEntityManagerResource(factory);
    }

    public static PhysicalEntityManagerWrapper getTxEntityManager(JavaEETransaction transaction, EntityManagerFactory factory) {
        return (PhysicalEntityManagerWrapper)transaction.getTxEntityManagerResource(factory);
    }

    @Service
    public static class NonTxEMCleaner
    implements ComponentInvocationHandler {
        @Override
        public void beforePreInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation newInv) throws InvocationException {
        }

        @Override
        public void afterPreInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation curInv) throws InvocationException {
        }

        @Override
        public void beforePostInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation curInv) throws InvocationException {
            Map<EntityManagerFactory, EntityManager> nonTxEMs = EntityManagerWrapper.getNonTxEMsFromCurrentInvocation(curInv);
            if (nonTxEMs != null) {
                for (EntityManager nonTxEM : nonTxEMs.values()) {
                    nonTxEM.close();
                }
            }
        }

        @Override
        public void afterPostInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation curInv) throws InvocationException {
        }
    }
}

