/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.WorkContextHandler;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.logging.LogDomains;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.XATerminator;
import jakarta.resource.spi.work.WorkContext;
import jakarta.resource.spi.work.WorkManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.io.Serializable;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;

public final class BootstrapContextImpl
implements BootstrapContext,
Serializable {
    public static final int MAX_INSTANCE_LENGTH = 24;
    private static final long serialVersionUID = -8449694716854376406L;
    private transient WorkManager wm;
    private XATerminator xa;
    private final String moduleName;
    private String threadPoolId;
    private ClassLoader rarCL;
    private static final Logger logger = LogDomains.getLogger(BootstrapContextImpl.class, "jakarta.enterprise.resource.resourceadapter");

    public BootstrapContextImpl(String moduleName) throws ConnectorRuntimeException {
        this.moduleName = moduleName;
        this.initializeWorkManager();
    }

    public BootstrapContextImpl(String poolId, String moduleName, ClassLoader rarCL) throws ConnectorRuntimeException {
        this.threadPoolId = poolId;
        this.moduleName = moduleName;
        this.rarCL = rarCL;
        this.initializeWorkManager();
    }

    @Override
    public Timer createTimer() {
        return new Timer("connectors-runtime-context", true);
    }

    @Override
    public boolean isContextSupported(Class<? extends WorkContext> aClass) {
        WorkContextHandler wch = ConnectorRuntime.getRuntime().getWorkContextHandler();
        wch.init(this.moduleName, this.rarCL);
        return wch.isContextSupported(true, aClass.getName());
    }

    @Override
    public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        try {
            InitialContext ic = new InitialContext();
            return (TransactionSynchronizationRegistry)ic.lookup("java:comp/TransactionSynchronizationRegistry");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "tx.sync.registry.lookup.failed", e);
            RuntimeException re = new RuntimeException("Transaction Synchronization Registry Unavailable");
            re.initCause(e);
            throw re;
        }
    }

    @Override
    public WorkManager getWorkManager() {
        this.initializeWorkManager();
        return this.wm;
    }

    private void initializeWorkManager() {
        if (this.wm == null) {
            try {
                this.wm = ConnectorRuntime.getRuntime().getWorkManagerProxy(this.threadPoolId, this.moduleName, this.rarCL);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "workmanager.instantiation_error", e);
            }
        }
    }

    @Override
    public XATerminator getXATerminator() {
        this.initializeXATerminator();
        return this.xa;
    }

    private void initializeXATerminator() {
        if (this.xa == null) {
            this.xa = ConnectorRuntime.getRuntime().getXATerminatorProxy(this.moduleName);
        }
    }
}

