/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.customvalidators;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.customvalidators.NotDuplicateTargetName;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.annotation.Annotation;
import org.glassfish.api.admin.config.Named;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.config.Dom;

public class NotDuplicateTargetNameValidator
implements ConstraintValidator<NotDuplicateTargetName, Named> {
    @Override
    public void initialize(NotDuplicateTargetName constraintAnnotation) {
    }

    @Override
    public boolean isValid(Named bean, ConstraintValidatorContext context) {
        if (bean == null) {
            return true;
        }
        Dom beanDom = Dom.unwrap(bean);
        if (beanDom == null) {
            return true;
        }
        ServiceLocator locator = beanDom.getHabitat();
        if (locator == null) {
            return true;
        }
        Domain domain = locator.getService(Domain.class, new Annotation[0]);
        if (domain == null) {
            return true;
        }
        boolean checkCluster = true;
        boolean checkConfig = true;
        boolean checkNode = true;
        boolean checkServer = true;
        if (bean instanceof Server) {
            checkServer = false;
        } else if (bean instanceof Cluster) {
            checkCluster = false;
        } else if (bean instanceof Config) {
            checkConfig = false;
        } else if (bean instanceof Node) {
            checkNode = false;
        }
        String name = bean.getName();
        return !(checkCluster && domain.getClusterNamed(name) != null || checkConfig && domain.getConfigNamed(name) != null || checkNode && domain.getNodeNamed(name) != null) && (!checkServer || domain.getServerNamed(name) == null);
    }
}

