/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.validation.constraints.NotNull;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ConfigExtension;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.api.monitoring.ContainerMonitoring;
import org.glassfish.api.monitoring.MonitoringItem;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

@Configured
public interface MonitoringService
extends ConfigExtension,
PropertyBag {
    @Element
    @NotNull
    public ModuleMonitoringLevels getModuleMonitoringLevels();

    public void setModuleMonitoringLevels(ModuleMonitoringLevels var1) throws PropertyVetoException;

    @Override
    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal props")
    @PropertiesDesc(props={})
    @Element
    public List<Property> getProperty();

    @Attribute(defaultValue="true", dataType=Boolean.class)
    public String getMbeanEnabled();

    public void setMbeanEnabled(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="true", dataType=Boolean.class)
    public String getMonitoringEnabled();

    public void setMonitoringEnabled(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getDtraceEnabled();

    public void setDtraceEnabled(String var1) throws PropertyVetoException;

    @Element
    public List<ContainerMonitoring> getContainerMonitoring();

    @Element(value="*")
    public List<MonitoringItem> getMonitoringItems();

    default public ContainerMonitoring getContainerMonitoring(String name) {
        for (ContainerMonitoring monitoring : this.getContainerMonitoring()) {
            if (!monitoring.getName().equals(name)) continue;
            return monitoring;
        }
        return null;
    }

    default public String getMonitoringLevel(String moduleName) {
        String name = moduleName.replaceAll("-", "");
        Method getter = GetterCache.methods.get(name.toLowerCase());
        if (getter != null) {
            try {
                return (String)getter.invoke((Object)this.getModuleMonitoringLevels(), new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                Logger.getAnonymousLogger().log(Level.WARNING, e.getMessage(), e);
            }
        }
        for (ContainerMonitoring monitoring : this.getContainerMonitoring()) {
            if (!monitoring.getName().equals(moduleName)) continue;
            return monitoring.getLevel();
        }
        return null;
    }

    default public boolean setMonitoringLevel(String moduleName, String level) throws TransactionFailure, PropertyVetoException {
        String name = moduleName.replaceAll("-", "");
        Method setter = SetterCache.methods.get(name.toLowerCase());
        if (setter != null) {
            try {
                Transaction tx = Transaction.getTransaction(this);
                if (tx == null) {
                    throw new TransactionFailure(LocalStringHolder.localStrings.getLocalString("noTransaction", "Internal Error - Cannot obtain transaction object"));
                }
                ModuleMonitoringLevels monitoringLevels = tx.enroll(this.getModuleMonitoringLevels());
                setter.invoke((Object)monitoringLevels, level);
                return true;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                Logger.getAnonymousLogger().log(Level.WARNING, e.getMessage(), e);
            }
        }
        for (ContainerMonitoring monitoring : this.getContainerMonitoring()) {
            if (!monitoring.getName().equals(moduleName)) continue;
            monitoring.setLevel(level);
            return true;
        }
        return false;
    }

    default public boolean isAnyModuleOn() {
        ModuleMonitoringLevels monitoringLevels = this.getModuleMonitoringLevels();
        for (Method getter : GetterCache.methods.values()) {
            try {
                String level = (String)getter.invoke((Object)monitoringLevels, new Object[0]);
                if ("OFF".equals(level)) continue;
                return true;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                Logger.getAnonymousLogger().log(Level.WARNING, e.getMessage(), e);
            }
        }
        for (ContainerMonitoring monitoring : this.getContainerMonitoring()) {
            if ("OFF".equals(monitoring.getLevel())) continue;
            return true;
        }
        return false;
    }

    public static final class GetterCache {
        private static final Map<String, Method> methods;

        private GetterCache() {
            throw new AssertionError();
        }

        static {
            HashMap<String, Method> getMethods = new HashMap<String, Method>();
            for (Method method : ModuleMonitoringLevels.class.getDeclaredMethods()) {
                String methodName = method.getName();
                if (!methodName.startsWith("get") || !method.getReturnType().equals(String.class)) continue;
                getMethods.put(methodName.substring(3).toLowerCase(), method);
            }
            methods = Collections.unmodifiableMap(getMethods);
        }
    }

    public static final class SetterCache {
        private static final Map<String, Method> methods;

        private SetterCache() {
            throw new AssertionError();
        }

        static {
            HashMap<String, Method> setMethods = new HashMap<String, Method>();
            for (Method method : ModuleMonitoringLevels.class.getDeclaredMethods()) {
                String methodName = method.getName();
                if (!methodName.startsWith("set")) continue;
                setMethods.put(methodName.substring(3).toLowerCase(), method);
            }
            methods = Collections.unmodifiableMap(setMethods);
        }
    }

    public static final class LocalStringHolder {
        private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(MonitoringService.class);

        private LocalStringHolder() {
            throw new AssertionError();
        }
    }
}

