/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.stringsubs.impl.algorithm;

import com.sun.enterprise.admin.servermgmt.SLogger;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.algorithm.RadixTreeNode;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.logging.Level;
import java.util.logging.Logger;

class RadixTree {
    private static final Logger _logger = SLogger.getLogger();
    private static final LocalStringsImpl _strings = new LocalStringsImpl(RadixTree.class);
    private RadixTreeNode _rootNode = new RadixTreeNode("", null);

    public void insert(String key, String value) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException(_strings.get("errorInEmptyNullKeyInstertion"));
        }
        char[] inputChars = key.toCharArray();
        int noOfMatchedChars = 0;
        RadixTreeNode node = this._rootNode;
        RadixTreeNode newNode = null;
        int keyLength = inputChars.length;
        block0: while (noOfMatchedChars < keyLength) {
            RadixTreeNode parentNode;
            int i;
            int maxLoop;
            String nodeKey = node.getKey();
            int n = maxLoop = nodeKey.length() > keyLength - noOfMatchedChars ? keyLength - noOfMatchedChars : nodeKey.length();
            for (i = 0; i < maxLoop; ++i) {
                if (nodeKey.charAt(i) != inputChars[noOfMatchedChars]) {
                    newNode = new RadixTreeNode(nodeKey.substring(0, i), null);
                    parentNode = node.getParentNode();
                    parentNode.removeChildNode(node);
                    parentNode.addChildNode(newNode);
                    node.setKey(nodeKey.substring(i));
                    newNode.addChildNode(node);
                    newNode.addChildNode(new RadixTreeNode(key.substring(noOfMatchedChars), value));
                    break block0;
                }
                ++noOfMatchedChars;
            }
            if (nodeKey.length() > maxLoop) {
                newNode = new RadixTreeNode(nodeKey.substring(0, i), value);
                parentNode = node.getParentNode();
                parentNode.removeChildNode(node);
                parentNode.addChildNode(newNode);
                node.setKey(nodeKey.substring(i));
                newNode.addChildNode(node);
                break;
            }
            if (noOfMatchedChars == keyLength) {
                if (node.getValue() != null && !node.getValue().isEmpty()) {
                    _logger.log(Level.INFO, "NCLS-SRVRMGMT-00034", new Object[]{node.getValue(), value});
                }
                node.setValue(value);
                break;
            }
            RadixTreeNode matchedNode = node.getChildNode(inputChars[noOfMatchedChars]);
            if (matchedNode == null) {
                node.addChildNode(new RadixTreeNode(key.substring(noOfMatchedChars), value));
                break;
            }
            node = matchedNode;
        }
    }

    RadixTreeNode getRootNode() {
        return this._rootNode;
    }
}

