/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.stringsubs.impl;

import com.sun.enterprise.admin.servermgmt.SLogger;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.StringSubstitutionProperties;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SubstitutionFileUtil {
    private static final Logger _logger = SLogger.getLogger();
    private static final LocalStringsImpl _strings = new LocalStringsImpl(SubstitutionFileUtil.class);
    private static final String INMEMORY_SUBSTITUTION_FILE_SIZE_IN_KB = "inmemory.substitution.file.size.in.kb";
    private static final int DEFAULT_INMEMORY_SUBSTITUTION_FILE_SIZE_IN_KB = 10240;
    private static int PROVIDED_INMEMORY_SUBSTITUTION_FILE_SIZE_IN_BYTES = 0;
    public static final int MAX_COPY_BYTE_COUNT = 67076096;

    public static int getInMemorySubstitutionFileSizeInBytes() {
        if (PROVIDED_INMEMORY_SUBSTITUTION_FILE_SIZE_IN_BYTES > 0) {
            return PROVIDED_INMEMORY_SUBSTITUTION_FILE_SIZE_IN_BYTES;
        }
        try {
            PROVIDED_INMEMORY_SUBSTITUTION_FILE_SIZE_IN_BYTES = Integer.parseInt(StringSubstitutionProperties.getProperty(INMEMORY_SUBSTITUTION_FILE_SIZE_IN_KB)) * 1024;
        }
        catch (Exception e) {
            _logger.log(Level.INFO, "NCLS-SRVRMGMT-00033");
            PROVIDED_INMEMORY_SUBSTITUTION_FILE_SIZE_IN_BYTES = 10240;
        }
        return PROVIDED_INMEMORY_SUBSTITUTION_FILE_SIZE_IN_BYTES > 0 ? PROVIDED_INMEMORY_SUBSTITUTION_FILE_SIZE_IN_BYTES : 10240;
    }

    public static File setupDir(String prefix) throws IOException {
        String extractBase = System.getProperty("user.dir");
        File extractDir = null;
        File extractBaseFile = new File(extractBase);
        if (!extractBaseFile.mkdirs()) {
            _logger.log(Level.WARNING, "NCLS-SRVRMGMT-00011", extractBaseFile.getAbsolutePath());
        }
        if ((extractDir = File.createTempFile(prefix, null, extractBaseFile)).delete() && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, _strings.get("recreateDirectories", extractDir.getAbsolutePath()));
        }
        if (!extractDir.mkdirs()) {
            _logger.log(Level.WARNING, "NCLS-SRVRMGMT-00011", extractDir.getAbsolutePath());
        }
        return extractDir;
    }

    public static void removeDir(File file) {
        File[] files;
        if (file == null) {
            return;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                SubstitutionFileUtil.removeDir(f);
            }
        }
        if (!file.delete() && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, _strings.get("failureInFileDeletion", file.getAbsolutePath()));
        }
    }
}

