/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.SLogger;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class KeystoreManager {
    private static final String KEYTOOL_CMD;
    private static final String KEYTOOL_EXE_NAME;
    private static String CERTIFICATE_DN_PREFIX;
    private static String CERTIFICATE_DN_SUFFIX;
    public static final String CERTIFICATE_ALIAS = "s1as";
    public static final String INSTANCE_SECURE_ADMIN_ALIAS = "glassfish-instance";
    public static final String DEFAULT_MASTER_PASSWORD = "changeit";
    private static final String SKID_EXTENSION_SYSTEM_PROPERTY = "-J-Dsun.security.internal.keytool.skid";
    private static final String INSTANCE_CN_SUFFIX = "-instance";
    private static final StringManager _strMgr;
    protected PEFileLayout _fileLayout;

    protected static String getCertificateDN(RepositoryConfig cfg, String CNSuffix) {
        String cn = KeystoreManager.getCNFromCfg(cfg);
        if (cn == null) {
            try {
                cn = NetUtils.getCanonicalHostName();
            }
            catch (Exception e) {
                cn = "localhost";
            }
        }
        String x509DistinguishedName = CERTIFICATE_DN_PREFIX + cn + (CNSuffix != null ? CNSuffix : "") + CERTIFICATE_DN_SUFFIX;
        return x509DistinguishedName;
    }

    protected PEFileLayout getFileLayout(RepositoryConfig config) {
        if (this._fileLayout == null) {
            this._fileLayout = new PEFileLayout(config);
        }
        return this._fileLayout;
    }

    protected void createKeyStore(File keystore, RepositoryConfig config, String masterPassword) throws RepositoryException {
        String dasCertDN = KeystoreManager.getDASCertDN(config);
        System.out.println(_strMgr.getString("CertificateDN", dasCertDN));
        this.addSelfSignedCertToKeyStore(keystore, CERTIFICATE_ALIAS, masterPassword, dasCertDN);
        String instanceCertDN = KeystoreManager.getInstanceCertDN(config);
        System.out.println(_strMgr.getString("CertificateDN", instanceCertDN));
        this.addSelfSignedCertToKeyStore(keystore, INSTANCE_SECURE_ADMIN_ALIAS, masterPassword, instanceCertDN);
    }

    private void addSelfSignedCertToKeyStore(File keystore, String alias, String masterPassword, String dn) throws RepositoryException {
        String[] keytoolCmd = new String[]{"-genkey", "-keyalg", "RSA", "-keystore", keystore.getAbsolutePath(), "-alias", alias, "-dname", dn, "-validity", "3650", "-keypass", masterPassword, "-storepass", masterPassword, "-storetype", "JKS", SKID_EXTENSION_SYSTEM_PROPERTY};
        new KeytoolExecutor(keytoolCmd, 60).execute("keystoreNotCreated", keystore);
    }

    protected void copyCertificatesToTrustStore(File configRoot, DomainConfig config, String masterPassword) throws DomainException {
        try {
            this.copyCertificateFromKeyStoreToTrustStore(configRoot, CERTIFICATE_ALIAS, masterPassword);
            this.copyCertificateFromKeyStoreToTrustStore(configRoot, INSTANCE_SECURE_ADMIN_ALIAS, masterPassword);
        }
        catch (RepositoryException re) {
            throw new DomainException(_strMgr.getString("SomeProblemWithKeytool", re.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyCertificateFromKeyStoreToTrustStore(File configRoot, String alias, String masterPassword) throws RepositoryException {
        File keystore = new File(configRoot, "keystore.jks");
        File truststore = new File(configRoot, "cacerts.jks");
        File certFile = null;
        String[] input = new String[]{masterPassword};
        String[] keytoolCmd = null;
        KeytoolExecutor keytoolExecutor = null;
        try {
            certFile = new File(configRoot, alias + ".cer");
            keytoolCmd = new String[]{"-export", "-keystore", keystore.getAbsolutePath(), "-alias", alias, "-file", certFile.getAbsolutePath()};
            keytoolExecutor = new KeytoolExecutor(keytoolCmd, 30, input);
            keytoolExecutor.execute("trustStoreNotCreated", truststore);
            keytoolCmd = new String[]{"-import", "-noprompt", "-keystore", truststore.getAbsolutePath(), "-alias", alias, "-file", certFile.getAbsolutePath()};
            keytoolExecutor = new KeytoolExecutor(keytoolCmd, 30, input);
            keytoolExecutor.execute("trustStoreNotCreated", truststore);
        }
        finally {
            if (certFile != null && !certFile.delete()) {
                SLogger.getLogger().log(Level.WARNING, "NCLS-SRVRMGMT-00001", certFile.getAbsolutePath());
            }
        }
    }

    protected void changeKeystorePassword(String oldPassword, String newPassword, File keystore) throws RepositoryException {
        if (!oldPassword.equals(newPassword)) {
            String[] keytoolCmd = new String[]{"-storepasswd", "-keystore", keystore.getAbsolutePath()};
            KeytoolExecutor keytoolExecutor = new KeytoolExecutor(keytoolCmd, 30, new String[]{oldPassword, newPassword, newPassword});
            keytoolExecutor.execute("keyStorePasswordNotChanged", keystore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeS1ASAliasPassword(RepositoryConfig config, String storePassword, String oldKeyPassword, String newKeyPassword) throws RepositoryException {
        if (!storePassword.equals(oldKeyPassword) && !oldKeyPassword.equals(newKeyPassword)) {
            PEFileLayout layout = this.getFileLayout(config);
            File keystore = layout.getKeyStore();
            String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType");
            if (keyStoreType == null) {
                keyStoreType = KeyStore.getDefaultType();
            }
            ArrayList<String> aliases = new ArrayList<String>();
            FileInputStream is = null;
            try {
                KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                is = new FileInputStream(keystore);
                keyStore.load(is, storePassword.toCharArray());
                Enumeration<String> all = keyStore.aliases();
                while (all.hasMoreElements()) {
                    aliases.add(all.nextElement());
                }
            }
            catch (Exception e) {
                aliases.add(CERTIFICATE_ALIAS);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {
                        SLogger.getLogger().log(Level.SEVERE, "NCLS-SRVRMGMT-00000", ex);
                    }
                }
            }
            String[] keytoolCmd = new String[]{"-list", "-keystore", keystore.getAbsolutePath(), "-alias", CERTIFICATE_ALIAS};
            KeytoolExecutor keytoolExecutor = new KeytoolExecutor(keytoolCmd, 30, new String[]{storePassword});
            try {
                keytoolExecutor.execute("s1asKeyPasswordNotChanged", keystore);
            }
            catch (RepositoryException ex) {
                return;
            }
            for (String alias : aliases) {
                keytoolCmd = new String[]{"-keypasswd", "-keystore", keystore.getAbsolutePath(), "-alias", alias};
                keytoolExecutor = new KeytoolExecutor(keytoolCmd, 30, new String[]{storePassword, oldKeyPassword, newKeyPassword, newKeyPassword});
                keytoolExecutor.execute("s1asKeyPasswordNotChanged", keystore);
            }
        }
    }

    protected void changeSSLCertificateDatabasePassword(RepositoryConfig config, String oldPassword, String newPassword) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File keystore = layout.getKeyStore();
        File truststore = layout.getTrustStore();
        if (keystore.exists()) {
            this.changeKeystorePassword(oldPassword, newPassword, keystore);
            try {
                this.changeS1ASAliasPassword(config, newPassword, oldPassword, newPassword);
            }
            catch (Exception ex) {
                SLogger.getLogger().log(Level.SEVERE, "NCLS-SRVRMGMT-00000", ex);
            }
        }
        if (truststore.exists()) {
            this.changeKeystorePassword(oldPassword, newPassword, truststore);
        }
    }

    protected void chmod(String args, File file) throws IOException {
        if (OS.isUNIX()) {
            if (args == null || file == null) {
                throw new IOException(_strMgr.getString("nullArg"));
            }
            if (!file.exists()) {
                throw new IOException(_strMgr.getString("fileNotFound"));
            }
            String[] argsString = args.split(" +");
            ArrayList<String> cmdList = new ArrayList<String>();
            cmdList.add("/bin/chmod");
            cmdList.addAll(Arrays.asList(argsString));
            cmdList.add(file.getAbsolutePath());
            new ProcessBuilder(cmdList).start();
        }
    }

    public static String getDASCertDN(RepositoryConfig cfg) {
        return KeystoreManager.getCertificateDN(cfg, null);
    }

    public static String getInstanceCertDN(RepositoryConfig cfg) {
        return KeystoreManager.getCertificateDN(cfg, INSTANCE_CN_SUFFIX);
    }

    private static String getCNFromCfg(RepositoryConfig cfg) {
        String option = (String)cfg.get("keytooloptions");
        if (option == null || option.length() == 0) {
            return null;
        }
        String value = KeystoreManager.getCNFromOption(option);
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    private static String getValueFromOptionForName(String option, String name, boolean ignoreNameCase) {
        String[] pairs;
        Pattern p = Pattern.compile(":");
        for (String pair : pairs = p.split(option)) {
            boolean found;
            p = Pattern.compile("=");
            String[] nv = p.split(pair);
            String n = nv[0].trim();
            String v = nv[1].trim();
            boolean bl = found = ignoreNameCase ? n.equalsIgnoreCase(name) : n.equals(name);
            if (!found) continue;
            return v;
        }
        return null;
    }

    private static String getCNFromOption(String option) {
        return KeystoreManager.getValueFromOptionForName(option, "CN", true);
    }

    static {
        KEYTOOL_EXE_NAME = OS.isWindows() ? "keytool.exe" : "keytool";
        CERTIFICATE_DN_PREFIX = "CN=";
        CERTIFICATE_DN_SUFFIX = ",OU=GlassFish,O=Eclipse.org Foundation Inc,L=Ottawa,ST=Ontario,C=CA";
        _strMgr = StringManager.getManager(KeystoreManager.class);
        String nonFinalKeyTool = KEYTOOL_EXE_NAME;
        String propName = "com.sun.aas.javaRoot";
        String javaroot = new ASenvPropertyReader().getProps().get(propName);
        File keyToolBin = new File(new File(javaroot, "bin"), KEYTOOL_EXE_NAME);
        if (keyToolBin.canExecute()) {
            nonFinalKeyTool = SmartFile.sanitize(keyToolBin.getPath());
        } else {
            keyToolBin = ProcessUtils.getExe(KEYTOOL_EXE_NAME);
            if (keyToolBin != null && keyToolBin.canExecute()) {
                nonFinalKeyTool = keyToolBin.getPath();
            }
        }
        KEYTOOL_CMD = nonFinalKeyTool;
    }

    protected static class KeytoolExecutor
    extends ProcessManager {
        public KeytoolExecutor(String[] args, int timeoutInSeconds) {
            super(args);
            this.setTimeoutMsec(timeoutInSeconds * 1000);
            this.addKeytoolCommand();
        }

        public KeytoolExecutor(String[] args, int timeoutInSeconds, String[] inputLines) {
            super(args);
            this.setTimeoutMsec(timeoutInSeconds * 1000);
            this.setStdinLines(Arrays.asList(inputLines));
            this.addKeytoolCommand();
        }

        protected String getExceptionMessage() {
            return this.getStdout() + " " + this.getStderr();
        }

        private void addKeytoolCommand() {
            String[] mCmdStrings = this.builder.command().toArray(new String[0]);
            if (!mCmdStrings[0].equals(KEYTOOL_CMD)) {
                String[] newArgs = new String[mCmdStrings.length + 1];
                newArgs[0] = KEYTOOL_CMD;
                System.arraycopy(mCmdStrings, 0, newArgs, 1, mCmdStrings.length);
                mCmdStrings = newArgs;
                this.builder.command(Arrays.asList(mCmdStrings));
            }
        }

        public void execute(String keystoreErrorMsg, File keystoreName) throws RepositoryException {
            try {
                if (super.execute() != 0) {
                    throw new RepositoryException(_strMgr.getString(keystoreErrorMsg, keystoreName) + this.getStderr() + " " + this.getStdout());
                }
            }
            catch (ProcessManagerException ex) {
                throw new RepositoryException(_strMgr.getString(keystoreErrorMsg, keystoreName) + this.getStderr() + " " + this.getStdout(), ex);
            }
        }
    }
}

