/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.ArgumentManager;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.RespawnInfo;
import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.HostAndPort;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.api.admin.RuntimeType;

public class GFLauncherInfo {
    private static final String DEFAULT_DOMAIN_PARENT_DIR = "domains";
    private static final String CONFIG_DIR = "config";
    private static final String CONFIG_FILENAME = "domain.xml";
    private RuntimeType type;
    private List<String> argsRaw = new ArrayList<String>();
    private Map<String, String> argsMap;
    private boolean debug;
    private boolean suspend;
    private boolean verbose;
    private boolean watchdog;
    private boolean upgrade;
    private File domainParentDir;
    private File instanceRootDir;
    private File domainRootDir;
    private String domainName;
    private String instanceName;
    private File configDir;
    private File configFile;
    File installDir;
    private boolean valid;
    private boolean dropInterruptedCommands;
    private List<HostAndPort> adminAddresses;
    private RespawnInfo respawnInfo;
    final List<String> securityTokens = new ArrayList<String>();

    GFLauncherInfo(RuntimeType type2) {
        this.type = type2;
    }

    public void addArgs(String ... args) {
        for (String argument : args) {
            this.argsRaw.add(argument);
        }
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setDomainParentDir(String domainParentName) {
        this.domainParentDir = new File(domainParentName);
    }

    public void setVerbose(boolean b) {
        this.verbose = b;
    }

    public void setWatchdog(boolean b) {
        this.watchdog = b;
    }

    public void setDebug(boolean b) {
        this.debug = b;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setSuspend(boolean suspend) {
        this.suspend = suspend;
    }

    public boolean isSuspend() {
        return this.suspend;
    }

    public void setUpgrade(boolean b) {
        this.upgrade = b;
    }

    public void setDomainRootDir(File f) {
        this.domainRootDir = f;
    }

    public void setInstanceName(String name) {
        this.instanceName = name;
    }

    public void setInstanceRootDir(File f) {
        this.instanceRootDir = f;
    }

    public void setDropInterruptedCommands(boolean dropInterruptedCommands) {
        this.dropInterruptedCommands = dropInterruptedCommands;
    }

    public final boolean isDomain() {
        return this.type == RuntimeType.DAS;
    }

    public final boolean isInstance() {
        return this.type == RuntimeType.INSTANCE;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isWatchdog() {
        return this.watchdog;
    }

    public boolean isUpgrade() {
        return this.upgrade;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public File getDomainRootDir() {
        return this.domainRootDir;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public List<HostAndPort> getAdminAddresses() {
        return this.adminAddresses;
    }

    public RuntimeType getType() {
        return this.type;
    }

    public File getConfigDir() {
        return SmartFile.sanitize(this.configDir);
    }

    void setConfigDir(File f) {
        this.configDir = SmartFile.sanitize(f);
    }

    public File getInstanceRootDir() throws GFLauncherException {
        if (!this.valid) {
            throw new GFLauncherException("internalError", "Call to getInstanceRootDir() on an invalid GFLauncherInfo object.");
        }
        if (this.instanceRootDir != null) {
            return this.instanceRootDir;
        }
        if (this.isDomain()) {
            return this.domainRootDir;
        }
        throw new GFLauncherException("internalError", "Call to getInstanceRootDir() on an invalid GFLauncherInfo object.");
    }

    File getDomainParentDir() {
        return this.domainParentDir;
    }

    public boolean isDropInterruptedCommands() {
        return this.dropInterruptedCommands;
    }

    public String[] getArgsAsStringArray() throws GFLauncherException {
        List<String> list = this.getArgsAsList();
        String[] ss = new String[list.size()];
        return list.toArray(ss);
    }

    public List<String> getArgsAsList() throws GFLauncherException {
        ArrayList<String> argList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.getArgs().entrySet()) {
            argList.add(entry.getKey());
            argList.add(entry.getValue());
        }
        return argList;
    }

    public Map<String, String> getArgs() throws GFLauncherException {
        if (!this.valid) {
            throw new GFLauncherException("internalError", "Call to getArgs() on an invalid GFLauncherInfo object.");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("-type", this.type.toString());
        if (this.isDomain()) {
            map.put("-domaindir", SmartFile.sanitize(this.domainRootDir.getPath()));
            map.put("-domainname", this.domainName);
        } else if (this.isInstance()) {
            map.put("-instancedir", SmartFile.sanitize(this.instanceRootDir.getPath()));
        }
        map.put("-verbose", Boolean.toString(this.verbose));
        map.put("-debug", Boolean.toString(this.debug));
        map.put("-instancename", this.instanceName);
        map.put("-upgrade", Boolean.toString(this.upgrade));
        map.put("-read-stdin", "true");
        if (this.respawnInfo != null) {
            this.respawnInfo.put(map);
        }
        return map;
    }

    public void setRespawnInfo(String classname, String classpath, String[] args) {
        this.respawnInfo = new RespawnInfo(classname, classpath, args);
    }

    public void addSecurityToken(String name, String value) {
        if (name == null || value == null) {
            throw new NullPointerException();
        }
        this.securityTokens.add(name + "=" + value);
    }

    void setAdminAddresses(List<HostAndPort> adminAddresses) {
        this.adminAddresses = adminAddresses;
    }

    void setInstallDir(File f) {
        this.installDir = f;
    }

    File getInstallDir() {
        return this.installDir;
    }

    void setup() throws GFLauncherException {
        this.setupFromArgs();
        this.finalSetup();
    }

    private void setupFromArgs() {
        this.argsMap = ArgumentManager.argsToMap(this.argsRaw);
        File fileArgument = null;
        String stringArgument = null;
        fileArgument = this.getFile("domaindir");
        if (fileArgument != null) {
            this.domainParentDir = fileArgument;
        }
        if ((fileArgument = this.getFile("instanceRootDir")) != null) {
            this.instanceRootDir = fileArgument;
        }
        if ((fileArgument = this.getFile("domainroot")) != null) {
            this.domainRootDir = fileArgument;
        }
        if ((stringArgument = this.getString("domain")) != null) {
            this.domainName = stringArgument;
        }
        if (!GFLauncherUtils.ok(this.domainName) && (stringArgument = this.getString("default")) != null) {
            this.domainName = stringArgument;
        }
        if ((stringArgument = this.getString("instancename")) != null) {
            this.instanceName = stringArgument;
        }
        this.debug = this.getBoolean("debug", this.debug);
        this.verbose = this.getBoolean("verbose", this.verbose);
        this.watchdog = this.getBoolean("watchdog", this.watchdog);
        this.upgrade = this.getBoolean("upgrade", this.upgrade);
    }

    private void finalSetup() throws GFLauncherException {
        if (this.installDir == null) {
            this.installDir = GFLauncherUtils.getInstallDir();
        }
        if (!GFLauncherUtils.safeIsDirectory(this.installDir)) {
            throw new GFLauncherException("noInstallDir", this.installDir);
        }
        if (this.domainParentDir != null && !GFLauncherUtils.safeIsDirectory(this.domainParentDir)) {
            throw new GFLauncherException("noDomainParentDir", this.domainParentDir);
        }
        this.setupServerDirs();
        if (!GFLauncherUtils.safeIsDirectory(this.configDir)) {
            throw new GFLauncherException("noConfigDir", this.configDir);
        }
        this.configFile = new File(this.configDir, CONFIG_FILENAME);
        if (!GFLauncherUtils.safeExists(this.configFile)) {
            throw new GFLauncherException("noConfigFile", this.configFile);
        }
        if (this.instanceName == null) {
            this.instanceName = "server";
        }
        this.valid = true;
    }

    private void setupServerDirs() throws GFLauncherException {
        if (this.isDomain()) {
            this.setupDomainDirs();
        } else if (this.isInstance()) {
            this.setupInstanceDirs();
        }
    }

    private void setupDomainDirs() throws GFLauncherException {
        if (this.domainRootDir != null) {
            this.domainParentDir = this.domainRootDir.getParentFile();
            this.domainName = this.domainRootDir.getName();
            return;
        }
        if (this.domainParentDir == null) {
            this.domainParentDir = new File(this.installDir, DEFAULT_DOMAIN_PARENT_DIR);
        }
        if (this.domainName == null) {
            this.domainName = this.getTheOneAndOnlyDomain();
        }
        this.domainRootDir = new File(this.domainParentDir, this.domainName);
        if (!GFLauncherUtils.safeIsDirectory(this.domainRootDir)) {
            throw new GFLauncherException("noDomainRootDir", this.domainRootDir);
        }
        this.configDir = new File(this.domainRootDir, CONFIG_DIR);
    }

    private void setupInstanceDirs() throws GFLauncherException {
        if (this.instanceRootDir == null) {
            throw new GFLauncherException("Missing instanceRootDir");
        }
        if (this.instanceName == null) {
            throw new GFLauncherException("Missing instanceName");
        }
        this.configDir = new File(this.instanceRootDir, CONFIG_DIR);
    }

    private String getTheOneAndOnlyDomain() throws GFLauncherException {
        File[] files = this.domainParentDir.listFiles(f -> GFLauncherUtils.safeIsDirectory(f));
        if (files == null || files.length == 0) {
            throw new GFLauncherException("noDomainDirs", this.domainParentDir);
        }
        if (files.length > 1) {
            throw new GFLauncherException("tooManyDomainDirs", this.domainParentDir);
        }
        return files[0].getName();
    }

    private File getFile(String key) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        return new File(value);
    }

    private boolean getBoolean(String key, boolean def) {
        ThreeStateBoolean booleanArgument = this.getBoolean(key);
        if (booleanArgument.isTrue()) {
            return true;
        }
        if (booleanArgument.isFalse()) {
            return false;
        }
        return def;
    }

    private ThreeStateBoolean getBoolean(String key) {
        String value = this.getValueIgnoreCommandDelimiter(key);
        if (value != null) {
            return new ThreeStateBoolean(Boolean.valueOf(value));
        }
        return new ThreeStateBoolean(null);
    }

    private String getString(String key) {
        return this.getValueIgnoreCommandDelimiter(key);
    }

    private String getValueIgnoreCommandDelimiter(String key) {
        if (this.argsMap.containsKey(key)) {
            return this.argsMap.get(key);
        }
        if (this.argsMap.containsKey(key = "-" + (String)key)) {
            return this.argsMap.get(key);
        }
        if (this.argsMap.containsKey(key = "-" + (String)key)) {
            return this.argsMap.get(key);
        }
        return null;
    }

    boolean isVerboseOrWatchdog() {
        return this.verbose || this.watchdog;
    }

    private static final class ThreeStateBoolean {
        final Boolean b;

        ThreeStateBoolean(Boolean b) {
            this.b = b;
        }

        boolean isNull() {
            return this.b == null;
        }

        boolean isTrue() {
            return !this.isNull() && this.b != false;
        }

        boolean isFalse() {
            return !this.isNull() && this.b == false;
        }
    }
}

