/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.util.Utility;
import java.io.File;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Scanner;

public class DerbyExecuteSQL {
    private final String derbyHost;
    private final String derbyPort;
    private final String derbyName;
    private final String sqlFileName;
    private final String derbyUser;
    private final String derbyPassword;

    public static void main(String[] args) {
        DerbyExecuteSQL sql = new DerbyExecuteSQL(args[0], args[1], args[2], args[3], args.length < 5 ? null : args[4], args.length < 6 ? null : args[5]);
        sql.executeCommand();
    }

    public DerbyExecuteSQL(String derbyHost, String derbyPort, String derbyName, String sqlFileName, String derbyUser, String derbyPassword) {
        this.derbyHost = derbyHost;
        this.derbyPort = derbyPort;
        this.derbyName = derbyName;
        this.sqlFileName = sqlFileName;
        this.derbyUser = derbyUser;
        this.derbyPassword = derbyPassword;
    }

    private void executeCommand() {
        try {
            Driver driver = (Driver)Class.forName("org.apache.derby.jdbc.ClientDriver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Properties properties = new Properties();
            if (!Utility.isAllEmpty(this.derbyUser, this.derbyPassword)) {
                properties.put("user", this.derbyUser);
                properties.put("password", this.derbyPassword);
            }
            try (Connection connection = driver.connect("jdbc:derby://" + this.derbyHost + ":" + this.derbyPort + "/" + this.derbyName, properties);
                 Scanner scanner = new Scanner(new File(this.sqlFileName), "UTF-8");){
                scanner.useDelimiter(";");
                while (scanner.hasNext()) {
                    String statement = null;
                    try {
                        statement = scanner.next().strip();
                        if (statement.isEmpty()) continue;
                        connection.prepareStatement(statement).execute();
                    }
                    catch (SQLException s) {
                        System.out.println("Exeception executing: " + statement);
                        s.printStackTrace();
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

