/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.ClassPathBuilder;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.OS;
import java.io.File;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;

public abstract class DatabaseCommand
extends CLICommand {
    private static final LocalStringsImpl strings = new LocalStringsImpl(DatabaseCommand.class);
    protected static final String DB_HOST_DEFAULT = "0.0.0.0";
    protected static final String DB_PORT_DEFAULT = "1527";
    protected static final String DB_USER = "dbuser";
    protected static final String DB_PASSWORDFILE = "dbpasswordfile";
    @Param(name="dbhost", optional=true, defaultValue="0.0.0.0")
    protected String dbHost;
    @Param(name="dbport", optional=true, defaultValue="1527")
    protected String dbPort;
    protected final ClassPathBuilder sClasspath = new ClassPathBuilder();
    protected final ClassPathBuilder sDatabaseClasspath = new ClassPathBuilder();
    protected File dbLocation;
    protected File javaHome;
    protected File installRoot;

    protected void prepareProcessExecutor() throws Exception {
        this.installRoot = new File(this.getSystemProperty("com.sun.aas.installRoot"));
        if (this.dbHost == null) {
            this.dbHost = DB_HOST_DEFAULT;
        }
        if (this.dbPort == null) {
            this.dbPort = DB_PORT_DEFAULT;
        } else {
            this.checkIfPortIsValid(this.dbPort);
        }
        this.javaHome = new File(this.getSystemProperty("com.sun.aas.javaRoot"));
        this.dbLocation = new File(this.getSystemProperty("com.sun.aas.derbyRoot"));
        this.checkIfDbInstalled(this.dbLocation);
        this.sClasspath.add(new File(this.installRoot, "lib/asadmin/cli-optional.jar"));
        this.sDatabaseClasspath.add(this.dbLocation, "lib", "derby.jar").add(this.dbLocation, "lib", "derbyshared.jar").add(this.dbLocation, "lib", "derbytools.jar").add(this.dbLocation, "lib", "derbynet.jar").add(this.dbLocation, "lib", "derbyclient.jar");
    }

    private void checkIfPortIsValid(String port) throws CommandValidationException {
        try {
            Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            throw new CommandValidationException(strings.get("InvalidPortNumber", port));
        }
    }

    private void checkIfDbInstalled(File dblocation) throws CommandException {
        if (!dblocation.exists()) {
            logger.info(strings.get("DatabaseNotInstalled", dblocation));
            throw new CommandException("dblocation not found: " + String.valueOf(dblocation));
        }
        File derbyJar = new File(new File(this.dbLocation, "lib"), "derbyclient.jar");
        if (!derbyJar.exists()) {
            logger.info(strings.get("DatabaseNotInstalled", dblocation));
            throw new CommandException("derbyclient.jar not found in " + String.valueOf(dblocation));
        }
    }

    protected String[] pingDatabaseCmd(boolean bRedirect) throws Exception {
        if (OS.isDarwin()) {
            return new String[]{this.getJavaExe().toString(), "-Djava.library.path=" + String.valueOf(this.installRoot) + File.separator + "lib", "-Dderby.storage.fileSyncTransactionLog=True", "-cp", String.valueOf(this.sClasspath) + File.pathSeparator + String.valueOf(this.sDatabaseClasspath), "com.sun.enterprise.admin.cli.optional.DerbyControl", "ping", this.dbHost, this.dbPort, Boolean.valueOf(bRedirect).toString()};
        }
        return new String[]{this.getJavaExe().toString(), "-Djava.library.path=" + String.valueOf(this.installRoot) + File.separator + "lib", "-cp", String.valueOf(this.sClasspath) + File.pathSeparator + String.valueOf(this.sDatabaseClasspath), "com.sun.enterprise.admin.cli.optional.DerbyControl", "ping", this.dbHost, this.dbPort, Boolean.valueOf(bRedirect).toString()};
    }

    protected final File getJavaExe() {
        return new File(new File(this.javaHome, "bin"), "java");
    }
}

