/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.glassfish.common.util.GlassfishUrlClassLoader;

public class DirectoryClassLoader
extends GlassfishUrlClassLoader {
    private static final LocalStringsImpl STRINGS = new LocalStringsImpl(DirectoryClassLoader.class);
    private static final int MAX_DEPTH = 5;
    private static final Comparator<Path> FILENAME_COMPARATOR = Comparator.comparing(Path::getFileName);
    private static final Function<Path, URL> MAPPER = p -> {
        try {
            return p.toUri().toURL();
        }
        catch (Exception e) {
            throw new IllegalStateException(STRINGS.get("DirError", p));
        }
    };

    public DirectoryClassLoader(Set<File> jarsAndDirs, ClassLoader parent) {
        super(DirectoryClassLoader.getJars(jarsAndDirs), parent);
    }

    public DirectoryClassLoader(File dir, ClassLoader parent) {
        super(DirectoryClassLoader.getJars(dir), parent);
    }

    private static URL[] getJars(Set<File> jarsAndDirs) {
        return DirectoryClassLoader.getJars(jarsAndDirs.toArray(new File[jarsAndDirs.size()]));
    }

    private static URL[] getJars(File ... jarsAndDirs) {
        return (URL[])Arrays.stream(jarsAndDirs).map(DirectoryClassLoader::getJarPaths).flatMap(Collection::stream).sorted(FILENAME_COMPARATOR).map(MAPPER).toArray(URL[]::new);
    }

    private static Set<Path> getJarPaths(File dir) {
        Set<Path> set;
        block8: {
            Stream<Path> stream = Files.walk(dir.toPath(), 5, new FileVisitOption[0]);
            try {
                set = stream.filter(path -> !Files.isDirectory(path, new LinkOption[0])).filter(path -> path.getFileName().toString().endsWith(".jar")).collect(Collectors.toSet());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(STRINGS.get("DirError", dir), e);
                }
            }
            stream.close();
        }
        return set;
    }
}

