/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.Container;
import com.sun.ejb.ContainerFactory;
import com.sun.ejb.base.container.util.CacheProperties;
import com.sun.ejb.base.sfsb.util.ScrambledKeyGenerator;
import com.sun.ejb.base.sfsb.util.SimpleKeyGenerator;
import com.sun.ejb.containers.BaseContainerFactory;
import com.sun.ejb.containers.CachePassivatorTask;
import com.sun.ejb.containers.ExpiredSessionsRemovalTask;
import com.sun.ejb.containers.StatefulSessionContainer;
import com.sun.ejb.containers.util.cache.FIFOSessionCache;
import com.sun.ejb.containers.util.cache.LruSessionCache;
import com.sun.ejb.containers.util.cache.NRUSessionCache;
import com.sun.ejb.containers.util.cache.UnBoundedSessionCache;
import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.security.SecurityManager;
import com.sun.enterprise.util.Utility;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.ejb.LogFacade;
import org.glassfish.ejb.config.EjbContainer;
import org.glassfish.ejb.config.EjbContainerAvailability;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;
import org.glassfish.gms.bootstrap.GMSAdapter;
import org.glassfish.gms.bootstrap.GMSAdapterService;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;
import org.glassfish.ha.store.util.SimpleMetadata;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service(name="StatefulContainerFactory")
@PerLookup
public class StatefulContainerFactory
extends BaseContainerFactory
implements PostConstruct,
ContainerFactory {
    protected static final Logger _logger = LogFacade.getLogger();
    @LogMessageInfo(message="TopLevel AvailabilityService.getAvailabilityEnabled: [{0}]", level="FINE")
    private static final String SFSB_BUILDER_TOP_LEVEL_AVAILABILITY_SERVICE_ENABLED = "AS-EJB-00036";
    @LogMessageInfo(message="TopLevel EjbAvailabilityService.getAvailabilityEnabled: [{0}]", level="FINE")
    private static final String SFSB_BUILDER_EJB_AVAILABILITY_SERVICE_ENABLED = "AS-EJB-00037";
    @LogMessageInfo(message="Global AvailabilityEnabled: [{0}], application AvailabilityEnabled: [{1}]", level="FINE")
    private static final String SFSB_BUILDER_GLOBAL_AND_APP_AVAILABILITY_ENABLED = "AS-EJB-00038";
    @LogMessageInfo(message="Exception while trying to determine availability-enabled settings for this app", level="WARNING")
    private static final String SFSB_BUILDER_DETERMINE_AVAILABILITY_EXCEPTION = "AS-EJB-00039";
    @LogMessageInfo(message="StatefulContainerBuilder AvailabilityEnabled [{0}] for this application", level="FINE")
    private static final String SFSB_BUILDER_RESOLVED_AVAILABILITY_ENABLED = "AS-EJB-00040";
    @LogMessageInfo(message="StatefulContainerBuilder.buildStoreManager() storeName: [{0}]", level="FINE")
    private static final String SFSB_BUILDER_STORE_NAME = "AS-EJB-00041";
    @LogMessageInfo(message="Could not instantiate backing store for type [{0}]", level="WARNING")
    private static final String SFSB_BUILDER_INSTANTIATE_BACKING_STORE_EXCEPTION = "AS-EJB-00042";
    @LogMessageInfo(message="StatefulContainerbuilder instantiated store: {0}, with ha-enabled [{1}], and backing store configuration: {2}", level="INFO")
    private static final String SFSB_BUILDER_INSTANTIATED_BACKING_STORE = "AS-EJB-00043";
    @LogMessageInfo(message="Error while adding idle bean passivator task", level="WARNING")
    private static final String SFSB_HELPER_ADD_IDLE_PASSIVATOR_TASK_FAILED = "AS-EJB-00044";
    @LogMessageInfo(message="Error while adding idle bean removal task", level="WARNING")
    private static final String SFSB_HELPER_ADD_REMOVE_PASSIVATOR_TASK_FAILED = "AS-EJB-00045";
    @LogMessageInfo(message="Error while removing idle beans for [{0}]", level="WARNING")
    static final String SFSB_HELPER_REMOVE_IDLE_BEANS_FAILED = "AS-EJB-00046";
    @LogMessageInfo(message="Error while removing expired beans for [{0}]", level="WARNING")
    static final String SFSB_HELPER_REMOVE_EXPIRED_BEANS_FAILED = "AS-EJB-00047";
    @LogMessageInfo(message="Disabling high availability for the stateful session bean {0}, as its marked non passivatable", level="WARNING")
    private static final String SFSB_HA_DISABLED_BY_PASSIVATION_SETTING = "AS-EJB-00051";
    private static final Level TRACE_LEVEL = Level.FINE;
    private EjbDescriptor ejbDescriptor;
    private StatefulSessionContainer sfsbContainer;
    @Inject
    private ServiceLocator services;
    @Inject
    private CacheProperties cacheProps;
    @Inject
    @Named(value="default-instance-name")
    @Optional
    private AvailabilityService availabilityService;
    @Inject
    @Optional
    private EjbContainerAvailability ejbAvailability;
    @Inject
    @Named(value="default-instance-name")
    private Config serverConfig;
    EjbContainer ejbContainerConfig;
    @Inject
    @Optional
    GMSAdapterService gmsAdapterService;
    private LruSessionCache sessionCache;
    private BackingStore<Serializable, SimpleMetadata> backingStore;
    private boolean HAEnabled = false;
    private boolean asyncReplication = true;
    private SimpleKeyGenerator keyGen;

    @Override
    public void postConstruct() {
        this.ejbContainerConfig = this.serverConfig.getExtensionByType(EjbContainer.class);
    }

    public void buildComponents(byte[] ipAddress, int port, DeploymentContext dc) throws Exception {
        EjbSessionDescriptor sessionDescriptor;
        if (this.availabilityService != null) {
            this.HAEnabled = Boolean.valueOf(this.availabilityService.getAvailabilityEnabled());
            _logger.log(Level.FINE, SFSB_BUILDER_TOP_LEVEL_AVAILABILITY_SERVICE_ENABLED, this.HAEnabled);
            if (this.HAEnabled && this.ejbAvailability != null) {
                this.HAEnabled = Boolean.valueOf(this.ejbAvailability.getAvailabilityEnabled());
                _logger.log(Level.FINE, SFSB_BUILDER_EJB_AVAILABILITY_SERVICE_ENABLED, this.HAEnabled);
            }
            boolean appLevelHAEnabled = false;
            try {
                if (this.HAEnabled) {
                    DeployCommandParameters params;
                    if (dc != null && (params = dc.getCommandParameters(DeployCommandParameters.class)) != null) {
                        appLevelHAEnabled = params.availabilityenabled;
                        this.asyncReplication = params.asyncreplication;
                    }
                    _logger.log(Level.FINE, SFSB_BUILDER_GLOBAL_AND_APP_AVAILABILITY_ENABLED, new Object[]{this.HAEnabled, appLevelHAEnabled});
                }
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, SFSB_BUILDER_DETERMINE_AVAILABILITY_EXCEPTION, ex);
                appLevelHAEnabled = false;
            }
            this.HAEnabled = this.HAEnabled && appLevelHAEnabled;
            _logger.log(Level.FINE, SFSB_BUILDER_RESOLVED_AVAILABILITY_ENABLED, this.HAEnabled);
        }
        if (!(sessionDescriptor = (EjbSessionDescriptor)this.ejbDescriptor).isPassivationCapable() && this.HAEnabled) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, SFSB_HA_DISABLED_BY_PASSIVATION_SETTING, this.ejbDescriptor.getEjbClassName());
            }
            this.HAEnabled = false;
        }
        this.buildCheckpointPolicy(this.HAEnabled);
        this.buildSFSBUUIDUtil(ipAddress, port);
        if (sessionDescriptor.isPassivationCapable()) {
            this.buildStoreManager();
        } else if (_logger.isLoggable(TRACE_LEVEL)) {
            _logger.log(TRACE_LEVEL, "Stateful session bean passivation is disabled, so do not create store manger");
        }
        this.buildCache();
        this.scheduleTimerTasks(this.sfsbContainer);
    }

    private final void buildCheckpointPolicy(boolean haEnabled) {
        this.sfsbContainer.setHAEnabled(haEnabled);
    }

    private void buildSFSBUUIDUtil(byte[] ipAddress, int port) {
        this.keyGen = this.HAEnabled ? new ScrambledKeyGenerator(ipAddress, port) : new SimpleKeyGenerator(ipAddress, port);
        this.sfsbContainer.setSFSBUUIDUtil(this.keyGen);
    }

    private void buildStoreManager() throws BackingStoreException {
        GMSAdapter gmsAdapter;
        String persistenceStoreType = "file";
        if (this.ejbAvailability != null) {
            String string = persistenceStoreType = this.HAEnabled ? this.ejbAvailability.getSfsbHaPersistenceType() : this.ejbAvailability.getSfsbPersistenceType();
            if ("ha".equals(persistenceStoreType)) {
                persistenceStoreType = "replicated";
            } else if ("memory".equals(persistenceStoreType)) {
                persistenceStoreType = "file";
            }
        }
        BackingStoreConfiguration conf = new BackingStoreConfiguration();
        String storeName = this.ejbDescriptor.getName() + "-" + this.ejbDescriptor.getUniqueId() + "-BackingStore";
        _logger.log(Level.FINE, SFSB_BUILDER_STORE_NAME, storeName);
        Object subDirName = "";
        subDirName = (String)subDirName + this.ejbDescriptor.getName() + "-" + this.ejbDescriptor.getUniqueId();
        conf.setShortUniqueName("" + this.ejbDescriptor.getUniqueId()).setStoreName(storeName).setStoreType(persistenceStoreType).setBaseDirectory(new File(this.ejbContainerConfig.getSessionStore(), (String)subDirName)).setKeyClazz(Serializable.class).setValueClazz(SimpleMetadata.class).setClassLoader(StatefulContainerFactory.class.getClassLoader());
        Map<String, Object> vendorMap = conf.getVendorSpecificSettings();
        vendorMap.put("local.caching", true);
        vendorMap.put("start.gms", false);
        vendorMap.put("async.replication", this.asyncReplication);
        vendorMap.put("broadcast.remove.expired", false);
        vendorMap.put("value.class.is.thread.safe", true);
        vendorMap.put("key.transformer", this.keyGen);
        if (this.gmsAdapterService != null && (gmsAdapter = this.gmsAdapterService.getGMSAdapter()) != null) {
            conf.setClusterName(gmsAdapter.getClusterName());
            conf.setInstanceName(gmsAdapter.getModule().getInstanceName());
        }
        BackingStoreFactory factory = null;
        try {
            factory = this.services.getService(BackingStoreFactory.class, persistenceStoreType, new Annotation[0]);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, SFSB_BUILDER_INSTANTIATE_BACKING_STORE_EXCEPTION, new Object[]{persistenceStoreType, ex});
        }
        try {
            if (factory == null) {
                factory = this.services.getService(BackingStoreFactory.class, "noop", new Annotation[0]);
            }
            this.backingStore = factory.createBackingStore(conf);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, SFSB_BUILDER_INSTANTIATE_BACKING_STORE_EXCEPTION, new Object[]{persistenceStoreType, ex});
            throw new BackingStoreException("Could not instantiate backing store for type [" + persistenceStoreType + "]", ex);
        }
        _logger.log(Level.INFO, SFSB_BUILDER_INSTANTIATED_BACKING_STORE, new Object[]{this.backingStore, this.HAEnabled, conf});
    }

    private void buildCache() {
        String cacheName = this.ejbDescriptor.getEjbClassName();
        String victimPolicy = this.cacheProps.getVictimSelectionPolicy();
        this.sessionCache = this.cacheProps.getMaxCacheSize() <= 0 ? new UnBoundedSessionCache(cacheName, this.sfsbContainer, this.cacheProps.getCacheIdleTimeoutInSeconds(), this.cacheProps.getRemovalTimeoutInSeconds()) : ("lru".equalsIgnoreCase(victimPolicy) ? new LruSessionCache(cacheName, this.sfsbContainer, this.cacheProps.getCacheIdleTimeoutInSeconds(), this.cacheProps.getRemovalTimeoutInSeconds()) : ("fifo".equalsIgnoreCase(victimPolicy) ? new FIFOSessionCache(cacheName, this.sfsbContainer, this.cacheProps.getCacheIdleTimeoutInSeconds(), this.cacheProps.getRemovalTimeoutInSeconds()) : new NRUSessionCache(cacheName, this.sfsbContainer, this.cacheProps.getCacheIdleTimeoutInSeconds(), this.cacheProps.getRemovalTimeoutInSeconds())));
        float ratio = (float)(1.0 * (double)this.cacheProps.getNumberOfVictimsToSelect() / (double)this.cacheProps.getMaxCacheSize());
        float loadFactor = (float)(1.0 - (double)ratio);
        if (loadFactor < 0.0f || loadFactor > 1.0f) {
            loadFactor = 0.75f;
        }
        if (this.cacheProps.getMaxCacheSize() <= 0) {
            this.sessionCache.init(16384, loadFactor, null);
        } else {
            this.sessionCache.init(this.cacheProps.getMaxCacheSize(), loadFactor, null);
        }
        this.sessionCache.addCacheListener(this.sfsbContainer);
        this.sfsbContainer.setSessionCache(this.sessionCache);
        this.sessionCache.setBackingStore(this.backingStore);
        this.sfsbContainer.setBackingStore(this.backingStore);
        if (this.cacheProps.getNumberOfVictimsToSelect() > 8) {
            this.sfsbContainer.setPassivationBatchCount(this.cacheProps.getNumberOfVictimsToSelect());
        }
        if (_logger.isLoggable(TRACE_LEVEL)) {
            _logger.log(TRACE_LEVEL, "Created cache for {0}; cache properties: {1}; loadFactor: {2}; backingStore: {3}", new Object[]{this.ejbDescriptor.getName(), this.cacheProps, Float.valueOf(loadFactor), this.backingStore});
        }
    }

    private void scheduleTimerTasks(StatefulSessionContainer container) {
        long timeout;
        String ejbName = this.ejbDescriptor.getEjbClassName();
        if (this.cacheProps.getCacheIdleTimeoutInSeconds() > 0) {
            timeout = (long)this.cacheProps.getCacheIdleTimeoutInSeconds() * 1000L;
            try {
                this.sfsbContainer.invokePeriodically(timeout, timeout, new CachePassivatorTask(ejbName, this.sessionCache, _logger));
                if (_logger.isLoggable(TRACE_LEVEL)) {
                    _logger.log(TRACE_LEVEL, "Added CachePassivator for {0} to run after {1} milliseconds", new Object[]{ejbName, timeout});
                }
            }
            catch (Throwable th) {
                _logger.log(Level.WARNING, SFSB_HELPER_ADD_IDLE_PASSIVATOR_TASK_FAILED, th);
            }
        }
        if (this.cacheProps.getRemovalTimeoutInSeconds() > 0 && container.isPassivationCapable()) {
            timeout = (long)this.cacheProps.getRemovalTimeoutInSeconds() * 1000L;
            try {
                this.sfsbContainer.invokePeriodically(timeout, timeout, new ExpiredSessionsRemovalTask(ejbName, this.sfsbContainer, _logger));
                if (_logger.isLoggable(TRACE_LEVEL)) {
                    _logger.log(TRACE_LEVEL, "Added StorePassivator for {0} to run after {1} milliseconds", new Object[]{ejbName, timeout});
                }
            }
            catch (Throwable th) {
                _logger.log(Level.WARNING, SFSB_HELPER_ADD_REMOVE_PASSIVATOR_TASK_FAILED, th);
            }
        }
    }

    @Override
    public Container createContainer(EjbDescriptor ejbDescriptor, ClassLoader loader, DeploymentContext deployContext) throws Exception {
        this.ejbDescriptor = ejbDescriptor;
        byte[] ipAddress = new byte[4];
        try {
            ipAddress = InetAddress.getLocalHost().getAddress();
        }
        catch (Exception ex) {
            long val = (long)System.identityHashCode(ipAddress) + System.currentTimeMillis();
            Utility.longToBytes(val, ipAddress, 0);
        }
        int port = 8080;
        this.cacheProps.init(ejbDescriptor);
        SecurityManager sm = this.getSecurityManager(ejbDescriptor);
        this.sfsbContainer = new StatefulSessionContainer(ejbDescriptor, loader, sm);
        this.buildComponents(ipAddress, port, deployContext);
        this.sfsbContainer.initializeHome();
        return this.sfsbContainer;
    }
}

