/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.Container;
import com.sun.ejb.EjbInvocation;
import com.sun.ejb.containers.EjbAsyncTask;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.EjbFutureTask;
import com.sun.ejb.containers.EjbRemoteFutureTask;
import com.sun.ejb.containers.GenericEJBHome;
import com.sun.ejb.containers.RemoteAsyncResult;
import com.sun.logging.LogDomains;
import jakarta.ejb.EJBException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Service;

@Service
public class EjbAsyncInvocationManager {
    private static final Logger _logger = LogDomains.getLogger(EjbAsyncInvocationManager.class, "jakarta.enterprise.system.container.ejb");
    private AtomicLong invCounter = new AtomicLong();
    private ConcurrentHashMap<Long, EjbFutureTask> remoteTaskMap = new ConcurrentHashMap();

    public Future createLocalFuture(EjbInvocation inv) {
        return this.createFuture(inv);
    }

    public Future createRemoteFuture(EjbInvocation inv, Container container, GenericEJBHome ejbHome) {
        EjbFutureTask localFutureTask = (EjbFutureTask)this.createFuture(inv);
        EjbRemoteFutureTask returnFuture = new EjbRemoteFutureTask(inv.getInvId(), ejbHome);
        Method m = inv.getMethod();
        if (!m.getReturnType().equals(Void.TYPE)) {
            this.remoteTaskMap.put(inv.getInvId(), localFutureTask);
        }
        return returnFuture;
    }

    private Future createFuture(EjbInvocation inv) {
        EjbFutureTask futureTask = new EjbFutureTask(new EjbAsyncTask(), this);
        long invId = this.invCounter.incrementAndGet();
        inv.setInvId(invId);
        inv.setEjbFutureTask(futureTask);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Creating new async future task " + String.valueOf(inv));
        }
        return futureTask;
    }

    public Future submit(EjbInvocation inv) {
        EjbInvocation asyncInv = inv.clone();
        asyncInv.setTransactionOperationsManager(asyncInv);
        inv.clearYetToSubmitStatus();
        asyncInv.clearYetToSubmitStatus();
        EjbFutureTask futureTask = asyncInv.getEjbFutureTask();
        futureTask.getEjbAsyncTask().initialize(asyncInv);
        EjbContainerUtil ejbContainerUtil = EjbContainerUtilImpl.getInstance();
        return ejbContainerUtil.getThreadPoolExecutor(null).submit(futureTask.getEjbAsyncTask());
    }

    public void cleanupContainerTasks(Container container) {
        Set<Map.Entry<Long, EjbFutureTask>> entrySet = this.remoteTaskMap.entrySet();
        Iterator<Map.Entry<Long, EjbFutureTask>> iterator = entrySet.iterator();
        ArrayList<Long> removedTasks = new ArrayList<Long>();
        while (iterator.hasNext()) {
            Map.Entry<Long, EjbFutureTask> next = iterator.next();
            EjbAsyncTask task = next.getValue().getEjbAsyncTask();
            if (task.getEjbInvocation().container != container) continue;
            removedTasks.add(task.getInvId());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Cleaning up async task " + String.valueOf(task.getFutureTask()));
            }
            iterator.remove();
        }
        _logger.log(Level.FINE, "Cleaning up " + removedTasks.size() + "async tasks for EJB " + container.getEjbDescriptor().getName() + " .  Total of " + this.remoteTaskMap.size() + " remaining");
    }

    RemoteAsyncResult remoteCancel(Long asyncTaskID) {
        EjbFutureTask task = this.getLocalTaskForID(asyncTaskID);
        if (_logger.isLoggable(Level.FINE)) {
            EjbAsyncTask asyncTask = task.getEjbAsyncTask();
            _logger.log(Level.FINE, "Enter remoteCancel for async task " + asyncTaskID + " : " + String.valueOf(asyncTask.getEjbInvocation()));
        }
        RemoteAsyncResult result = null;
        if (task.isDone()) {
            result = new RemoteAsyncResult();
            result.resultException = task.getResultException();
            result.resultValue = task.getResultValue();
            result.asyncID = asyncTaskID;
            this.remoteTaskMap.remove(asyncTaskID);
        } else {
            EjbInvocation inv = task.getEjbAsyncTask().getEjbInvocation();
            inv.setWasCancelCalled(true);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Exit remoteCancel for async task " + asyncTaskID + " : " + String.valueOf(task));
        }
        return result;
    }

    RemoteAsyncResult remoteIsDone(Long asyncTaskID) {
        EjbFutureTask task = this.getLocalTaskForID(asyncTaskID);
        if (_logger.isLoggable(Level.FINE)) {
            EjbAsyncTask asyncTask = task.getEjbAsyncTask();
            _logger.log(Level.FINE, "Enter remoteisDone for async task " + asyncTaskID + " : " + String.valueOf(asyncTask.getEjbInvocation()));
        }
        RemoteAsyncResult result = null;
        if (task.isDone()) {
            result = new RemoteAsyncResult();
            result.resultException = task.getResultException();
            result.resultValue = task.getResultValue();
            result.asyncID = asyncTaskID;
            this.remoteTaskMap.remove(asyncTaskID);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Exit remoteIsDone for async task " + asyncTaskID + " : " + String.valueOf(task));
        }
        return result;
    }

    RemoteAsyncResult remoteGet(Long asyncTaskID) {
        EjbFutureTask task = this.getLocalTaskForID(asyncTaskID);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Enter remoteGet for async task " + asyncTaskID + " : " + String.valueOf(task.getEjbAsyncTask().getEjbInvocation()));
        }
        RemoteAsyncResult result = new RemoteAsyncResult();
        result.asyncID = asyncTaskID;
        try {
            result.resultValue = task.get();
        }
        catch (Throwable t) {
            result.resultException = t;
        }
        this.remoteTaskMap.remove(asyncTaskID);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Exit remoteGet for async task " + asyncTaskID + " : " + String.valueOf(task));
        }
        return result;
    }

    RemoteAsyncResult remoteGetWithTimeout(Long asyncTaskID, Long timeout, TimeUnit unit) throws TimeoutException {
        EjbFutureTask task = this.getLocalTaskForID(asyncTaskID);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Enter remoteGetWithTimeout for async task " + asyncTaskID + " timeout=" + timeout + " , unit=" + String.valueOf((Object)unit) + " : " + String.valueOf(task.getEjbAsyncTask().getEjbInvocation()));
        }
        RemoteAsyncResult result = new RemoteAsyncResult();
        result.asyncID = asyncTaskID;
        try {
            result.resultValue = task.get(timeout, unit);
        }
        catch (TimeoutException to) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "TimeoutException for async task " + asyncTaskID + " : " + String.valueOf(task));
            }
            throw to;
        }
        catch (Throwable t) {
            result.resultException = t;
        }
        this.remoteTaskMap.remove(asyncTaskID);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Exit remoteGetWithTimeout for async task " + asyncTaskID + " : " + String.valueOf(task));
        }
        return result;
    }

    private EjbFutureTask getLocalTaskForID(Long asyncTaskID) {
        EjbFutureTask task = this.remoteTaskMap.get(asyncTaskID);
        if (task == null) {
            _logger.log(Level.FINE, "Could not find async task for ID " + asyncTaskID);
            throw new EJBException("Could not find Local Async task corresponding to ID " + asyncTaskID);
        }
        return task;
    }
}

