/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.annotations.IExpectedExceptionsAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.annotations.ITestOrConfiguration;
import org.testng.collections.Lists;
import org.testng.internal.ArrayIterator;
import org.testng.internal.ClassHelper;
import org.testng.internal.ExpectedExceptionsHolder;
import org.testng.internal.Graph;
import org.testng.internal.MethodGroupsHelper;
import org.testng.internal.MethodInheritance;
import org.testng.internal.RunInfo;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.Sets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodHelper {
    public static ITestNGMethod[] collectAndOrderMethods(List<ITestNGMethod> methods, boolean forTests, RunInfo runInfo, IAnnotationFinder finder, boolean unique, List<ITestNGMethod> outExcludedMethods) {
        List<ITestNGMethod> includedMethods = Lists.newArrayList();
        MethodGroupsHelper.collectMethodsByGroup(methods.toArray(new ITestNGMethod[methods.size()]), forTests, includedMethods, outExcludedMethods, runInfo, finder, unique);
        return MethodHelper.sortMethods(forTests, includedMethods, finder).toArray(new ITestNGMethod[0]);
    }

    protected static ITestNGMethod[] findDependedUponMethods(ITestNGMethod m, ITestNGMethod[] methods) {
        String canonicalMethodName = MethodHelper.calculateMethodCanonicalName(m);
        List vResult = Lists.newArrayList();
        String regexp = null;
        for (String fullyQualifiedRegexp : m.getMethodsDependedUpon()) {
            boolean foundAtLeastAMethod = false;
            if (null != fullyQualifiedRegexp) {
                regexp = MethodHelper.escapeRegexp(fullyQualifiedRegexp);
                boolean usePackage = regexp.indexOf(46) != -1;
                for (ITestNGMethod method : methods) {
                    String methodName;
                    Method thisMethod = method.getMethod();
                    String thisMethodName = thisMethod.getName();
                    String string = methodName = usePackage ? MethodHelper.calculateMethodCanonicalName(thisMethod) : thisMethodName;
                    if (!Pattern.matches(regexp, methodName)) continue;
                    vResult.add(method);
                    foundAtLeastAMethod = true;
                }
            }
            if (foundAtLeastAMethod || m.ignoreMissingDependencies() || m.isAlwaysRun()) continue;
            Method maybeReferringTo = MethodHelper.findMethodByName(m, regexp);
            if (maybeReferringTo != null) {
                throw new TestNGException(canonicalMethodName + "() is depending on method " + maybeReferringTo + ", which is not annotated with @Test or not included.");
            }
            throw new TestNGException(canonicalMethodName + "() depends on nonexistent method " + regexp);
        }
        return vResult.toArray(new ITestNGMethod[vResult.size()]);
    }

    private static Method findMethodByName(ITestNGMethod testngMethod, String regExp) {
        String methodName;
        String className;
        if (regExp == null) {
            return null;
        }
        int lastDot = regExp.lastIndexOf(46);
        if (lastDot == -1) {
            className = testngMethod.getMethod().getDeclaringClass().getCanonicalName();
            methodName = regExp;
        } else {
            methodName = regExp.substring(lastDot + 1);
            className = regExp.substring(0, lastDot);
        }
        try {
            Class<?> c = Class.forName(className);
            for (Method m : c.getDeclaredMethods()) {
                if (!methodName.equals(m.getName())) continue;
                return m;
            }
        }
        catch (Exception e) {
            Utils.log("MethodHelper", 3, "Caught exception while searching for methods using regex");
        }
        return null;
    }

    private static String escapeRegexp(String regex) {
        if (regex.indexOf(36) == -1) {
            return regex;
        }
        String[] fragments = regex.split("\\$");
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < fragments.length - 1; ++i) {
            result.append(fragments[i]).append("\\$");
        }
        result.append(fragments[fragments.length - 1]);
        if (regex.endsWith("$")) {
            result.append("\\$");
        }
        return result.toString();
    }

    protected static ExpectedExceptionsHolder findExpectedExceptions(IAnnotationFinder finder, Method method) {
        ExpectedExceptionsHolder result = null;
        IExpectedExceptionsAnnotation expectedExceptions = (IExpectedExceptionsAnnotation)finder.findAnnotation(method, IExpectedExceptionsAnnotation.class);
        if (expectedExceptions != null) {
            result = new ExpectedExceptionsHolder(expectedExceptions.getValue(), ".*");
        } else {
            ITestAnnotation testAnnotation = (ITestAnnotation)finder.findAnnotation(method, ITestAnnotation.class);
            if (testAnnotation != null) {
                Class<?>[] ee = testAnnotation.getExpectedExceptions();
                if (testAnnotation != null && ee.length > 0) {
                    result = new ExpectedExceptionsHolder(ee, testAnnotation.getExpectedExceptionsMessageRegExp());
                }
            }
        }
        return result;
    }

    protected static boolean isEnabled(Class<?> objectClass, IAnnotationFinder finder) {
        ITestAnnotation testClassAnnotation = AnnotationHelper.findTest(finder, objectClass);
        return MethodHelper.isEnabled(testClassAnnotation);
    }

    protected static boolean isEnabled(Method m, IAnnotationFinder finder) {
        ITestAnnotation annotation = AnnotationHelper.findTest(finder, m);
        if (null == annotation) {
            annotation = AnnotationHelper.findTest(finder, m.getDeclaringClass());
        }
        return MethodHelper.isEnabled(annotation);
    }

    protected static boolean isEnabled(ITestOrConfiguration test) {
        return null == test || null != test && test.getEnabled();
    }

    public static List<ITestNGMethod> uniqueMethodList(Collection<List<ITestNGMethod>> methods) {
        Set resultSet = Sets.newHashSet();
        for (List<ITestNGMethod> l : methods) {
            resultSet.addAll(l);
        }
        return Lists.newArrayList(resultSet);
    }

    private static Graph<ITestNGMethod> topologicalSort(ITestNGMethod[] methods, List<ITestNGMethod> sequentialList, List<ITestNGMethod> parallelList) {
        Graph<ITestNGMethod> result = new Graph<ITestNGMethod>();
        if (methods.length == 0) {
            return result;
        }
        for (ITestNGMethod m : methods) {
            result.addNode(m);
            List<ITestNGMethod> predecessors = Lists.newArrayList();
            String[] methodsDependedUpon = m.getMethodsDependedUpon();
            String[] groupsDependedUpon = m.getGroupsDependedUpon();
            if (methodsDependedUpon.length > 0) {
                ITestNGMethod[] methodsNamed;
                for (ITestNGMethod pred : methodsNamed = MethodHelper.findDependedUponMethods(m, methods)) {
                    predecessors.add(pred);
                }
            }
            if (groupsDependedUpon.length > 0) {
                for (String group2 : groupsDependedUpon) {
                    ITestNGMethod[] methodsThatBelongToGroup;
                    for (ITestNGMethod pred : methodsThatBelongToGroup = MethodGroupsHelper.findMethodsThatBelongToGroup(m, methods, group2)) {
                        predecessors.add(pred);
                    }
                }
            }
            for (ITestNGMethod predecessor : predecessors) {
                result.addPredecessor(m, predecessor);
            }
        }
        result.topologicalSort();
        sequentialList.addAll(result.getStrictlySortedNodes());
        parallelList.addAll(result.getIndependentNodes());
        return result;
    }

    protected static String calculateMethodCanonicalName(ITestNGMethod m) {
        return MethodHelper.calculateMethodCanonicalName(m.getMethod());
    }

    private static String calculateMethodCanonicalName(Method m) {
        String packageName = m.getDeclaringClass().getName() + "." + m.getName();
        for (Class<?> cls = m.getDeclaringClass(); cls != Object.class; cls = cls.getSuperclass()) {
            try {
                if (cls.getDeclaredMethod(m.getName(), m.getParameterTypes()) == null) continue;
                packageName = cls.getName();
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String result = packageName + "." + m.getName();
        return result;
    }

    private static List<ITestNGMethod> sortMethods(boolean forTests, List<ITestNGMethod> allMethods, IAnnotationFinder finder) {
        List<ITestNGMethod> sl = Lists.newArrayList();
        List<ITestNGMethod> pl = Lists.newArrayList();
        ITestNGMethod[] allMethodsArray = allMethods.toArray(new ITestNGMethod[allMethods.size()]);
        if (!forTests && allMethodsArray.length > 0) {
            ITestNGMethod m = allMethodsArray[0];
            boolean before = m.isBeforeClassConfiguration() || m.isBeforeMethodConfiguration() || m.isBeforeSuiteConfiguration() || m.isBeforeTestConfiguration();
            MethodInheritance.fixMethodInheritance(allMethodsArray, before);
        }
        MethodHelper.topologicalSort(allMethodsArray, sl, pl);
        List<ITestNGMethod> result = Lists.newArrayList();
        result.addAll(sl);
        result.addAll(pl);
        return result;
    }

    public static List<ITestNGMethod> getMethodsDependedUpon(ITestNGMethod method, ITestNGMethod[] methods) {
        List<ITestNGMethod> parallelList = Lists.newArrayList();
        List<ITestNGMethod> sequentialList = Lists.newArrayList();
        Graph<ITestNGMethod> g = MethodHelper.topologicalSort(methods, sequentialList, parallelList);
        List<ITestNGMethod> result = g.findPredecessors(method);
        return result;
    }

    protected static Iterator<Object[]> createArrayIterator(Object[][] objects) {
        ArrayIterator result = new ArrayIterator(objects);
        return result;
    }

    protected static String calculateMethodCanonicalName(Class<?> methodClass, String methodName) {
        Set<Method> methods = ClassHelper.getAvailableMethods(methodClass);
        Method result = null;
        for (Method m : methods) {
            if (!methodName.equals(m.getName())) continue;
            result = m;
            break;
        }
        return result != null ? MethodHelper.calculateMethodCanonicalName(result) : null;
    }

    protected static long calculateTimeOut(ITestNGMethod tm) {
        long result = tm.getTimeOut() > 0L ? tm.getTimeOut() : tm.getInvocationTimeOut();
        return result;
    }
}

