/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.testng.ITestNGMethod;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationGroupMethods
implements Serializable {
    private static final long serialVersionUID = 1660798519864898480L;
    private final Map<String, List<ITestNGMethod>> m_beforeGroupsMethods;
    private final Map<String, List<ITestNGMethod>> m_afterGroupsMethods;
    private final ITestNGMethod[] m_allMethods;
    private Map<String, List<ITestNGMethod>> m_afterGroupsMap = null;

    public ConfigurationGroupMethods(ITestNGMethod[] allMethods, Map<String, List<ITestNGMethod>> beforeGroupsMethods, Map<String, List<ITestNGMethod>> afterGroupsMethods) {
        this.m_allMethods = allMethods;
        this.m_beforeGroupsMethods = beforeGroupsMethods;
        this.m_afterGroupsMethods = afterGroupsMethods;
    }

    public Map<String, List<ITestNGMethod>> getBeforeGroupsMethods() {
        return this.m_beforeGroupsMethods;
    }

    public Map<String, List<ITestNGMethod>> getAfterGroupsMethods() {
        return this.m_afterGroupsMethods;
    }

    public synchronized boolean isLastMethodForGroup(String group2, ITestNGMethod method) {
        List<ITestNGMethod> methodsInGroup;
        int invocationCount = method.getCurrentInvocationCount();
        if (invocationCount < method.getInvocationCount() * method.getParameterInvocationCount()) {
            return false;
        }
        if (this.m_afterGroupsMap == null) {
            this.m_afterGroupsMap = this.initializeAfterGroupsMap();
        }
        if (null == (methodsInGroup = this.m_afterGroupsMap.get(group2)) || methodsInGroup.isEmpty()) {
            return false;
        }
        methodsInGroup.remove(method);
        return methodsInGroup.isEmpty();
    }

    private synchronized Map<String, List<ITestNGMethod>> initializeAfterGroupsMap() {
        Map<String, List<ITestNGMethod>> result = Maps.newHashMap();
        for (ITestNGMethod m : this.m_allMethods) {
            String[] groups;
            for (String g : groups = m.getGroups()) {
                List<ITestNGMethod> methodsInGroup = result.get(g);
                if (null == methodsInGroup) {
                    methodsInGroup = Lists.newArrayList();
                    result.put(g, methodsInGroup);
                }
                methodsInGroup.add(m);
            }
        }
        return result;
    }

    public synchronized void removeBeforeMethod(String group2, ITestNGMethod method) {
        List<ITestNGMethod> methods = this.m_beforeGroupsMethods.get(group2);
        if (methods != null) {
            Boolean success = methods.remove(method);
            if (success == null) {
                this.log("Couldn't remove beforeGroups method " + method + " for group " + group2);
            }
        } else {
            this.log("Couldn't find any beforeGroups method for group " + group2);
        }
    }

    private void log(String string) {
        Utils.log("ConfigurationGroupMethods", 2, string);
    }

    public synchronized Map<String, List<ITestNGMethod>> getBeforeGroupsMap() {
        return this.m_beforeGroupsMethods;
    }

    public synchronized Map<String, List<ITestNGMethod>> getAfterGroupsMap() {
        return this.m_afterGroupsMethods;
    }

    public synchronized void removeBeforeGroups(String[] groups) {
        for (String group2 : groups) {
            this.m_beforeGroupsMethods.remove(group2);
        }
    }

    public synchronized void removeAfterGroups(Collection<String> groups) {
        for (String group2 : groups) {
            this.m_afterGroupsMethods.remove(group2);
        }
    }
}

