/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.util;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.Storeable;
import org.shoal.adapter.store.ReplicatedBackingStoreFactory;

public class StoreableBackingStoreShell {
    BackingStore<String, MyStoreable> ds;
    ConcurrentHashMap<String, MyStoreable> cache = new ConcurrentHashMap();
    int counter = 0;

    public static void main(String[] args) throws Exception {
        BackingStoreConfiguration conf = new BackingStoreConfiguration();
        conf.setStoreName(args[0]).setInstanceName(args[1]).setClusterName(args[2]).setKeyClazz(String.class).setValueClazz(MyStoreable.class).setClassLoader(ClassLoader.getSystemClassLoader());
        Map<String, Object> map = conf.getVendorSpecificSettings();
        map.put("start.gms", true);
        map.put("class.loader", ClassLoader.getSystemClassLoader());
        map.put("async.replication", true);
        BackingStore<String, MyStoreable> ds = new ReplicatedBackingStoreFactory().createBackingStore(conf);
        StoreableBackingStoreShell main = new StoreableBackingStoreShell();
        main.runShell(ds);
    }

    private void runShell(BackingStore<String, MyStoreable> ds) {
        this.ds = ds;
        String line = "";
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        do {
            this.prompt();
            try {
                line = br.readLine();
                ArrayList<String> args = new ArrayList<String>();
                StringTokenizer tok = new StringTokenizer(line, "\n\r\t\f \f");
                while (tok.hasMoreTokens()) {
                    String str = tok.nextToken();
                    args.add(str);
                }
                if (args.size() <= 0) continue;
                String command = (String)args.remove(0);
                String[] params = args.toArray(new String[0]);
                this.execute(command, params);
                ++this.counter;
            }
            catch (IOException ioEx) {
                ioEx.printStackTrace();
            }
            catch (BackingStoreException bsEx) {
                bsEx.printStackTrace();
            }
        } while (!"quit".equalsIgnoreCase(line));
    }

    private void prompt() {
        System.out.print("" + this.counter + ">");
        System.out.flush();
    }

    private void execute(String command, String[] params) throws BackingStoreException {
        if ("put".equalsIgnoreCase(command)) {
            String key = params[0];
            for (int i = 0; i < 8; ++i) {
                String key1 = params[0] + ":" + i;
                MyStoreable st1 = this.cache.get(key1);
                if (st1 == null) {
                    st1 = new MyStoreable();
                    this.cache.put(key1, st1);
                }
                if (params.length > 1) {
                    st1.setStr1(params[1] + ":" + i);
                }
                if (params.length > 2) {
                    st1.setStr2(params[2] + ":" + i);
                }
                st1.touch();
                String replica = this.ds.save(key1, st1, true);
                System.out.println("PUT key = " + key1 + " : " + st1 + " ==> " + replica);
            }
        } else if ("get".equalsIgnoreCase(command)) {
            MyStoreable st = this.ds.load(params[0], params.length > 1 ? params[1] : null);
            System.out.println("get(" + params[0] + ") => " + st);
            if (st != null) {
                this.cache.put(params[0], st);
            }
        } else if ("touch".equalsIgnoreCase(command)) {
            MyStoreable st = this.ds.load(params[0], params.length > 1 ? params[1] : null);
            st.touch();
            String result = null;
            this.ds.updateTimestamp(params[0], st._storeable_getLastAccessTime());
            System.out.println("Result of touch: " + result);
        } else if ("remove".equalsIgnoreCase(command)) {
            this.ds.remove(params[0]);
        }
    }

    public static class MyStoreable
    implements Storeable {
        long version;
        long accessTime;
        long maxIdleTime;
        String str1;
        String str2;
        boolean[] dirty = new boolean[2];

        public void touch() {
            ++this.version;
            this.accessTime = System.currentTimeMillis();
            this.maxIdleTime = 15000L;
        }

        @Override
        public long _storeable_getVersion() {
            return this.version;
        }

        public String getStr1() {
            return this.str1;
        }

        public void setStr1(String str1) {
            boolean same;
            boolean bl = str1 != null ? str1.equals(this.str1) : (same = this.str1 == null);
            if (!same) {
                this.str1 = str1;
                this.dirty[0] = true;
            }
        }

        public String getStr2() {
            return this.str2;
        }

        public void setStr2(String str2) {
            boolean same;
            boolean bl = str2 != null ? str2.equals(this.str2) : (same = this.str2 == null);
            if (!same) {
                this.str2 = str2;
                this.dirty[1] = true;
            }
        }

        @Override
        public void _storeable_setVersion(long version) {
            this.version = version;
        }

        @Override
        public long _storeable_getLastAccessTime() {
            return this.maxIdleTime;
        }

        @Override
        public void _storeable_setLastAccessTime(long accessTime) {
            this.accessTime = accessTime;
        }

        @Override
        public long _storeable_getMaxIdleTime() {
            return this.maxIdleTime;
        }

        @Override
        public void _storeable_setMaxIdleTime(long maxIdleTime) {
            this.maxIdleTime = maxIdleTime;
        }

        @Override
        public String[] _storeable_getAttributeNames() {
            return new String[]{"str1", "str2"};
        }

        @Override
        public boolean[] _storeable_getDirtyStatus() {
            return this.dirty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void _storeable_writeState(OutputStream os) throws IOException {
            DataOutputStream dos = null;
            try {
                dos = new DataOutputStream(os);
                dos.writeBoolean(this.dirty[0]);
                if (this.dirty[0]) {
                    dos.writeInt(this.str1 == null ? 0 : this.str1.length());
                    if (this.str1 != null) {
                        dos.write(this.str1.getBytes());
                    }
                }
                dos.writeBoolean(this.dirty[1]);
                if (this.dirty[1]) {
                    dos.writeInt(this.str2 == null ? 0 : this.str2.length());
                    if (this.str2 != null) {
                        dos.write(this.str2.getBytes());
                    }
                }
            }
            finally {
                try {
                    dos.flush();
                    dos.close();
                }
                catch (IOException iOException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void _storeable_readState(InputStream is) throws IOException {
            DataInputStream dis = null;
            try {
                byte[] strBytes;
                int strLen;
                dis = new DataInputStream(is);
                this.dirty = new boolean[2];
                this.dirty[0] = dis.readBoolean();
                if (this.dirty[0] && (strLen = dis.readInt()) > 0) {
                    strBytes = new byte[strLen];
                    dis.read(strBytes);
                    this.str1 = new String(strBytes);
                }
                this.dirty[1] = dis.readBoolean();
                if (this.dirty[1] && (strLen = dis.readInt()) > 0) {
                    strBytes = new byte[strLen];
                    dis.read(strBytes);
                    this.str2 = new String(strBytes);
                }
            }
            finally {
                try {
                    dis.close();
                }
                catch (IOException iOException) {}
            }
        }

        public String toString() {
            return "MyStoreable{version=" + this.version + ", accessTime=" + this.accessTime + ", maxIdleTime=" + this.maxIdleTime + ", str1='" + this.str1 + '\'' + ", str2='" + this.str2 + '\'' + ", dirty=" + Arrays.toString(this.dirty) + '}';
        }
    }
}

