/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.api;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.util.KeyTransformer;
import org.shoal.ha.cache.api.DataStoreConfigurator;
import org.shoal.ha.cache.api.ReplicatedDataStoreStatsHolder;
import org.shoal.ha.cache.impl.command.CommandManager;
import org.shoal.ha.cache.impl.store.ReplicaStore;
import org.shoal.ha.cache.impl.util.ResponseMediator;
import org.shoal.ha.group.GroupService;
import org.shoal.ha.mapper.KeyMapper;

public class DataStoreContext<K, V>
extends DataStoreConfigurator<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.store");
    private CommandManager<K, V> cm;
    private ResponseMediator responseMediator;
    private GroupService groupService;
    private ReplicaStore<K, V> replicaStore;
    private ReplicatedDataStoreStatsHolder dscMBean;

    public DataStoreContext(String serviceName, GroupService gs, ClassLoader loader) {
        super.setStoreName(serviceName);
        super.setInstanceName(gs.getMemberName());
        this.groupService = gs;
        super.setClassLoader(loader);
    }

    public DataStoreContext() {
    }

    public DataStoreContext(BackingStoreConfiguration conf) {
        Object bcastRemExpObj;
        Object safeToDelayCaptureStateObj;
        Object idleTimeInSeconds;
        KeyTransformer kt;
        this.setInstanceName(conf.getInstanceName()).setGroupName(conf.getClusterName()).setStoreName(conf.getStoreName()).setKeyClazz(conf.getKeyClazz()).setValueClazz(conf.getValueClazz());
        if (conf.getClassLoader() != null) {
            _logger.log(Level.FINE, "**DSC[" + conf.getStoreName() + "] Client supplied ClassLoader : " + conf.getClassLoader());
            this.setClassLoader(conf.getClassLoader());
        }
        Map<String, Object> vendorSpecificMap = conf.getVendorSpecificSettings();
        Object stGMS = vendorSpecificMap.get("start.gms");
        boolean startGMS = false;
        if (stGMS != null) {
            if (stGMS instanceof String) {
                try {
                    startGMS = Boolean.valueOf((String)stGMS);
                }
                catch (Throwable th) {}
            } else if (stGMS instanceof Boolean) {
                startGMS = (Boolean)stGMS;
            }
        }
        Object cacheLocally = vendorSpecificMap.get("local.caching");
        boolean enableLocalCaching = false;
        if (cacheLocally != null) {
            if (cacheLocally instanceof String) {
                try {
                    enableLocalCaching = Boolean.valueOf((String)cacheLocally);
                }
                catch (Throwable th) {}
            } else if (cacheLocally instanceof Boolean) {
                enableLocalCaching = (Boolean)stGMS;
            }
        }
        if (this.getClassLoader() == null) {
            ClassLoader cl = (ClassLoader)vendorSpecificMap.get("class.loader");
            _logger.log(Level.FINE, "**DSC[" + conf.getStoreName() + "] vendorMap.classLoader CLASS LOADER: " + cl);
            if (cl == null) {
                cl = conf.getValueClazz().getClassLoader();
                _logger.log(Level.FINE, "**DSC[" + conf.getStoreName() + "] USING VALUE CLASS CLASS LOADER: " + conf.getValueClazz().getName());
            }
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
                _logger.log(Level.FINE, "**DSC[" + conf.getStoreName() + "] USING system CLASS CLASS LOADER: " + cl);
            }
            _logger.log(Level.FINE, "**DSC[" + conf.getStoreName() + "] FINALLY USING CLASS CLASS LOADER: " + cl);
            this.setClassLoader(cl);
        }
        this.setStartGMS(startGMS).setCacheLocally(enableLocalCaching);
        boolean asyncReplication = vendorSpecificMap.get("async.replication") == null ? true : (Boolean)vendorSpecificMap.get("async.replication");
        this.setDoSynchronousReplication(!asyncReplication);
        KeyMapper keyMapper = (KeyMapper)vendorSpecificMap.get("key.mapper");
        if (keyMapper != null) {
            this.setKeyMapper(keyMapper);
        }
        if ((kt = (KeyTransformer)vendorSpecificMap.get("key.transformer")) != null) {
            super.setKeyTransformer(kt);
            _logger.log(Level.FINE, "** USING CLIENT DEFINED KeyTransfomer: " + super.getKeyTransformer().getClass().getName());
        }
        if ((idleTimeInSeconds = vendorSpecificMap.get("max.idle.timeout.in.seconds")) != null) {
            long defaultMaxIdleTimeInMillis = -1L;
            if (idleTimeInSeconds instanceof Long) {
                defaultMaxIdleTimeInMillis = (Long)idleTimeInSeconds;
            } else if (idleTimeInSeconds instanceof String) {
                try {
                    defaultMaxIdleTimeInMillis = Long.valueOf((String)idleTimeInSeconds);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            this.setDefaultMaxIdleTimeInMillis(defaultMaxIdleTimeInMillis * 1000L);
        }
        if ((safeToDelayCaptureStateObj = vendorSpecificMap.get("value.class.is.thread.safe")) != null) {
            boolean safeToDelayCaptureState = true;
            if (safeToDelayCaptureStateObj instanceof Boolean) {
                safeToDelayCaptureState = (Boolean)safeToDelayCaptureStateObj;
            } else if (safeToDelayCaptureStateObj instanceof String) {
                try {
                    safeToDelayCaptureState = Boolean.valueOf((String)safeToDelayCaptureStateObj);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            this.setSafeToDelayCaptureState(safeToDelayCaptureState);
        }
        if ((bcastRemExpObj = vendorSpecificMap.get("broadcast.remove.expired")) != null) {
            boolean bcastRemExp = true;
            if (bcastRemExpObj instanceof Boolean) {
                bcastRemExp = (Boolean)bcastRemExpObj;
            } else if (bcastRemExpObj instanceof String) {
                try {
                    bcastRemExp = Boolean.valueOf((String)bcastRemExpObj);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            this.setBroadcastRemovedExpired(bcastRemExp);
        }
    }

    public void setDataStoreMBean(ReplicatedDataStoreStatsHolder<K, V> dscMBean) {
        this.dscMBean = dscMBean;
    }

    public ReplicatedDataStoreStatsHolder<K, V> getDataStoreMBean() {
        return this.dscMBean;
    }

    public String getServiceName() {
        return super.getStoreName();
    }

    public CommandManager<K, V> getCommandManager() {
        return this.cm;
    }

    public ResponseMediator getResponseMediator() {
        return this.responseMediator;
    }

    public void setResponseMediator(ResponseMediator responseMediator) {
        this.responseMediator = responseMediator;
    }

    public GroupService getGroupService() {
        return this.groupService;
    }

    public void setCommandManager(CommandManager<K, V> cm) {
        this.cm = cm;
    }

    public void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    public void setReplicaStore(ReplicaStore<K, V> replicaStore) {
        this.replicaStore = replicaStore;
    }

    public ReplicaStore<K, V> getReplicaStore() {
        return this.replicaStore;
    }
}

