/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.common_impl.DirectoryBasedRepository;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.jvnet.hk2.osgiadapter.Logger;
import org.jvnet.hk2.osgiadapter.OSGiModuleDefinition;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class OSGiDirectoryBasedRepository
extends DirectoryBasedRepository {
    private Map<URI, ModuleDefinition> cachedData = new HashMap<URI, ModuleDefinition>();
    private boolean cacheInvalidated = true;

    public OSGiDirectoryBasedRepository(String name, File repository) {
        this(name, repository, true);
    }

    public OSGiDirectoryBasedRepository(String name, File repository, boolean isTimerThreadDaemon) {
        super(name, repository, isTimerThreadDaemon);
    }

    @Override
    public void initialize() throws IOException {
        super.initialize();
    }

    private void loadCachedData() throws Exception {
        String cacheLocation = this.getProperty("com.sun.enterprise.hk2.cacheDir");
        if (cacheLocation == null) {
            return;
        }
        File io = new File(cacheLocation, "inhabitants");
        if (!io.exists()) {
            return;
        }
        if (Logger.logger.isLoggable(Level.FINE)) {
            Logger.logger.logp(Level.INFO, "OSGiDirectoryBasedRepository", "loadCachedData", "HK2 cache file = {0}", new Object[]{io});
        }
        ObjectInputStream stream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(io), this.getBufferSize()));
        this.cachedData = (Map)stream.readObject();
        stream.close();
        this.cacheInvalidated = false;
    }

    private void saveCache() throws IOException {
        String cacheLocation = this.getProperty("com.sun.enterprise.hk2.cacheDir");
        if (cacheLocation == null) {
            return;
        }
        File io = new File(cacheLocation, "inhabitants");
        if (Logger.logger.isLoggable(Level.FINE)) {
            Logger.logger.logp(Level.INFO, "OSGiDirectoryBasedRepository", "saveCache", "HK2 cache file = {0}", new Object[]{io});
        }
        if (io.exists()) {
            io.delete();
        }
        io.createNewFile();
        HashMap<URI, ModuleDefinition> data = new HashMap<URI, ModuleDefinition>();
        for (ModuleDefinition md : this.findAll()) {
            data.put(md.getLocations()[0], md);
        }
        ObjectOutputStream os = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(io), this.getBufferSize()));
        os.writeObject(data);
        os.close();
    }

    private void deleteCache() {
        String cacheLocation = this.getProperty("com.sun.enterprise.hk2.cacheDir");
        if (cacheLocation == null) {
            return;
        }
        File io = new File(cacheLocation, "inhabitants");
        if (io.exists()) {
            if (io.delete()) {
                Logger.logger.logp(Level.FINE, "OSGiDirectoryBasedRepository", "deleteCache", "deleted = {0}", new Object[]{io});
            } else {
                Logger.logger.logp(Level.WARNING, "OSGiDirectoryBasedRepository", "deleteCache", "failed to delete = {0}", new Object[]{io});
            }
        }
    }

    private int getBufferSize() {
        int bufsize = 1024;
        try {
            bufsize = Integer.valueOf(this.getProperty("com.sun.enterprise.hk2.cacheIoBufferSize"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Logger.logger.isLoggable(Level.FINE)) {
            Logger.logger.logp(Level.FINE, "OSGiDirectoryBasedRepository", "getBufferSize", "bufsize = {0}", new Object[]{bufsize});
        }
        return bufsize;
    }

    @Override
    protected ModuleDefinition loadJar(File jar) throws IOException {
        assert (jar.isFile());
        ModuleDefinition md = this.cachedData.get(jar.toURI());
        if (md != null) {
            if (Logger.logger.isLoggable(Level.FINE)) {
                Logger.logger.logp(Level.FINER, "OSGiDirectoryBasedRepository", "loadJar", "Found in mdCache for {0}", new Object[]{jar});
            }
            return md;
        }
        this.cacheInvalidated = true;
        Manifest m = new JarFile(jar).getManifest();
        if (m != null && m.getMainAttributes().getValue("Bundle-SymbolicName") != null) {
            Logger.logger.logp(Level.FINE, "OSGiDirectoryBasedRepository", "loadJar", "{0} is an OSGi bundle", new Object[]{jar});
            return this.newModuleDefinition(jar, null);
        }
        return null;
    }

    @Override
    protected ModuleDefinition newModuleDefinition(File jar, Attributes attr) throws IOException {
        return new OSGiModuleDefinition(jar);
    }

    protected String getProperty(String property) {
        BundleContext bctx = null;
        try {
            bctx = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        }
        catch (Exception e) {
            // empty catch block
        }
        String value = bctx != null ? bctx.getProperty(property) : null;
        return value != null ? value : System.getProperty(property);
    }
}

