/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleChangeListener;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleLifecycleListener;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.ResolveError;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.module.common_impl.AbstractModulesRegistryImpl;
import com.sun.enterprise.module.common_impl.CompositeEnumeration;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorState;
import org.glassfish.hk2.bootstrap.PopulatorPostProcessor;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.jvnet.hk2.osgiadapter.Logger;
import org.jvnet.hk2.osgiadapter.OSGiModuleId;
import org.jvnet.hk2.osgiadapter.OSGiModuleImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public abstract class AbstractOSGiModulesRegistryImpl
extends AbstractModulesRegistryImpl {
    BundleContext bctx;
    protected PackageAdmin pa;
    private Map<ModuleChangeListener, BundleListener> moduleChangeListeners = new HashMap<ModuleChangeListener, BundleListener>();
    private Map<ModuleLifecycleListener, BundleListener> moduleLifecycleListeners = new HashMap<ModuleLifecycleListener, BundleListener>();

    protected AbstractOSGiModulesRegistryImpl(BundleContext bctx) {
        super(null);
        this.bctx = bctx;
        ServiceReference ref = bctx.getServiceReference(PackageAdmin.class.getName());
        this.pa = (PackageAdmin)PackageAdmin.class.cast(bctx.getService(ref));
    }

    @Override
    public void shutdown() {
        this.modules.clear();
        for (Repository repo : this.repositories.values()) {
            try {
                repo.shutdown();
            }
            catch (Exception e) {
                java.util.logging.Logger.getAnonymousLogger().log(Level.SEVERE, "Error while closing repository " + repo, e);
            }
        }
    }

    @Override
    public List<ActiveDescriptor> parseInhabitants(Module module, String name, ServiceLocator serviceLocator, List<PopulatorPostProcessor> postProcessors) throws IOException, BootException {
        return ((OSGiModuleImpl)module).parseInhabitants(name, serviceLocator, postProcessors);
    }

    @Override
    public ModulesRegistry createChild() {
        throw new UnsupportedOperationException("Not Yet Implemented");
    }

    @Override
    public synchronized void detachAll() {
        for (Module m : this.modules.values()) {
            m.detach();
        }
    }

    @Override
    public void setParentClassLoader(ClassLoader parent) {
        throw new UnsupportedOperationException("This method can't be implemented in OSGi environment");
    }

    @Override
    public ClassLoader getParentClassLoader() {
        return Bundle.class.getClassLoader();
    }

    @Override
    public ClassLoader getModulesClassLoader(final ClassLoader parent, Collection<ModuleDefinition> mds, URL[] urls) throws ResolveError {
        final ArrayList<ClassLoader> delegateCLs = new ArrayList<ClassLoader>();
        final ArrayList<Module> delegateModules = new ArrayList<Module>();
        for (ModuleDefinition md : mds) {
            Module m = this.makeModuleFor(md.getName(), md.getVersion());
            delegateModules.add(m);
            delegateCLs.add(m.getClassLoader());
        }
        return new URLClassLoader(urls != null ? urls : new URL[]{}, parent){

            @Override
            public URL[] getURLs() {
                ArrayList<URL> result = new ArrayList<URL>();
                if (parent instanceof URLClassLoader) {
                    URL[] parentURLs = ((URLClassLoader)URLClassLoader.class.cast(parent)).getURLs();
                    result.addAll(Arrays.asList(parentURLs));
                }
                for (Module m : delegateModules) {
                    ModuleDefinition md = m.getModuleDefinition();
                    URI[] uris = md.getLocations();
                    URL[] urls = new URL[uris.length];
                    for (int i = 0; i < uris.length; ++i) {
                        try {
                            urls[i] = uris[i].toURL();
                            continue;
                        }
                        catch (MalformedURLException e) {
                            Logger.logger.warning("Exception " + e + " while converting " + uris[i] + " to URL");
                        }
                    }
                    result.addAll(Arrays.asList(urls));
                }
                return result.toArray(new URL[0]);
            }

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                for (ClassLoader delegate : delegateCLs) {
                    try {
                        return delegate.loadClass(name);
                    }
                    catch (ClassNotFoundException e) {
                    }
                }
                throw new ClassNotFoundException(name);
            }

            @Override
            public URL findResource(String name) {
                URL resource = null;
                for (ClassLoader delegate : delegateCLs) {
                    resource = delegate.getResource(name);
                    if (resource == null) continue;
                    return resource;
                }
                return resource;
            }

            @Override
            public Enumeration<URL> findResources(String name) throws IOException {
                ArrayList<Enumeration<URL>> enumerators = new ArrayList<Enumeration<URL>>();
                for (ClassLoader delegate : delegateCLs) {
                    Enumeration<URL> enumerator = delegate.getResources(name);
                    enumerators.add(enumerator);
                }
                return new CompositeEnumeration(enumerators);
            }
        };
    }

    @Override
    public ClassLoader getModulesClassLoader(ClassLoader parent, Collection<ModuleDefinition> defs) throws ResolveError {
        return this.getModulesClassLoader(parent, defs, null);
    }

    @Override
    public Module find(Class clazz) {
        Bundle b = this.pa.getBundle(clazz);
        if (b != null) {
            return this.getModule(b);
        }
        return null;
    }

    public PackageAdmin getPackageAdmin() {
        return this.pa;
    }

    public void addModuleChangeListener(final ModuleChangeListener listener, final OSGiModuleImpl module) {
        BundleListener bundleListener = new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getBundle() == module.getBundle() && (event.getType() & 8) == 8) {
                    listener.changed(module);
                }
            }
        };
        this.bctx.addBundleListener(bundleListener);
        this.moduleChangeListeners.put(listener, bundleListener);
    }

    public boolean removeModuleChangeListener(ModuleChangeListener listener) {
        BundleListener bundleListener = this.moduleChangeListeners.remove(listener);
        if (bundleListener != null) {
            this.bctx.removeBundleListener(bundleListener);
            return true;
        }
        return false;
    }

    @Override
    public void register(final ModuleLifecycleListener listener) {
        BundleListener bundleListener = new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                switch (event.getType()) {
                    case 1: {
                        listener.moduleInstalled(AbstractOSGiModulesRegistryImpl.this.getModule(event.getBundle()));
                        break;
                    }
                    case 8: {
                        listener.moduleUpdated(AbstractOSGiModulesRegistryImpl.this.getModule(event.getBundle()));
                        break;
                    }
                    case 32: {
                        listener.moduleResolved(AbstractOSGiModulesRegistryImpl.this.getModule(event.getBundle()));
                        break;
                    }
                    case 2: {
                        listener.moduleStarted(AbstractOSGiModulesRegistryImpl.this.getModule(event.getBundle()));
                        break;
                    }
                    case 4: {
                        listener.moduleStopped(AbstractOSGiModulesRegistryImpl.this.getModule(event.getBundle()));
                    }
                }
            }
        };
        this.bctx.addBundleListener(bundleListener);
        this.moduleLifecycleListeners.put(listener, bundleListener);
    }

    @Override
    public void unregister(ModuleLifecycleListener listener) {
        BundleListener bundleListener = this.moduleLifecycleListeners.remove(listener);
        if (bundleListener != null) {
            this.bctx.removeBundleListener(bundleListener);
        }
    }

    Module getModule(Bundle bundle2) {
        return (Module)this.modules.get(new OSGiModuleId(bundle2));
    }

    @Override
    public void remove(Module module) {
        super.remove(module);
        if (!(module instanceof OSGiModuleImpl)) {
            return;
        }
        OSGiModuleImpl oModule = (OSGiModuleImpl)module;
        Bundle bundle2 = oModule.getBundle();
        String bsn = bundle2.getSymbolicName();
        String version = bundle2.getVersion().toString();
        Set<ServiceLocator> locators = this.getAllServiceLocators();
        for (ServiceLocator locator : locators) {
            if (!ServiceLocatorState.RUNNING.equals((Object)locator.getState())) continue;
            ServiceLocatorUtilities.removeFilter(locator, new RemoveFilter(bsn, version));
        }
    }

    private static class RemoveFilter
    implements Filter {
        private final String bsn;
        private final String version;

        private RemoveFilter(String bsn, String version) {
            this.bsn = bsn;
            this.version = version;
        }

        private static String getMetadataValue(Descriptor d, String key) {
            Map<String, List<String>> metadata = d.getMetadata();
            List<String> values = metadata.get(key);
            if (values == null || values.size() <= 0) {
                return null;
            }
            return values.get(0);
        }

        @Override
        public boolean matches(Descriptor d) {
            String dBSN = RemoveFilter.getMetadataValue(d, "Bundle-SymbolicName");
            if (dBSN == null || !dBSN.equals(this.bsn)) {
                return false;
            }
            String dVersion = RemoveFilter.getMetadataValue(d, "Bundle-Version");
            if (dVersion == null) {
                return false;
            }
            return dVersion.equals(this.version);
        }
    }
}

