/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.Unqualified;
import org.glassfish.hk2.utilities.NamedImpl;
import org.glassfish.hk2.utilities.reflection.Pretty;
import org.jvnet.hk2.internal.ServiceLocatorImpl;
import org.jvnet.hk2.internal.Utilities;

public class IterableProviderImpl<T>
implements IterableProvider<T> {
    private final ServiceLocatorImpl locator;
    private final Type requiredType;
    private final Set<Annotation> requiredQualifiers;
    private final Unqualified unqualified;

    IterableProviderImpl(ServiceLocatorImpl locator, Type requiredType, Set<Annotation> requiredQualifiers, Unqualified unqualified) {
        this.locator = locator;
        this.requiredType = requiredType;
        this.requiredQualifiers = Collections.unmodifiableSet(requiredQualifiers);
        this.unqualified = unqualified;
    }

    @Override
    public T get() {
        if (this.unqualified == null) {
            return this.locator.getService(this.requiredType, this.requiredQualifiers.toArray(new Annotation[this.requiredQualifiers.size()]));
        }
        return this.locator.getUnqualifiedService(this.requiredType, this.unqualified, this.requiredQualifiers.toArray(new Annotation[this.requiredQualifiers.size()]));
    }

    @Override
    public ServiceHandle<T> getHandle() {
        if (this.unqualified == null) {
            return this.locator.getServiceHandle(this.requiredType, this.requiredQualifiers.toArray(new Annotation[this.requiredQualifiers.size()]));
        }
        return this.locator.getUnqualifiedServiceHandle(this.requiredType, this.unqualified, this.requiredQualifiers.toArray(new Annotation[this.requiredQualifiers.size()]));
    }

    @Override
    public Iterator<T> iterator() {
        List handles = this.unqualified == null ? (List)Utilities.cast(this.locator.getAllServiceHandles(this.requiredType, this.requiredQualifiers.toArray(new Annotation[this.requiredQualifiers.size()]))) : (List)Utilities.cast(this.locator.getAllUnqualifiedServiceHandles(this.requiredType, this.unqualified, this.requiredQualifiers.toArray(new Annotation[this.requiredQualifiers.size()])));
        return new MyIterator(handles);
    }

    @Override
    public int getSize() {
        if (this.unqualified == null) {
            return this.locator.getAllServiceHandles(this.requiredType, this.requiredQualifiers.toArray(new Annotation[this.requiredQualifiers.size()])).size();
        }
        return this.locator.getAllUnqualifiedServiceHandles(this.requiredType, this.unqualified, this.requiredQualifiers.toArray(new Annotation[this.requiredQualifiers.size()])).size();
    }

    @Override
    public IterableProvider<T> named(String name) {
        return this.qualifiedWith(new NamedImpl(name));
    }

    @Override
    public <U> IterableProvider<U> ofType(Type type2) {
        return new IterableProviderImpl<T>(this.locator, type2, this.requiredQualifiers, this.unqualified);
    }

    @Override
    public IterableProvider<T> qualifiedWith(Annotation ... qualifiers) {
        HashSet<Annotation> moreAnnotations = new HashSet<Annotation>(this.requiredQualifiers);
        for (Annotation qualifier : qualifiers) {
            moreAnnotations.add(qualifier);
        }
        return new IterableProviderImpl<T>(this.locator, this.requiredType, moreAnnotations, this.unqualified);
    }

    @Override
    public Iterable<ServiceHandle<T>> handleIterator() {
        List handles = (List)Utilities.cast(this.locator.getAllServiceHandles(this.requiredType, this.requiredQualifiers.toArray(new Annotation[this.requiredQualifiers.size()])));
        return new HandleIterable(handles);
    }

    public String toString() {
        return "IterableProviderImpl(" + Pretty.type(this.requiredType) + "," + Pretty.collection(this.requiredQualifiers) + "," + System.identityHashCode(this) + ")";
    }

    private static class HandleIterable<U>
    implements Iterable<ServiceHandle<U>> {
        private final List<ServiceHandle<U>> handles;

        private HandleIterable(List<ServiceHandle<U>> handles) {
            this.handles = new LinkedList<ServiceHandle<U>>(handles);
        }

        @Override
        public Iterator<ServiceHandle<U>> iterator() {
            return new MyHandleIterator(this.handles);
        }
    }

    private static class MyHandleIterator<U>
    implements Iterator<ServiceHandle<U>> {
        private final LinkedList<ServiceHandle<U>> handles;

        private MyHandleIterator(List<ServiceHandle<U>> handles) {
            this.handles = new LinkedList<ServiceHandle<U>>(handles);
        }

        @Override
        public boolean hasNext() {
            return !this.handles.isEmpty();
        }

        @Override
        public ServiceHandle<U> next() {
            return this.handles.removeFirst();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class MyIterator<U>
    implements Iterator<U> {
        private final LinkedList<ServiceHandle<U>> handles;

        private MyIterator(List<ServiceHandle<U>> handles) {
            this.handles = new LinkedList<ServiceHandle<U>>(handles);
        }

        @Override
        public boolean hasNext() {
            return !this.handles.isEmpty();
        }

        @Override
        public U next() {
            ServiceHandle<U> nextHandle = this.handles.removeFirst();
            return nextHandle.getService();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

