/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.logging.messages.UtilMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Observers {
    public static void checkEventObjectType(BeanManagerImpl manager, Type eventType) {
        Observers.checkEventObjectType(manager.getServices().get(SharedObjectCache.class), eventType);
    }

    public static void checkEventObjectType(SharedObjectCache cache, Type eventType) {
        Type[] types;
        Type resolvedType = cache.getResolvedType(eventType);
        if (resolvedType instanceof Class) {
            types = new Type[]{};
        } else if (resolvedType instanceof ParameterizedType) {
            types = ((ParameterizedType)resolvedType).getActualTypeArguments();
        } else {
            throw new IllegalArgumentException(UtilMessage.EVENT_TYPE_NOT_ALLOWED, resolvedType);
        }
        for (Type type2 : types) {
            if (!(type2 instanceof TypeVariable)) continue;
            throw new IllegalArgumentException(UtilMessage.TYPE_PARAMETER_NOT_ALLOWED_IN_EVENT_TYPE, resolvedType);
        }
    }

    public static void checkEventObjectType(SharedObjectCache cache, Object event) {
        Observers.checkEventObjectType(cache, event.getClass());
    }

    public static boolean isObserverMethodEnabled(ObserverMethod<?> method, BeanManagerImpl manager) {
        if (method instanceof ObserverMethodImpl) {
            RIBean declaringBean = ((ObserverMethodImpl)Reflections.cast(method)).getDeclaringBean();
            return manager.isBeanEnabled(declaringBean) && !Beans.isSpecialized(declaringBean, manager) && !Beans.isSuppressedBySpecialization(declaringBean, manager);
        }
        return true;
    }
}

