/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.Payload;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptions;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.ConstraintOrigin;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.location.BeanConstraintLocation;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.annotationfactory.AnnotationDescriptor;
import org.hibernate.validator.internal.util.annotationfactory.AnnotationFactory;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.xml.AnnotationType;
import org.hibernate.validator.internal.xml.BeanType;
import org.hibernate.validator.internal.xml.ClassType;
import org.hibernate.validator.internal.xml.ConstraintDefinitionType;
import org.hibernate.validator.internal.xml.ConstraintMappingsType;
import org.hibernate.validator.internal.xml.ConstraintType;
import org.hibernate.validator.internal.xml.ElementType;
import org.hibernate.validator.internal.xml.FieldType;
import org.hibernate.validator.internal.xml.GetterType;
import org.hibernate.validator.internal.xml.GroupSequenceType;
import org.hibernate.validator.internal.xml.GroupsType;
import org.hibernate.validator.internal.xml.PayloadType;
import org.hibernate.validator.internal.xml.ValidatedByType;
import org.xml.sax.SAXException;

public class XmlMappingParser {
    private static final Log log = LoggerFactory.make();
    private static final String VALIDATION_MAPPING_XSD = "META-INF/validation-mapping-1.0.xsd";
    private static final String MESSAGE_PARAM = "message";
    private static final String GROUPS_PARAM = "groups";
    private static final String PAYLOAD_PARAM = "payload";
    private static final String PACKAGE_SEPARATOR = ".";
    private final Set<Class<?>> processedClasses = CollectionHelper.newHashSet();
    private final ConstraintHelper constraintHelper;
    private final AnnotationProcessingOptions annotationProcessingOptions;
    private final Map<Class<?>, Set<MetaConstraint<?>>> constraintMap;
    private final Map<Class<?>, List<Member>> cascadedMembers;
    private final Map<Class<?>, List<Class<?>>> defaultSequences;

    public XmlMappingParser(ConstraintHelper constraintHelper) {
        this.constraintHelper = constraintHelper;
        this.annotationProcessingOptions = new AnnotationProcessingOptions();
        this.constraintMap = CollectionHelper.newHashMap();
        this.cascadedMembers = CollectionHelper.newHashMap();
        this.defaultSequences = CollectionHelper.newHashMap();
    }

    public final void parse(Set<InputStream> mappingStreams) {
        Schema schema = this.getMappingSchema();
        try {
            JAXBContext jc = JAXBContext.newInstance(ConstraintMappingsType.class);
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(schema);
            for (InputStream in : mappingStreams) {
                ConstraintMappingsType mapping = this.getValidationConfig(in, unmarshaller);
                String defaultPackage = mapping.getDefaultPackage();
                this.parseConstraintDefinitions(mapping.getConstraintDefinition(), defaultPackage);
                for (BeanType bean : mapping.getBean()) {
                    Class<?> beanClass = this.getClass(bean.getClazz(), defaultPackage);
                    this.checkClassHasNotBeenProcessed(this.processedClasses, beanClass);
                    this.annotationProcessingOptions.ignoreAnnotationConstraintForClass(beanClass, bean.getIgnoreAnnotations());
                    this.parseClassLevelOverrides(bean.getClassType(), beanClass, defaultPackage);
                    this.parseFieldLevelOverrides(bean.getField(), beanClass, defaultPackage);
                    this.parsePropertyLevelOverrides(bean.getGetter(), beanClass, defaultPackage);
                    this.processedClasses.add(beanClass);
                }
            }
        }
        catch (JAXBException e) {
            throw log.getErrorParsingMappingFileException(e);
        }
    }

    public final Set<Class<?>> getXmlConfiguredClasses() {
        return this.processedClasses;
    }

    public final AnnotationProcessingOptions getAnnotationProcessingOptions() {
        return this.annotationProcessingOptions;
    }

    public final <T> Set<MetaConstraint<?>> getConstraintsForClass(Class<T> beanClass) {
        Set<MetaConstraint<?>> theValue = this.constraintMap.get(beanClass);
        return theValue != null ? theValue : Collections.emptySet();
    }

    public final List<Member> getCascadedMembersForClass(Class<?> beanClass) {
        if (this.cascadedMembers.containsKey(beanClass)) {
            return this.cascadedMembers.get(beanClass);
        }
        return Collections.emptyList();
    }

    public final List<Class<?>> getDefaultSequenceForClass(Class<?> beanClass) {
        return this.defaultSequences.get(beanClass);
    }

    private void parseConstraintDefinitions(List<ConstraintDefinitionType> constraintDefinitionList, String defaultPackage) {
        for (ConstraintDefinitionType constraintDefinition : constraintDefinitionList) {
            String annotationClassName = constraintDefinition.getAnnotation();
            Class<?> clazz = this.getClass(annotationClassName, defaultPackage);
            if (!clazz.isAnnotation()) {
                throw log.getIsNotAnAnnotationException(annotationClassName);
            }
            Class<?> annotationClass = clazz;
            ValidatedByType validatedByType = constraintDefinition.getValidatedBy();
            ArrayList<Class<ConstraintValidator<Annotation, ?>>> constraintValidatorClasses = CollectionHelper.newArrayList();
            if (validatedByType.getIncludeExistingValidators() != null && validatedByType.getIncludeExistingValidators().booleanValue()) {
                constraintValidatorClasses.addAll(this.findConstraintValidatorClasses(annotationClass));
            }
            for (String validatorClassName : validatedByType.getValue()) {
                Class<?> validatorClass = ReflectionHelper.loadClass(validatorClassName, this.getClass());
                if (!ConstraintValidator.class.isAssignableFrom(validatorClass)) {
                    throw log.getIsNotAConstraintValidatorClassException(validatorClass);
                }
                constraintValidatorClasses.add(validatorClass);
            }
            this.constraintHelper.addConstraintValidatorDefinition(annotationClass, constraintValidatorClasses);
        }
    }

    private List<Class<? extends ConstraintValidator<? extends Annotation, ?>>> findConstraintValidatorClasses(Class<? extends Annotation> annotationType) {
        ArrayList<Class<ConstraintValidator<Annotation, ?>>> constraintValidatorDefinitionClasses = CollectionHelper.newArrayList();
        if (this.constraintHelper.isBuiltinConstraint(annotationType)) {
            constraintValidatorDefinitionClasses.addAll(this.constraintHelper.getBuiltInConstraints(annotationType));
        } else {
            Class<? extends ConstraintValidator<?, ?>>[] validatedBy = annotationType.getAnnotation(Constraint.class).validatedBy();
            constraintValidatorDefinitionClasses.addAll(Arrays.asList(validatedBy));
        }
        return constraintValidatorDefinitionClasses;
    }

    private void checkClassHasNotBeenProcessed(Set<Class<?>> processedClasses, Class<?> beanClass) {
        if (processedClasses.contains(beanClass)) {
            throw log.getBeanClassHasAlreadyBeConfiguredInXmlException(beanClass.getName());
        }
    }

    private void parseFieldLevelOverrides(List<FieldType> fields, Class<?> beanClass, String defaultPackage) {
        ArrayList fieldNames = CollectionHelper.newArrayList();
        for (FieldType fieldType : fields) {
            boolean ignoreFieldAnnotation;
            String fieldName = fieldType.getName();
            if (fieldNames.contains(fieldName)) {
                throw log.getIsDefinedTwiceInMappingXmlForBeanException(fieldName, beanClass.getName());
            }
            fieldNames.add(fieldName);
            boolean containsField = ReflectionHelper.containsDeclaredField(beanClass, fieldName);
            if (!containsField) {
                throw log.getBeanDoesNotContainTheFieldException(beanClass.getName(), fieldName);
            }
            Field field = ReflectionHelper.getDeclaredField(beanClass, fieldName);
            boolean bl = ignoreFieldAnnotation = fieldType.getIgnoreAnnotations() == null ? false : fieldType.getIgnoreAnnotations();
            if (ignoreFieldAnnotation) {
                this.annotationProcessingOptions.ignorePropertyLevelConstraintAnnotationsOnMember(field);
            }
            if (fieldType.getValid() != null) {
                this.addCascadedMember(beanClass, field);
            }
            for (ConstraintType constraint : fieldType.getConstraint()) {
                MetaConstraint<?> metaConstraint = this.createMetaConstraint(constraint, beanClass, field, defaultPackage);
                this.addMetaConstraint(beanClass, metaConstraint);
            }
        }
    }

    private void parsePropertyLevelOverrides(List<GetterType> getters, Class<?> beanClass, String defaultPackage) {
        ArrayList getterNames = CollectionHelper.newArrayList();
        for (GetterType getterType : getters) {
            boolean ignoreGetterAnnotation;
            String getterName = getterType.getName();
            if (getterNames.contains(getterName)) {
                throw log.getIsDefinedTwiceInMappingXmlForBeanException(getterName, beanClass.getName());
            }
            getterNames.add(getterName);
            boolean containsMethod = ReflectionHelper.containsMethodWithPropertyName(beanClass, getterName);
            if (!containsMethod) {
                throw log.getBeanDoesNotContainThePropertyException(beanClass.getName(), getterName);
            }
            Method method = ReflectionHelper.getMethodFromPropertyName(beanClass, getterName);
            boolean bl = ignoreGetterAnnotation = getterType.getIgnoreAnnotations() == null ? false : getterType.getIgnoreAnnotations();
            if (ignoreGetterAnnotation) {
                this.annotationProcessingOptions.ignorePropertyLevelConstraintAnnotationsOnMember(method);
            }
            if (getterType.getValid() != null) {
                this.addCascadedMember(beanClass, method);
            }
            for (ConstraintType constraint : getterType.getConstraint()) {
                MetaConstraint<?> metaConstraint = this.createMetaConstraint(constraint, beanClass, method, defaultPackage);
                this.addMetaConstraint(beanClass, metaConstraint);
            }
        }
    }

    private void parseClassLevelOverrides(ClassType classType, Class<?> beanClass, String defaultPackage) {
        List<Class<?>> groupSequence;
        if (classType == null) {
            return;
        }
        if (classType.getIgnoreAnnotations() != null) {
            this.annotationProcessingOptions.ignoreClassLevelConstraintAnnotations(beanClass, classType.getIgnoreAnnotations());
        }
        if (!(groupSequence = this.createGroupSequence(classType.getGroupSequence(), defaultPackage)).isEmpty()) {
            this.defaultSequences.put(beanClass, groupSequence);
        }
        for (ConstraintType constraint : classType.getConstraint()) {
            MetaConstraint<?> metaConstraint = this.createMetaConstraint(constraint, beanClass, null, defaultPackage);
            this.addMetaConstraint(beanClass, metaConstraint);
        }
    }

    private void addMetaConstraint(Class<?> beanClass, MetaConstraint<?> metaConstraint) {
        if (this.constraintMap.containsKey(beanClass)) {
            this.constraintMap.get(beanClass).add(metaConstraint);
        } else {
            HashSet constraintList = CollectionHelper.newHashSet();
            constraintList.add(metaConstraint);
            this.constraintMap.put(beanClass, constraintList);
        }
    }

    private void addCascadedMember(Class<?> beanClass, Member member) {
        if (this.cascadedMembers.containsKey(beanClass)) {
            this.cascadedMembers.get(beanClass).add(member);
        } else {
            ArrayList tmpList = CollectionHelper.newArrayList();
            tmpList.add(member);
            this.cascadedMembers.put(beanClass, tmpList);
        }
    }

    private List<Class<?>> createGroupSequence(GroupSequenceType groupSequenceType, String defaultPackage) {
        ArrayList<Class<?>> groupSequence = CollectionHelper.newArrayList();
        if (groupSequenceType != null) {
            for (String groupName : groupSequenceType.getValue()) {
                Class<?> group2 = this.getClass(groupName, defaultPackage);
                groupSequence.add(group2);
            }
        }
        return groupSequence;
    }

    private <A extends Annotation, T> MetaConstraint<?> createMetaConstraint(ConstraintType constraint, Class<T> beanClass, Member member, String defaultPackage) {
        Object annotation;
        Class<?> annotationClass = this.getClass(constraint.getAnnotation(), defaultPackage);
        AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(annotationClass);
        if (constraint.getMessage() != null) {
            annotationDescriptor.setValue(MESSAGE_PARAM, constraint.getMessage());
        }
        annotationDescriptor.setValue(GROUPS_PARAM, this.getGroups(constraint.getGroups(), defaultPackage));
        annotationDescriptor.setValue(PAYLOAD_PARAM, this.getPayload(constraint.getPayload(), defaultPackage));
        for (ElementType elementType : constraint.getElement()) {
            String name = elementType.getName();
            this.checkNameIsValid(name);
            Class<?> returnType = this.getAnnotationParameterType(annotationClass, name);
            Object elementValue = this.getElementValue(elementType, returnType);
            annotationDescriptor.setValue(name, elementValue);
        }
        try {
            annotation = AnnotationFactory.create(annotationDescriptor);
        }
        catch (RuntimeException e) {
            throw log.getUnableToCreateAnnotationForConfiguredConstraintException(e.getMessage(), e);
        }
        java.lang.annotation.ElementType type2 = java.lang.annotation.ElementType.TYPE;
        if (member instanceof Method) {
            type2 = java.lang.annotation.ElementType.METHOD;
        } else if (member instanceof Field) {
            type2 = java.lang.annotation.ElementType.FIELD;
        }
        ConstraintDescriptorImpl constraintDescriptor = new ConstraintDescriptorImpl(annotation, this.constraintHelper, type2, ConstraintOrigin.DEFINED_LOCALLY);
        return new MetaConstraint(constraintDescriptor, new BeanConstraintLocation(beanClass, member));
    }

    private <A extends Annotation> Class<?> getAnnotationParameterType(Class<A> annotationClass, String name) {
        Method m = ReflectionHelper.getMethod(annotationClass, name);
        if (m == null) {
            throw log.getAnnotationDoesNotContainAParameterException(annotationClass.getName(), name);
        }
        return m.getReturnType();
    }

    private Object getElementValue(ElementType elementType, Class<?> returnType) {
        this.removeEmptyContentElements(elementType);
        boolean isArray = returnType.isArray();
        if (!isArray) {
            if (elementType.getContent().size() != 1) {
                throw log.getAttemptToSpecifyAnArrayWhereSingleValueIsExpectedException();
            }
            return this.getSingleValue(elementType.getContent().get(0), returnType);
        }
        ArrayList<Object> values = CollectionHelper.newArrayList();
        for (Serializable s : elementType.getContent()) {
            values.add(this.getSingleValue(s, returnType.getComponentType()));
        }
        return values.toArray((Object[])Array.newInstance(returnType.getComponentType(), values.size()));
    }

    private void removeEmptyContentElements(ElementType elementType) {
        ArrayList contentToDelete = CollectionHelper.newArrayList();
        for (Serializable content : elementType.getContent()) {
            if (!(content instanceof String) || !((String)((Object)content)).matches("[\\n ].*")) continue;
            contentToDelete.add(content);
        }
        elementType.getContent().removeAll(contentToDelete);
    }

    private Object getSingleValue(Serializable serializable, Class<?> returnType) {
        Object returnValue;
        if (serializable instanceof String) {
            String value = (String)((Object)serializable);
            returnValue = this.convertStringToReturnType(returnType, value);
        } else if (serializable instanceof JAXBElement && ((JAXBElement)serializable).getDeclaredType().equals(String.class)) {
            JAXBElement elem = (JAXBElement)serializable;
            String value = (String)elem.getValue();
            returnValue = this.convertStringToReturnType(returnType, value);
        } else if (serializable instanceof JAXBElement && ((JAXBElement)serializable).getDeclaredType().equals(AnnotationType.class)) {
            JAXBElement elem = (JAXBElement)serializable;
            AnnotationType annotationType = (AnnotationType)elem.getValue();
            try {
                Class<?> annotationClass = returnType;
                returnValue = this.createAnnotation(annotationType, annotationClass);
            }
            catch (ClassCastException e) {
                throw log.getUnexpectedParameterValueException(e);
            }
        } else {
            throw log.getUnexpectedParameterValueException();
        }
        return returnValue;
    }

    private <A extends Annotation> Annotation createAnnotation(AnnotationType annotationType, Class<A> returnType) {
        AnnotationDescriptor<A> annotationDescriptor = new AnnotationDescriptor<A>(returnType);
        for (ElementType elementType : annotationType.getElement()) {
            String name = elementType.getName();
            Class<?> parameterType = this.getAnnotationParameterType(returnType, name);
            Object elementValue = this.getElementValue(elementType, parameterType);
            annotationDescriptor.setValue(name, elementValue);
        }
        return AnnotationFactory.create(annotationDescriptor);
    }

    private Object convertStringToReturnType(Class<?> returnType, String value) {
        Class<?> returnValue;
        if (returnType.getName().equals(Byte.TYPE.getName())) {
            try {
                returnValue = Byte.parseByte(value);
            }
            catch (NumberFormatException e) {
                throw log.getInvalidNumberFormatException("byte", e);
            }
        }
        if (returnType.getName().equals(Short.TYPE.getName())) {
            try {
                returnValue = Short.parseShort(value);
            }
            catch (NumberFormatException e) {
                throw log.getInvalidNumberFormatException("short", e);
            }
        }
        if (returnType.getName().equals(Integer.TYPE.getName())) {
            try {
                returnValue = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw log.getInvalidNumberFormatException("int", e);
            }
        }
        if (returnType.getName().equals(Long.TYPE.getName())) {
            try {
                returnValue = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw log.getInvalidNumberFormatException("long", e);
            }
        }
        if (returnType.getName().equals(Float.TYPE.getName())) {
            try {
                returnValue = Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException e) {
                throw log.getInvalidNumberFormatException("float", e);
            }
        }
        if (returnType.getName().equals(Double.TYPE.getName())) {
            try {
                returnValue = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw log.getInvalidNumberFormatException("double", e);
            }
        }
        if (returnType.getName().equals(Boolean.TYPE.getName())) {
            returnValue = Boolean.parseBoolean(value);
        } else if (returnType.getName().equals(Character.TYPE.getName())) {
            if (value.length() != 1) {
                throw log.getInvalidCharValueException(value);
            }
            returnValue = Character.valueOf(value.charAt(0));
        } else if (returnType.getName().equals(String.class.getName())) {
            returnValue = value;
        } else if (returnType.getName().equals(Class.class.getName())) {
            returnValue = ReflectionHelper.loadClass(value, this.getClass());
        } else {
            try {
                Class<?> enumClass = returnType;
                returnValue = Enum.valueOf(enumClass, value);
            }
            catch (ClassCastException e) {
                throw log.getInvalidReturnTypeException(returnType, e);
            }
        }
        return returnValue;
    }

    private void checkNameIsValid(String name) {
        if (MESSAGE_PARAM.equals(name) || GROUPS_PARAM.equals(name)) {
            throw log.getReservedParameterNamesException(MESSAGE_PARAM, GROUPS_PARAM, PAYLOAD_PARAM);
        }
    }

    private Class<?>[] getGroups(GroupsType groupsType, String defaultPackage) {
        if (groupsType == null) {
            return new Class[0];
        }
        ArrayList<Class> groupList = CollectionHelper.newArrayList();
        for (String groupClass : groupsType.getValue()) {
            groupList.add(this.getClass(groupClass, defaultPackage));
        }
        return groupList.toArray(new Class[groupList.size()]);
    }

    private Class<? extends Payload>[] getPayload(PayloadType payloadType, String defaultPackage) {
        if (payloadType == null) {
            return new Class[0];
        }
        ArrayList<Class> payloadList = CollectionHelper.newArrayList();
        for (String groupClass : payloadType.getValue()) {
            Class<?> payload = this.getClass(groupClass, defaultPackage);
            if (!Payload.class.isAssignableFrom(payload)) {
                throw log.getWrongPayloadClassException(payload.getName());
            }
            payloadList.add(payload);
        }
        return payloadList.toArray(new Class[payloadList.size()]);
    }

    private Class<?> getClass(String clazz, String defaultPackage) {
        String fullyQualifiedClass = this.isQualifiedClass(clazz) ? clazz : defaultPackage + PACKAGE_SEPARATOR + clazz;
        return ReflectionHelper.loadClass(fullyQualifiedClass, this.getClass());
    }

    private boolean isQualifiedClass(String clazz) {
        return clazz.contains(PACKAGE_SEPARATOR);
    }

    private Schema getMappingSchema() {
        ClassLoader loader = ReflectionHelper.getClassLoaderFromClass(XmlMappingParser.class);
        URL schemaUrl = loader.getResource(VALIDATION_MAPPING_XSD);
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        try {
            schema = sf.newSchema(schemaUrl);
        }
        catch (SAXException e) {
            log.unableToCreateSchema(VALIDATION_MAPPING_XSD, e.getMessage());
        }
        return schema;
    }

    private ConstraintMappingsType getValidationConfig(InputStream in, Unmarshaller unmarshaller) {
        ConstraintMappingsType constraintMappings;
        try {
            boolean markSupported = in.markSupported();
            if (markSupported) {
                in.mark(Integer.MAX_VALUE);
            }
            StreamSource stream = new StreamSource(new CloseIgnoringInputStream(in));
            JAXBElement<ConstraintMappingsType> root = unmarshaller.unmarshal(stream, ConstraintMappingsType.class);
            constraintMappings = root.getValue();
            if (markSupported) {
                try {
                    in.reset();
                }
                catch (IOException e) {
                    log.debug("Unable to reset input stream.");
                }
            }
        }
        catch (JAXBException e) {
            throw log.getErrorParsingMappingFileException(e);
        }
        return constraintMappings;
    }

    public class CloseIgnoringInputStream
    extends FilterInputStream {
        public CloseIgnoringInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() {
        }
    }
}

