/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import javax.validation.ConfigurationSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.ResourceLoaderHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.xml.PropertyType;
import org.hibernate.validator.internal.xml.ValidationConfigType;
import org.hibernate.validator.internal.xml.ValidationXmlConfigurationSource;
import org.xml.sax.SAXException;

public class ValidationXmlParser {
    private static final Log log = LoggerFactory.make();
    private static final String VALIDATION_XML_FILE = "META-INF/validation.xml";
    private static final String VALIDATION_CONFIGURATION_XSD = "META-INF/validation-configuration-1.1.xsd";

    public final ConfigurationSource parseValidationXml() {
        ValidationConfigType config = this.getValidationConfig();
        if (config != null) {
            HashMap<String, String> properties = new HashMap<String, String>();
            for (PropertyType property : config.getProperty()) {
                if (log.isDebugEnabled()) {
                    log.debugf("Found property '%s' with value '%s' in validation.xml.", (Object)property.getName(), (Object)property.getValue());
                }
                properties.put(property.getName(), property.getValue());
            }
            return new ValidationXmlConfigurationSource(config.getDefaultProvider(), config.getConstraintValidatorFactory(), config.getMessageInterpolator(), config.getTraversableResolver(), config.getParameterNameProvider(), new HashSet<String>(config.getConstraintMapping()), properties);
        }
        return new ValidationXmlConfigurationSource();
    }

    private ValidationConfigType getValidationConfig() {
        ValidationConfigType validationConfig;
        log.debugf("Trying to load %s for XML based Validator configuration.", (Object)VALIDATION_XML_FILE);
        InputStream inputStream = ResourceLoaderHelper.getInputStreamForPath(VALIDATION_XML_FILE);
        if (inputStream == null) {
            log.debugf("No %s found. Using annotation based configuration only.", (Object)VALIDATION_XML_FILE);
            return null;
        }
        log.parsingXMLFile(VALIDATION_XML_FILE);
        Schema schema = this.getValidationConfigurationSchema();
        try {
            JAXBContext jc = JAXBContext.newInstance(ValidationConfigType.class);
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(schema);
            StreamSource stream = new StreamSource(inputStream);
            JAXBElement<ValidationConfigType> root = unmarshaller.unmarshal(stream, ValidationConfigType.class);
            validationConfig = root.getValue();
        }
        catch (JAXBException e) {
            throw log.getUnableToParseValidationXmlFileException(VALIDATION_XML_FILE, e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException io) {
                log.unableToCloseXMLFileInputStream(VALIDATION_XML_FILE);
            }
        }
        return validationConfig;
    }

    private Schema getValidationConfigurationSchema() {
        ClassLoader loader = ReflectionHelper.getClassLoaderFromClass(ValidationXmlParser.class);
        URL schemaUrl = loader.getResource(VALIDATION_CONFIGURATION_XSD);
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        try {
            schema = sf.newSchema(schemaUrl);
        }
        catch (SAXException e) {
            log.unableToCreateSchema(VALIDATION_CONFIGURATION_XSD, e.getMessage());
        }
        return schema;
    }
}

