/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.raw;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import javax.validation.ParameterNameProvider;
import org.hibernate.validator.internal.util.ReflectionHelper;

public abstract class ExecutableElement {
    public static ExecutableElement forConstructor(Constructor<?> constructor) {
        return new ConstructorElement(constructor);
    }

    public static ExecutableElement forMethod(Method method) {
        return new MethodElement(method);
    }

    private ExecutableElement() {
    }

    public abstract String[] getParameterNames(ParameterNameProvider var1);

    public abstract Annotation[][] getParameterAnnotations();

    public abstract Class<?>[] getParameterTypes();

    public abstract Class<?> getReturnType();

    public abstract Type[] getGenericParameterTypes();

    public abstract AccessibleObject getAccessibleObject();

    public abstract Member getMember();

    public abstract ElementType getElementType();

    public abstract String getSimpleName();

    public abstract boolean isGetterMethod();

    public String getIdentifier() {
        return this.getMember().getName() + Arrays.toString(this.getParameterTypes());
    }

    private static class ConstructorElement
    extends ExecutableElement {
        private final Constructor<?> constructor;

        private ConstructorElement(Constructor<?> method) {
            this.constructor = method;
        }

        @Override
        public String[] getParameterNames(ParameterNameProvider parameterNameProvider) {
            return parameterNameProvider.getParameterNames(this.constructor);
        }

        @Override
        public Annotation[][] getParameterAnnotations() {
            return this.constructor.getParameterAnnotations();
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.constructor.getParameterTypes();
        }

        @Override
        public Class<?> getReturnType() {
            return this.constructor.getDeclaringClass();
        }

        @Override
        public Type[] getGenericParameterTypes() {
            return this.constructor.getGenericParameterTypes();
        }

        @Override
        public AccessibleObject getAccessibleObject() {
            return this.constructor;
        }

        @Override
        public Member getMember() {
            return this.constructor;
        }

        @Override
        public ElementType getElementType() {
            return ElementType.CONSTRUCTOR;
        }

        @Override
        public String getSimpleName() {
            return this.constructor.getDeclaringClass().getSimpleName();
        }

        @Override
        public boolean isGetterMethod() {
            return false;
        }
    }

    private static class MethodElement
    extends ExecutableElement {
        private final Method method;

        public MethodElement(Method method) {
            this.method = method;
        }

        @Override
        public String[] getParameterNames(ParameterNameProvider parameterNameProvider) {
            return parameterNameProvider.getParameterNames(this.method);
        }

        @Override
        public Annotation[][] getParameterAnnotations() {
            return this.method.getParameterAnnotations();
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.method.getParameterTypes();
        }

        @Override
        public Class<?> getReturnType() {
            return this.method.getReturnType();
        }

        @Override
        public Type[] getGenericParameterTypes() {
            return this.method.getGenericParameterTypes();
        }

        @Override
        public AccessibleObject getAccessibleObject() {
            return this.method;
        }

        @Override
        public Member getMember() {
            return this.method;
        }

        @Override
        public ElementType getElementType() {
            return ElementType.METHOD;
        }

        @Override
        public String getSimpleName() {
            return this.method.getName();
        }

        @Override
        public boolean isGetterMethod() {
            return ReflectionHelper.isGetterMethod(this.method);
        }
    }
}

