/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintDeclarationException;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.ParameterDescriptor;
import javax.validation.metadata.ReturnValueDescriptor;
import org.hibernate.validator.internal.metadata.aggregated.AbstractConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.MetaDataBuilder;
import org.hibernate.validator.internal.metadata.aggregated.ParameterMetaData;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.ExecutableDescriptorImpl;
import org.hibernate.validator.internal.metadata.descriptor.ReturnValueDescriptorImpl;
import org.hibernate.validator.internal.metadata.location.MethodConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedMethod;
import org.hibernate.validator.internal.metadata.raw.ConstrainedParameter;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ExecutableMetaData
extends AbstractConstraintMetaData {
    private static final Log log = LoggerFactory.make();
    private final Class<?>[] parameterTypes;
    private final List<ParameterMetaData> parameterMetaDataList;
    private final ConstraintDeclarationException parameterConstraintDeclarationException;
    private final String identifier;

    private ExecutableMetaData(String name, Class<?> returnType, Class<?>[] parameterTypes, ConstraintMetaData.ConstraintMetaDataKind kind, Set<MetaConstraint<?>> returnValueConstraints, List<ParameterMetaData> parameterMetaData, ConstraintDeclarationException parameterConstraintDeclarationException, boolean isCascading, boolean isConstrained) {
        super(name, returnType, returnValueConstraints, kind, isCascading, isConstrained);
        this.parameterTypes = parameterTypes;
        this.parameterMetaDataList = Collections.unmodifiableList(parameterMetaData);
        this.parameterConstraintDeclarationException = parameterConstraintDeclarationException;
        this.identifier = name + Arrays.toString(parameterTypes);
    }

    public void assertCorrectnessOfMethodParameterConstraints() throws ConstraintDeclarationException {
        if (this.parameterConstraintDeclarationException != null) {
            throw this.parameterConstraintDeclarationException;
        }
    }

    public ParameterMetaData getParameterMetaData(int parameterIndex) {
        if (parameterIndex < 0 || parameterIndex > this.parameterMetaDataList.size() - 1) {
            throw log.getInvalidMethodParameterIndexException(this.getName(), parameterIndex);
        }
        return this.parameterMetaDataList.get(parameterIndex);
    }

    public List<ParameterMetaData> getAllParameterMetaData() {
        return this.parameterMetaDataList;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public ElementDescriptor asDescriptor(boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        if (super.getKind() == ConstraintMetaData.ConstraintMetaDataKind.METHOD) {
            return new ExecutableDescriptorImpl(this.getType(), this.getName(), this.asDescriptors(this.getConstraints()), this.returnValueAsDescriptor(defaultGroupSequenceRedefined, defaultGroupSequence), this.parametersAsDescriptors(defaultGroupSequenceRedefined, defaultGroupSequence), defaultGroupSequenceRedefined, defaultGroupSequence);
        }
        return new ExecutableDescriptorImpl(this.getType(), this.asDescriptors(this.getConstraints()), this.returnValueAsDescriptor(defaultGroupSequenceRedefined, defaultGroupSequence), this.parametersAsDescriptors(defaultGroupSequenceRedefined, defaultGroupSequence), defaultGroupSequenceRedefined, defaultGroupSequence);
    }

    private List<ParameterDescriptor> parametersAsDescriptors(boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        ArrayList<ParameterDescriptor> theValue = CollectionHelper.newArrayList();
        for (ParameterMetaData parameterMetaData : this.parameterMetaDataList) {
            theValue.add((ParameterDescriptor)parameterMetaData.asDescriptor(defaultGroupSequenceRedefined, (List)defaultGroupSequence));
        }
        return theValue;
    }

    private ReturnValueDescriptor returnValueAsDescriptor(boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        ReturnValueDescriptorImpl returnValueDescriptor = new ReturnValueDescriptorImpl(this.getType(), this.asDescriptors(this.getConstraints()), this.isCascading(), defaultGroupSequenceRedefined, defaultGroupSequence);
        return returnValueDescriptor;
    }

    @Override
    public String toString() {
        StringBuilder parameterBuilder = new StringBuilder();
        for (Class<?> oneParameterType : this.getParameterTypes()) {
            parameterBuilder.append(oneParameterType.getSimpleName());
            parameterBuilder.append(", ");
        }
        String parameters = parameterBuilder.length() > 0 ? parameterBuilder.substring(0, parameterBuilder.length() - 2) : parameterBuilder.toString();
        return "ExecutableMetaData [method=" + this.getType() + " " + this.getName() + "(" + parameters + "), isCascading=" + this.isCascading() + ", isConstrained=" + this.isConstrained() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.parameterTypes);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExecutableMetaData other = (ExecutableMetaData)obj;
        return Arrays.equals(this.parameterTypes, other.parameterTypes);
    }

    public static class Builder
    extends MetaDataBuilder {
        private final ConstrainedElement.ConstrainedElementKind kind;
        private final Set<ConstrainedMethod> constrainedMethods = CollectionHelper.newHashSet();
        private final MethodConstraintLocation location;
        private final Set<MetaConstraint<?>> returnValueConstraints = CollectionHelper.newHashSet();
        private boolean isCascading = false;
        private boolean isConstrained = false;

        public Builder(ConstrainedMethod constrainedMethod, ConstraintHelper constraintHelper) {
            super(constraintHelper);
            this.kind = constrainedMethod.getKind();
            this.location = constrainedMethod.getLocation();
            this.add(constrainedMethod);
        }

        @Override
        public boolean accepts(ConstrainedElement constrainedElement) {
            return this.kind == constrainedElement.getKind() && ReflectionHelper.haveSameSignature(this.location.getExecutableElement(), ((ConstrainedMethod)constrainedElement).getLocation().getExecutableElement());
        }

        @Override
        public void add(ConstrainedElement constrainedElement) {
            ConstrainedMethod constrainedMethod = (ConstrainedMethod)constrainedElement;
            this.constrainedMethods.add(constrainedMethod);
            this.isCascading = this.isCascading || constrainedMethod.isCascading();
            this.isConstrained = this.isConstrained || constrainedMethod.isConstrained();
            this.returnValueConstraints.addAll(constrainedMethod.getConstraints());
        }

        @Override
        public ExecutableMetaData build() {
            ExecutableElement executableElement = this.location.getExecutableElement();
            return new ExecutableMetaData(executableElement.getMember().getName(), executableElement.getReturnType(), executableElement.getParameterTypes(), this.kind == ConstrainedElement.ConstrainedElementKind.CONSTRUCTOR ? ConstraintMetaData.ConstraintMetaDataKind.CONSTRUCTOR : ConstraintMetaData.ConstraintMetaDataKind.METHOD, this.adaptOriginsAndImplicitGroups(this.location.getBeanClass(), this.returnValueConstraints), this.findParameterMetaData(), this.checkParameterConstraints(), this.isCascading, this.isConstrained);
        }

        private List<ParameterMetaData> findParameterMetaData() {
            ArrayList<ParameterMetaData.Builder> parameterBuilders = null;
            for (ConstrainedMethod oneMethod : this.constrainedMethods) {
                if (parameterBuilders == null) {
                    parameterBuilders = CollectionHelper.newArrayList();
                    for (ConstrainedParameter oneParameter : oneMethod.getAllParameterMetaData()) {
                        parameterBuilders.add(new ParameterMetaData.Builder(this.location.getBeanClass(), oneParameter, this.constraintHelper));
                    }
                    continue;
                }
                int i = 0;
                for (ConstrainedParameter oneParameter : oneMethod.getAllParameterMetaData()) {
                    ((ParameterMetaData.Builder)parameterBuilders.get(i)).add(oneParameter);
                    ++i;
                }
            }
            ArrayList<ParameterMetaData> parameterMetaDatas = CollectionHelper.newArrayList();
            for (ParameterMetaData.Builder oneBuilder : parameterBuilders) {
                parameterMetaDatas.add(oneBuilder.build());
            }
            return parameterMetaDatas;
        }

        private ConstraintDeclarationException checkParameterConstraints() {
            Set<ConstrainedMethod> methodsWithParameterConstraints = this.getMethodsWithParameterConstraints(this.constrainedMethods);
            if (methodsWithParameterConstraints.isEmpty()) {
                return null;
            }
            HashSet definingTypes = CollectionHelper.newHashSet();
            for (ConstrainedMethod constrainedMethod : methodsWithParameterConstraints) {
                definingTypes.add(constrainedMethod.getLocation().getBeanClass());
            }
            if (definingTypes.size() > 1) {
                return new ConstraintDeclarationException("Only the root method of an overridden method in an inheritance hierarchy may be annotated with parameter constraints, but there are parameter constraints defined at all of the following overridden methods: " + methodsWithParameterConstraints);
            }
            ConstrainedMethod constrainedMethod = methodsWithParameterConstraints.iterator().next();
            for (ConstrainedMethod oneMethod : this.constrainedMethods) {
                if (constrainedMethod.getLocation().getBeanClass().isAssignableFrom(oneMethod.getLocation().getBeanClass())) continue;
                return new ConstraintDeclarationException("Only the root method of an overridden method in an inheritance hierarchy may be annotated with parameter constraints. The following method itself has no parameter constraints but it is not defined on a sub-type of " + constrainedMethod.getLocation().getBeanClass() + ": " + oneMethod);
            }
            return null;
        }

        private Set<ConstrainedMethod> getMethodsWithParameterConstraints(Iterable<ConstrainedMethod> methods) {
            HashSet<ConstrainedMethod> theValue = CollectionHelper.newHashSet();
            for (ConstrainedMethod oneMethod : methods) {
                if (!oneMethod.hasParameterConstraints()) continue;
                theValue.add(oneMethod);
            }
            return theValue;
        }
    }
}

