/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.path;

import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.validation.Path;
import org.hibernate.validator.internal.engine.path.BeanMetaDataLocator;
import org.hibernate.validator.internal.metadata.BeanMetaDataManager;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.ReflectionHelper;

public class BeanMetaDataLocatorInstanceTraversal
extends BeanMetaDataLocator {
    private final Object rootBean;
    private final BeanMetaDataManager beanMetaDataManager;

    BeanMetaDataLocatorInstanceTraversal(Object rootBean, BeanMetaDataManager beanMetaDataManager) {
        this.rootBean = rootBean;
        this.beanMetaDataManager = beanMetaDataManager;
    }

    @Override
    public Iterator<BeanMetaData<?>> beanMetaDataIterator(Iterator<Path.Node> nodeIterator) {
        Contracts.assertNotNull(nodeIterator);
        ArrayList metaDataList = new ArrayList();
        Object currentValue = this.rootBean;
        Class<?> currentClass = this.rootBean.getClass();
        block0: while (nodeIterator.hasNext()) {
            Path.Node node = nodeIterator.next();
            BeanMetaData<?> beanMetaData = this.beanMetaDataManager.getBeanMetaData(currentClass);
            metaDataList.add(beanMetaData);
            Set<Member> members = beanMetaData.getCascadedMembers();
            for (Member member : members) {
                if (!ReflectionHelper.getPropertyName(member).equals(node.getName())) continue;
                if ((currentValue = ReflectionHelper.getValue(member, currentValue)) == null) continue block0;
                currentClass = currentValue.getClass();
                Iterator<?> iter = ReflectionHelper.createIteratorForCascadedValue(currentClass, currentValue);
                currentValue = iter.next();
                currentClass = currentValue.getClass();
                continue block0;
            }
        }
        return metaDataList.iterator();
    }
}

