/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.path;

import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.validation.Path;
import org.hibernate.validator.internal.engine.path.BeanMetaDataLocator;
import org.hibernate.validator.internal.metadata.BeanMetaDataManager;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.ReflectionHelper;

public class BeanMetaDataLocatorClassTraversal
extends BeanMetaDataLocator {
    private final Class<?> rootBeanClass;
    private final BeanMetaDataManager beanMetaDataManager;

    BeanMetaDataLocatorClassTraversal(Class<?> rootBeanClass, BeanMetaDataManager beanMetaDataManager) {
        this.rootBeanClass = rootBeanClass;
        this.beanMetaDataManager = beanMetaDataManager;
    }

    @Override
    public Iterator<BeanMetaData<?>> beanMetaDataIterator(Iterator<Path.Node> nodeIterator) {
        Contracts.assertNotNull(nodeIterator);
        ArrayList metaDataList = new ArrayList();
        Class<?> currentClass = this.rootBeanClass;
        block0: while (nodeIterator.hasNext()) {
            Path.Node node = nodeIterator.next();
            BeanMetaData<?> beanMetaData = this.beanMetaDataManager.getBeanMetaData(currentClass);
            metaDataList.add(beanMetaData);
            Set<Member> members = beanMetaData.getCascadedMembers();
            for (Member member : members) {
                if (!ReflectionHelper.getPropertyName(member).equals(node.getName())) continue;
                currentClass = ReflectionHelper.getType(member);
                if (!ReflectionHelper.isIterable(currentClass)) continue block0;
                currentClass = (Class<?>)ReflectionHelper.getIndexedType(currentClass);
                continue block0;
            }
        }
        return metaDataList.iterator();
    }
}

