/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.constraintvalidation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintViolation;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.constraints.CompositionType;
import org.hibernate.validator.internal.engine.ValidationContext;
import org.hibernate.validator.internal.engine.ValueContext;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorContextImpl;
import org.hibernate.validator.internal.engine.path.MessageAndPath;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ConstraintTree<A extends Annotation> {
    private static final Log log = LoggerFactory.make();
    private final ConstraintTree<?> parent;
    private final List<ConstraintTree<?>> children;
    private final ConstraintDescriptorImpl<A> descriptor;

    public ConstraintTree(ConstraintDescriptorImpl<A> descriptor) {
        this(descriptor, null);
    }

    private ConstraintTree(ConstraintDescriptorImpl<A> descriptor, ConstraintTree<?> parent) {
        this.parent = parent;
        this.descriptor = descriptor;
        HashSet<ConstraintDescriptorImpl> composingConstraints = CollectionHelper.newHashSet();
        for (ConstraintDescriptor<?> composingConstraint : descriptor.getComposingConstraints()) {
            composingConstraints.add((ConstraintDescriptorImpl)composingConstraint);
        }
        this.children = new ArrayList(composingConstraints.size());
        for (ConstraintDescriptorImpl composingDescriptor : composingConstraints) {
            ConstraintTree treeNode = this.createConstraintTree(composingDescriptor);
            this.children.add(treeNode);
        }
    }

    private <U extends Annotation> ConstraintTree<U> createConstraintTree(ConstraintDescriptorImpl<U> composingDescriptor) {
        return new ConstraintTree<U>(composingDescriptor, this);
    }

    public final List<ConstraintTree<?>> getChildren() {
        return this.children;
    }

    public final ConstraintDescriptorImpl<A> getDescriptor() {
        return this.descriptor;
    }

    public final <T, U, V, E extends ConstraintViolation<T>> boolean validateConstraints(ValidationContext<T, E> executionContext, ValueContext<U, V> valueContext) {
        HashSet constraintViolations = CollectionHelper.newHashSet();
        this.validateConstraints(executionContext, valueContext, constraintViolations);
        if (!constraintViolations.isEmpty()) {
            executionContext.addConstraintFailures(constraintViolations);
            return false;
        }
        return true;
    }

    private <T, U, V, E extends ConstraintViolation<T>> void validateConstraints(ValidationContext<T, E> executionContext, ValueContext<U, V> valueContext, Set<E> constraintViolations) {
        CompositionResult compositionResult = this.validateComposingConstraints(executionContext, valueContext, constraintViolations);
        HashSet localViolationList = CollectionHelper.newHashSet();
        if (!(this.descriptor.getConstraintValidatorClasses().isEmpty() || executionContext.isFailFastModeEnabled() && !constraintViolations.isEmpty())) {
            if (log.isTraceEnabled()) {
                log.tracef("Validating value %s against constraint defined by %s.", (Object)valueContext.getCurrentValidatedValue(), (Object)this.descriptor);
            }
            ConstraintValidatorContextImpl constraintValidatorContext = new ConstraintValidatorContextImpl(valueContext.getPropertyPath(), this.descriptor);
            ConstraintValidator validator = executionContext.getConstraintValidatorManager().getInitializedValidator(valueContext.getTypeOfAnnotatedElement(), this.descriptor, executionContext.getConstraintValidatorFactory());
            this.validateSingleConstraint(executionContext, valueContext, constraintValidatorContext, validator, localViolationList);
            if (localViolationList.isEmpty()) {
                compositionResult.setAtLeastOneTrue(true);
            } else {
                compositionResult.setAllTrue(false);
            }
        }
        if (!this.passesCompositionTypeRequirement(constraintViolations, compositionResult)) {
            this.prepareFinalConstraintViolations(executionContext, valueContext, constraintViolations, localViolationList);
        }
    }

    private <T, U, V, E extends ConstraintViolation<T>> void prepareFinalConstraintViolations(ValidationContext<T, E> executionContext, ValueContext<U, V> valueContext, Set<E> constraintViolations, Set<E> localViolationList) {
        if (this.reportAsSingleViolation()) {
            constraintViolations.clear();
            if (localViolationList.isEmpty()) {
                String message = (String)this.getDescriptor().getAttributes().get("message");
                MessageAndPath messageAndPath = new MessageAndPath(message, valueContext.getPropertyPath());
                E violation = executionContext.createConstraintViolation(valueContext, messageAndPath, this.descriptor);
                constraintViolations.add(violation);
            }
        }
        constraintViolations.addAll(localViolationList);
    }

    private <T, U, V, E extends ConstraintViolation<T>> CompositionResult validateComposingConstraints(ValidationContext<T, E> executionContext, ValueContext<U, V> valueContext, Set<E> constraintViolations) {
        CompositionResult compositionResult = new CompositionResult(true, false);
        for (ConstraintTree<?> tree : this.getChildren()) {
            HashSet tmpViolationList = CollectionHelper.newHashSet();
            super.validateConstraints(executionContext, valueContext, tmpViolationList);
            constraintViolations.addAll(tmpViolationList);
            if (tmpViolationList.isEmpty()) {
                compositionResult.setAtLeastOneTrue(true);
                if (this.descriptor.getCompositionType() != CompositionType.OR) continue;
                break;
            }
            compositionResult.setAllTrue(false);
            if (!executionContext.isFailFastModeEnabled() || this.descriptor.getCompositionType() != CompositionType.AND) continue;
            break;
        }
        return compositionResult;
    }

    private boolean passesCompositionTypeRequirement(Set<?> constraintViolations, CompositionResult compositionResult) {
        CompositionType compositionType = this.getDescriptor().getCompositionType();
        boolean passedValidation = false;
        switch (compositionType) {
            case OR: {
                passedValidation = compositionResult.isAtLeastOneTrue();
                break;
            }
            case AND: {
                passedValidation = compositionResult.isAllTrue();
                break;
            }
            case ALL_FALSE: {
                boolean bl = passedValidation = !compositionResult.isAtLeastOneTrue();
            }
        }
        assert (!passedValidation || compositionType != CompositionType.AND || constraintViolations.isEmpty());
        if (passedValidation) {
            constraintViolations.clear();
        }
        return passedValidation;
    }

    private <T, U, V, E extends ConstraintViolation<T>> Set<E> validateSingleConstraint(ValidationContext<T, E> executionContext, ValueContext<U, V> valueContext, ConstraintValidatorContextImpl constraintValidatorContext, ConstraintValidator<A, V> validator, Set<E> constraintViolations) {
        boolean isValid;
        try {
            isValid = validator.isValid(valueContext.getCurrentValidatedValue(), constraintValidatorContext);
        }
        catch (RuntimeException e) {
            throw log.getExceptionDuringIsValidCall(e);
        }
        if (!isValid) {
            constraintViolations.addAll(executionContext.createConstraintViolations(valueContext, constraintValidatorContext));
        }
        return constraintViolations;
    }

    private boolean reportAsSingleViolation() {
        return this.getDescriptor().isReportAsSingleViolation() || this.getDescriptor().getCompositionType() == CompositionType.ALL_FALSE;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConstraintTree");
        sb.append("{ descriptor=").append(this.descriptor);
        sb.append(", isRoot=").append(this.parent == null);
        sb.append('}');
        return sb.toString();
    }

    private static final class CompositionResult {
        private boolean allTrue;
        private boolean atLeastOneTrue;

        CompositionResult(boolean allTrue, boolean atLeastOneTrue) {
            this.allTrue = allTrue;
            this.atLeastOneTrue = atLeastOneTrue;
        }

        public boolean isAllTrue() {
            return this.allTrue;
        }

        public boolean isAtLeastOneTrue() {
            return this.atLeastOneTrue;
        }

        public void setAllTrue(boolean allTrue) {
            this.allTrue = allTrue;
        }

        public void setAtLeastOneTrue(boolean atLeastOneTrue) {
            this.atLeastOneTrue = atLeastOneTrue;
        }
    }
}

