/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.internal.engine.MethodValidationContext;
import org.hibernate.validator.internal.engine.StandardValidationContext;
import org.hibernate.validator.internal.engine.ValueContext;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorContextImpl;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorManager;
import org.hibernate.validator.internal.engine.path.MessageAndPath;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.hibernate.validator.internal.metadata.BeanMetaDataManager;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.IdentitySet;

public abstract class ValidationContext<T, C extends ConstraintViolation<T>> {
    private final BeanMetaDataManager beanMetaDataManager;
    private final ConstraintValidatorManager constraintValidatorManager;
    private final T rootBean;
    private final Class<T> rootBeanClass;
    private final Map<Class<?>, IdentitySet> processedObjects;
    private final Map<Object, Set<PathImpl>> processedPaths;
    private final Set<C> failingConstraintViolations;
    private boolean allowOneValidationPerPath = true;
    protected final MessageInterpolator messageInterpolator;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final TraversableResolver traversableResolver;
    private final boolean failFast;

    public static <T> ValidationContext<T, ConstraintViolation<T>> getContextForValidate(BeanMetaDataManager beanMetaDataManager, ConstraintValidatorManager constraintValidatorManager, T object, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver, boolean failFast) {
        Class<?> rootBeanClass = object.getClass();
        return new StandardValidationContext(beanMetaDataManager, constraintValidatorManager, rootBeanClass, object, messageInterpolator, constraintValidatorFactory, traversableResolver, failFast);
    }

    public static <T> ValidationContext<T, ConstraintViolation<T>> getContextForValidateProperty(BeanMetaDataManager beanMetaDataManager, ConstraintValidatorManager constraintValidatorManager, T rootBean, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver, boolean failFast) {
        Class<?> rootBeanClass = rootBean.getClass();
        return new StandardValidationContext(beanMetaDataManager, constraintValidatorManager, rootBeanClass, rootBean, messageInterpolator, constraintValidatorFactory, traversableResolver, failFast);
    }

    public static <T> ValidationContext<T, ConstraintViolation<T>> getContextForValidateValue(BeanMetaDataManager beanMetaDataManager, ConstraintValidatorManager constraintValidatorManager, Class<T> rootBeanClass, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver, boolean failFast) {
        return new StandardValidationContext<Object>(beanMetaDataManager, constraintValidatorManager, rootBeanClass, null, messageInterpolator, constraintValidatorFactory, traversableResolver, failFast);
    }

    public static <T> MethodValidationContext<T> getContextForValidateParameters(BeanMetaDataManager beanMetaDataManager, ConstraintValidatorManager constraintValidatorManager, ExecutableElement executable, Object[] parameterValues, T object, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver, boolean failFast) {
        Class<?> rootBeanClass = object != null ? object.getClass() : executable.getMember().getDeclaringClass();
        return new MethodValidationContext(beanMetaDataManager, constraintValidatorManager, rootBeanClass, object, executable, parameterValues, messageInterpolator, constraintValidatorFactory, traversableResolver, failFast);
    }

    protected ValidationContext(BeanMetaDataManager beanMetaDataManager, ConstraintValidatorManager constraintValidatorManager, Class<T> rootBeanClass, T rootBean, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver, boolean failFast) {
        this.beanMetaDataManager = beanMetaDataManager;
        this.constraintValidatorManager = constraintValidatorManager;
        this.rootBean = rootBean;
        this.rootBeanClass = rootBeanClass;
        this.messageInterpolator = messageInterpolator;
        this.constraintValidatorFactory = constraintValidatorFactory;
        this.traversableResolver = traversableResolver;
        this.failFast = failFast;
        this.processedObjects = new HashMap();
        this.processedPaths = new IdentityHashMap<Object, Set<PathImpl>>();
        this.failingConstraintViolations = new HashSet<C>();
    }

    public final T getRootBean() {
        return this.rootBean;
    }

    public final Class<T> getRootBeanClass() {
        return this.rootBeanClass;
    }

    public final TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    public final boolean isFailFastModeEnabled() {
        return this.failFast;
    }

    public BeanMetaDataManager getBeanMetaDataManager() {
        return this.beanMetaDataManager;
    }

    public ConstraintValidatorManager getConstraintValidatorManager() {
        return this.constraintValidatorManager;
    }

    public final <U, V> List<C> createConstraintViolations(ValueContext<U, V> localContext, ConstraintValidatorContextImpl constraintValidatorContext) {
        ArrayList<C> constraintViolations = new ArrayList<C>();
        for (MessageAndPath messageAndPath : constraintValidatorContext.getMessageAndPathList()) {
            C violation = this.createConstraintViolation(localContext, messageAndPath, constraintValidatorContext.getConstraintDescriptor());
            constraintViolations.add(violation);
        }
        return constraintViolations;
    }

    public final ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory;
    }

    public boolean isAlreadyValidated(Object value, Class<?> group2, PathImpl path) {
        boolean alreadyValidated = this.isAlreadyValidatedForCurrentGroup(value, group2);
        if (alreadyValidated && this.allowOneValidationPerPath) {
            alreadyValidated = this.isAlreadyValidatedForPath(value, path);
        }
        return alreadyValidated;
    }

    public void markProcessed(Object value, Class<?> group2, PathImpl path) {
        this.markProcessForCurrentGroup(value, group2);
        if (this.allowOneValidationPerPath) {
            this.markProcessedForCurrentPath(value, path);
        }
    }

    public final void addConstraintFailures(Set<C> failingConstraintViolations) {
        this.failingConstraintViolations.addAll(failingConstraintViolations);
    }

    public Set<C> getFailingConstraints() {
        return this.failingConstraintViolations;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ValidationContext");
        sb.append("{rootBean=").append(this.rootBean);
        sb.append('}');
        return sb.toString();
    }

    public abstract <U, V> C createConstraintViolation(ValueContext<U, V> var1, MessageAndPath var2, ConstraintDescriptor<?> var3);

    private boolean isAlreadyValidatedForPath(Object value, PathImpl path) {
        Set<PathImpl> pathSet = this.processedPaths.get(value);
        if (pathSet == null) {
            return false;
        }
        for (PathImpl p : pathSet) {
            if (!path.isRootPath() && !p.isRootPath() && !this.isSubPathOf(path, p) && !this.isSubPathOf(p, path)) continue;
            return true;
        }
        return false;
    }

    private boolean isSubPathOf(Path p1, Path p2) {
        Iterator p1Iter = p1.iterator();
        Iterator p2Iter = p2.iterator();
        while (p1Iter.hasNext()) {
            Path.Node p1Node = (Path.Node)p1Iter.next();
            if (!p2Iter.hasNext()) {
                return false;
            }
            Path.Node p2Node = (Path.Node)p2Iter.next();
            if (p1Node.equals(p2Node)) continue;
            return false;
        }
        return true;
    }

    private boolean isAlreadyValidatedForCurrentGroup(Object value, Class<?> group2) {
        IdentitySet objectsProcessedInCurrentGroups = this.processedObjects.get(group2);
        return objectsProcessedInCurrentGroups != null && objectsProcessedInCurrentGroups.contains(value);
    }

    private void markProcessedForCurrentPath(Object value, PathImpl path) {
        if (this.processedPaths.containsKey(value)) {
            this.processedPaths.get(value).add(path);
        } else {
            HashSet<PathImpl> set = new HashSet<PathImpl>();
            set.add(path);
            this.processedPaths.put(value, set);
        }
    }

    private void markProcessForCurrentGroup(Object value, Class<?> group2) {
        if (this.processedObjects.containsKey(group2)) {
            this.processedObjects.get(group2).add(value);
        } else {
            IdentitySet set = new IdentitySet();
            set.add(value);
            this.processedObjects.put(group2, set);
        }
    }
}

