/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.connector;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Enumeration;
import javax.enterprise.deploy.shared.ModuleType;
import javax.inject.Singleton;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.javaee.core.deployment.ApplicationHolder;
import org.glassfish.weld.connector.WeldSniffer;
import org.jvnet.hk2.annotations.Service;

@Service(name="weldCompositeSniffer")
@Singleton
public class WeldCompositeSniffer
extends WeldSniffer {
    @Override
    public boolean handles(DeploymentContext context) {
        ArchiveType archiveType = this.habitat.getService(ArchiveType.class, context.getArchiveHandler().getArchiveType(), new Annotation[0]);
        if (archiveType != null && !this.supportsArchiveType(archiveType)) {
            return false;
        }
        boolean isWeldApplication = false;
        ApplicationHolder holder = context.getModuleMetaData(ApplicationHolder.class);
        ReadableArchive appRoot = context.getSource();
        if (holder != null && holder.app != null) {
            isWeldApplication = this.scanLibDir(appRoot, holder.app.getLibraryDirectory(), context);
        }
        return isWeldApplication;
    }

    @Override
    public boolean supportsArchiveType(ArchiveType archiveType) {
        return archiveType.toString().equals(ModuleType.EAR.toString());
    }

    private boolean scanLibDir(ReadableArchive archive, String libLocation, DeploymentContext context) {
        boolean entryPresent = false;
        if (libLocation != null && !libLocation.isEmpty()) {
            Enumeration<String> entries = archive.entries(libLocation);
            while (entries.hasMoreElements() && !entryPresent) {
                String entryName = entries.nextElement();
                if (!entryName.endsWith(".jar") || entryName.indexOf(47, libLocation.length() + 1) != -1) continue;
                try {
                    ReadableArchive jarInLib = archive.getSubArchive(entryName);
                    entryPresent = this.isEntryPresent(jarInLib, "META-INF/beans.xml");
                    jarInLib.close();
                    if (!entryPresent) continue;
                    break;
                }
                catch (IOException e) {
                }
            }
        }
        return entryPresent;
    }

    private boolean isEntryPresent(ReadableArchive archive, String entry) {
        boolean entryPresent = false;
        try {
            entryPresent = archive.exists(entry);
        }
        catch (IOException e) {
            // empty catch block
        }
        return entryPresent;
    }
}

