/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Map;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.Globals;
import org.glassfish.javaee.full.deployment.EarLibClassLoader;
import org.jboss.weld.bootstrap.api.Singleton;
import org.jboss.weld.bootstrap.api.SingletonProvider;

public class ACLSingletonProvider
extends SingletonProvider {
    public <T> ACLSingleton<T> create(Class<? extends T> expectedType) {
        return new ACLSingleton();
    }

    private static class ACLSingleton<T>
    implements Singleton<T> {
        private final Map<ClassLoader, T> store = new Hashtable<ClassLoader, T>();
        private ClassLoader ccl = Globals.get(ClassLoaderHierarchy.class).getCommonClassLoader();
        private static ClassLoader bootstrapCL;

        private ACLSingleton() {
        }

        @Override
        public T get() {
            ClassLoader acl = this.getClassLoader();
            T instance = this.store.get(acl);
            if (instance == null) {
                throw new IllegalStateException("Singleton not set for " + acl);
            }
            return instance;
        }

        private ClassLoader getClassLoader() {
            ClassLoader tccl;
            SecurityManager sm = System.getSecurityManager();
            ClassLoader classLoader = tccl = sm != null ? AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            }) : Thread.currentThread().getContextClassLoader();
            if (tccl == null) {
                throw new RuntimeException("Thread's context class loader is null");
            }
            ClassLoader cl = tccl;
            while (cl != this.ccl && cl != bootstrapCL) {
                if (cl instanceof EarLibClassLoader) {
                    return cl;
                }
                cl = this.getParent(cl);
            }
            return tccl;
        }

        private ClassLoader getParent(final ClassLoader cl) {
            SecurityManager sm = System.getSecurityManager();
            return sm != null ? AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return cl.getParent();
                }
            }) : cl.getParent();
        }

        @Override
        public void set(T object) {
            this.store.put(this.getClassLoader(), object);
        }

        @Override
        public void clear() {
            this.store.remove(this.getClassLoader());
        }

        @Override
        public boolean isSet() {
            return this.store.containsKey(this.getClassLoader());
        }

        static {
            SecurityManager sm = System.getSecurityManager();
            bootstrapCL = sm != null ? AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Object.class.getClassLoader();
                }
            }) : Object.class.getClassLoader();
        }
    }
}

