/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.websocket.platform.processors;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.glassfish.websocket.api.annotations.WebSocketClose;
import org.glassfish.websocket.api.annotations.WebSocketError;
import org.glassfish.websocket.api.annotations.WebSocketMessage;
import org.glassfish.websocket.api.annotations.WebSocketOpen;
import org.glassfish.websocket.platform.processors.ClassAndMethodsHolder;
import org.glassfish.websocket.platform.processors.ClassPathMethodHolder;
import org.glassfish.websocket.platform.processors.ClassWriter;
import org.glassfish.websocket.platform.processors.MethodWriter;
import org.glassfish.websocket.platform.processors.ProcessorUtils;
import org.glassfish.websocket.platform.processors.RemoteProcessor;

@SupportedAnnotationTypes(value={"org.glassfish.websocket.api.annotations.WebSocket", "org.glassfish.websocket.annotations.api.WebSocketMessage", "org.glassfish.websocket.annotations.api.WebSocketClose", "org.glassfish.websocket.annotations.api.WebSocketOpen", "org.glassfish.websocket.annotations.api.WebSocketError", "org.glassfish.websocket.annotations.api.WebSocketContext", "org.glassfish.websocket.annotations.api.WebSocketRemote"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class WSProcessor
extends AbstractProcessor {
    public static String getWrapperClassnameFor(String qualifiedClassname, String path) {
        String className = qualifiedClassname.substring(qualifiedClassname.lastIndexOf(".") + 1, qualifiedClassname.length());
        String fakePath = path.replace("/", "_");
        return className + "_BeanWrapper" + "_at_" + fakePath;
    }

    public static String getQualifiedClassnameFor(String qualifiedClassname, String path) {
        return ProcessorUtils.getWrapperPackageNameFor(qualifiedClassname) + "." + WSProcessor.getWrapperClassnameFor(qualifiedClassname, path);
    }

    public boolean process(Set annotations, RoundEnvironment roundEnv) {
        RemoteProcessor rp = new RemoteProcessor(this.processingEnv);
        rp.process(annotations, roundEnv);
        return this.processReceiverMethods(annotations, roundEnv, rp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processReceiverMethods(Set annotations, RoundEnvironment roundEnv, RemoteProcessor rp) {
        Map<String, ClassAndMethodsHolder> pathToClassAndMethodsHolder = this.analyzeWSAnnotations(annotations, roundEnv);
        for (String eachPath : pathToClassAndMethodsHolder.keySet()) {
            try {
                ClassAndMethodsHolder eachClassAndMethodsHolder = pathToClassAndMethodsHolder.get(eachPath);
                TypeElement eachClazz = eachClassAndMethodsHolder.getClazz();
                Set eachMethods = eachClassAndMethodsHolder.getMethods();
                String wrapperPackage = ProcessorUtils.getWrapperPackageNameFor(eachClazz.getQualifiedName().toString());
                String wrapperClassname = WSProcessor.getWrapperClassnameFor(eachClazz.getQualifiedName().toString(), eachPath);
                JavaFileObject f = this.processingEnv.getFiler().createSourceFile(wrapperPackage + "." + wrapperClassname, new Element[0]);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Creating " + f.toUri());
                Writer w = f.openWriter();
                try {
                    PrintWriter pw = new PrintWriter(w);
                    ClassWriter.writeClass(wrapperPackage, wrapperClassname, eachClazz, eachMethods, rp, pw);
                    pw.flush();
                }
                finally {
                    w.close();
                }
            }
            catch (IOException x) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, x.toString());
            }
        }
        return true;
    }

    private Map<String, ClassAndMethodsHolder> analyzeWSAnnotations(Set annotations, RoundEnvironment roundEnv) {
        HashMap<String, ClassAndMethodsHolder> pathToClassAndMethodsHolder = new HashMap<String, ClassAndMethodsHolder>();
        ArrayList<ClassPathMethodHolder> classPathMethodHolders = new ArrayList<ClassPathMethodHolder>();
        ArrayList<Element> annotatedElements = new ArrayList<Element>();
        annotatedElements.addAll(roundEnv.getElementsAnnotatedWith(WebSocketMessage.class));
        annotatedElements.addAll(roundEnv.getElementsAnnotatedWith(WebSocketClose.class));
        annotatedElements.addAll(roundEnv.getElementsAnnotatedWith(WebSocketOpen.class));
        annotatedElements.addAll(roundEnv.getElementsAnnotatedWith(WebSocketError.class));
        for (Element element : roundEnv.getRootElements()) {
            String pathForClass = MethodWriter.getClassLevelPath(element);
            if (element instanceof TypeElement) {
                for (Element annotatedThing : annotatedElements) {
                    HashSet annotatedMethods = new HashSet();
                    if (annotatedThing.getKind() != ElementKind.METHOD || annotatedThing.getEnclosingElement() != element) continue;
                    String pathForEndPoint = pathForClass;
                    ClassPathMethodHolder cpmh = new ClassPathMethodHolder((TypeElement)element, pathForEndPoint, annotatedThing);
                    classPathMethodHolders.add(cpmh);
                }
                continue;
            }
            throw new RuntimeException("I don't know whut");
        }
        for (ClassPathMethodHolder classPathMethodHolder : classPathMethodHolders) {
            ClassAndMethodsHolder camh;
            String nextPath = classPathMethodHolder.getPath();
            if (pathToClassAndMethodsHolder.get(nextPath) != null) {
                camh = (ClassAndMethodsHolder)pathToClassAndMethodsHolder.get(nextPath);
                camh.getMethods().add(classPathMethodHolder.getMethod());
                continue;
            }
            HashSet<Element> s = new HashSet<Element>();
            s.add(classPathMethodHolder.getMethod());
            camh = new ClassAndMethodsHolder(classPathMethodHolder.getClazz(), s);
            pathToClassAndMethodsHolder.put(nextPath, camh);
        }
        return pathToClassAndMethodsHolder;
    }

    private List<Element> getElementsForClazz(Map<Element, TypeElement> elementToClassMap, TypeElement clazz) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Element e : elementToClassMap.keySet()) {
            TypeElement nextClazz = elementToClassMap.get(e);
            if (!nextClazz.equals(clazz)) continue;
            elements.add(e);
        }
        return elements;
    }
}

