/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.websocket.platform.processors;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.glassfish.websocket.api.Peer;
import org.glassfish.websocket.api.annotations.WebSocketRemote;
import org.glassfish.websocket.platform.processors.ProcessorUtils;
import org.glassfish.websocket.platform.processors.RemoteClassWriter;

public class RemoteProcessor {
    private ProcessingEnvironment processingEnv;
    private Map<Element, Element> methodToClassMap;
    private Map<Element, List<Element>> classToMethodListMap;
    private Map<String, String> interfaceToImplementationFQClassnames = new HashMap<String, String>();

    public RemoteProcessor(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    public String getImplementationFor(String remoteInterfaceName) {
        return this.interfaceToImplementationFQClassnames.get(remoteInterfaceName);
    }

    public static String getWrapperClassnameFor(String classname) {
        String className = classname.substring(classname.lastIndexOf(".") + 1, classname.length());
        return className + "_RemoteImpl";
    }

    private boolean createRemoteImpls(Set annotations, RoundEnvironment roundEnv) {
        try {
            this.classToMethodListMap = new HashMap<Element, List<Element>>();
            for (Element element : roundEnv.getRootElements()) {
                WebSocketRemote wsr = element.getAnnotation(WebSocketRemote.class);
                if (wsr == null || this.getMethods(element) == null) continue;
                List<Element> aMethods = this.getMethods(element);
                this.checkImplementsPeer(element);
                this.classToMethodListMap.put(element, aMethods);
                String nextClazzQualName = ((TypeElement)element).getQualifiedName().toString();
                String wrapperPackage = ProcessorUtils.getWrapperPackageNameFor(nextClazzQualName);
                String wrapperClassname = RemoteProcessor.getWrapperClassnameFor(nextClazzQualName);
                String wrapperFQName = wrapperPackage + "." + wrapperClassname;
                this.interfaceToImplementationFQClassnames.put(nextClazzQualName, wrapperFQName);
                JavaFileObject f = this.processingEnv.getFiler().createSourceFile(wrapperFQName, new Element[0]);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Creating " + f.toUri());
                Writer w = f.openWriter();
                try {
                    PrintWriter pw = new PrintWriter(w);
                    RemoteClassWriter.writePackageAndImports(pw, wrapperPackage);
                    pw.println();
                    RemoteClassWriter.writeClassDeclaration(element, pw, nextClazzQualName, wrapperClassname, aMethods, wsr);
                    pw.println();
                    pw.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return true;
    }

    private void checkImplementsPeer(Element nextClass) {
        boolean ok = false;
        TypeElement te = (TypeElement)nextClass;
        List<? extends TypeMirror> interfaces = te.getInterfaces();
        String wsRemoteName = Peer.class.getName();
        for (TypeMirror typeMirror : te.getInterfaces()) {
            System.out.println(((Object)typeMirror).toString());
            if (!wsRemoteName.equals(((Object)typeMirror).toString())) continue;
            ok = true;
        }
        if (!ok) {
            throw new RuntimeException(nextClass + "does not implement WSRemote");
        }
    }

    private List<Element> getMethods(Element clazz) {
        ArrayList<Element> l = new ArrayList<Element>();
        if (clazz instanceof TypeElement) {
            for (Element element : clazz.getEnclosedElements()) {
                if (element.getKind() != ElementKind.METHOD || element.getEnclosingElement() != clazz) continue;
                l.add(element);
            }
        }
        return l;
    }

    private List<Element> getAnnotatedMethods(Element clazz) {
        ArrayList<Element> l = new ArrayList<Element>();
        if (clazz instanceof TypeElement) {
            for (Element element : clazz.getEnclosedElements()) {
                WebSocketRemote remoteAn;
                if (element.getKind() != ElementKind.METHOD || element.getEnclosingElement() != clazz || (remoteAn = element.getAnnotation(WebSocketRemote.class)) == null) continue;
                l.add(element);
            }
        }
        return l;
    }

    public boolean process(Set annotations, RoundEnvironment roundEnv) {
        return this.createRemoteImpls(annotations, roundEnv);
    }

    private Map<Element, Element> analyzeAnnotatedElements(Set annotations, RoundEnvironment roundEnv) {
        HashMap<Element, Element> methodToClassMap = new HashMap<Element, Element>();
        for (Element element : roundEnv.getRootElements()) {
            if (!(element instanceof TypeElement)) continue;
            for (Element element2 : element.getEnclosedElements()) {
                WebSocketRemote remoteAn;
                if (element2.getKind() != ElementKind.METHOD || element2.getEnclosingElement() != element || (remoteAn = element2.getAnnotation(WebSocketRemote.class)) == null) continue;
                methodToClassMap.put(element2, element);
            }
        }
        return methodToClassMap;
    }
}

