/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.websocket.platform.processors;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.glassfish.websocket.api.annotations.WebSocketRemote;

public class RemoteClassWriter {
    static void writePackageAndImports(PrintWriter pw, String packageName) throws IOException {
        pw.println("package " + packageName + ";");
        pw.println();
        pw.println("import org.glassfish.grizzly.websockets.WebSocket;");
        pw.println("import org.glassfish.websocket.platform.*;");
        pw.println("import org.glassfish.websocket.api.ConversionException;");
        pw.println("import java.util.*;");
        pw.println("import java.io.*;");
        pw.println();
    }

    static void writeClassDeclaration(Element clazz, PrintWriter pw, String interfaceName, String classname, List<Element> methods, WebSocketRemote wsr) {
        pw.println("public class " + classname + " extends WebSocketWrapper implements " + interfaceName + " {");
        pw.println();
        pw.println("\tprivate String[] encoders = {");
        List<String> l = RemoteClassWriter.getEncoderClassesFrom((TypeElement)clazz, wsr);
        for (String c : l) {
            String quotedString = "\"" + c + "\"";
            if (l.indexOf(c) == 0) {
                pw.println("\t\t" + quotedString);
                continue;
            }
            pw.println("\t\t," + quotedString);
        }
        pw.println("\t};");
        pw.println();
        pw.println("");
        RemoteClassWriter.writeSendMethodImplementations(pw, methods);
        pw.println("}");
    }

    static List<String> getEncodersFrom(WebSocketRemote wsr) {
        return null;
    }

    static List<String> getEncoderClassesFrom(TypeElement clazz, WebSocketRemote wsr) {
        ArrayList<String> encoders = new ArrayList<String>();
        for (AnnotationMirror annotationMirror : clazz.getAnnotationMirrors()) {
            boolean isAmWebSocketTypeMirror = annotationMirror.getAnnotationType().toString().equals(WebSocketRemote.class.getCanonicalName());
            if (!isAmWebSocketTypeMirror) continue;
            for (ExecutableElement executableElement : annotationMirror.getElementValues().keySet()) {
                if (!executableElement.getSimpleName().toString().equals("encoders")) continue;
                List encodersL = (List)annotationMirror.getElementValues().get(executableElement).getValue();
                for (Object nextDecoderClassnameDotClass : encodersL) {
                    String dotClassname = nextDecoderClassnameDotClass.toString();
                    String classname = dotClassname.substring(0, dotClassname.length() - 6);
                    encoders.add(classname);
                }
            }
        }
        return encoders;
    }

    static void writeSendMethodImplementations(PrintWriter pw, List<Element> methods) {
        for (Element method : methods) {
            String methodName = method.getSimpleName().toString();
            WebSocketRemote wsr = method.getAnnotation(WebSocketRemote.class);
            ExecutableElement eMethod = (ExecutableElement)method;
            VariableElement ve = eMethod.getParameters().get(0);
            String parameterClassname = ((Object)ve.asType()).toString();
            String parameterName = ve.getSimpleName().toString();
            pw.println("\tpublic void " + methodName + "(" + parameterClassname + " " + parameterName + ") throws IOException, ConversionException {");
            pw.println("\t\tsuper.sendPolymorphic(" + parameterName + ", this.encoders);");
            pw.println();
            pw.println("\t}");
        }
        pw.println();
    }
}

